/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;

public final class FluidInteractionRegistry {
    private static final Map<FluidType, List<InteractionInformation>> INTERACTIONS = new HashMap<FluidType, List<InteractionInformation>>();

    public static synchronized void addInteraction(FluidType source, InteractionInformation interaction) {
        INTERACTIONS.computeIfAbsent(source, s -> new ArrayList()).add(interaction);
    }

    public static boolean canInteract(Level level, BlockPos pos) {
        FluidState state = level.getFluidState(pos);
        for (Direction direction : LiquidBlock.POSSIBLE_FLOW_DIRECTIONS) {
            BlockPos relativePos = pos.relative(direction.getOpposite());
            List interactions = INTERACTIONS.getOrDefault(state.getFluidType(), Collections.emptyList());
            for (InteractionInformation interaction : interactions) {
                if (!interaction.predicate().test(level, pos, relativePos, state)) continue;
                interaction.interaction().interact(level, pos, relativePos, state);
                return true;
            }
        }
        return false;
    }

    static {
        FluidInteractionRegistry.addInteraction(NeoForgeMod.LAVA_TYPE.get(), new InteractionInformation(NeoForgeMod.WATER_TYPE.get(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState()));
        FluidInteractionRegistry.addInteraction(NeoForgeMod.LAVA_TYPE.get(), new InteractionInformation((level, currentPos, relativePos, currentState) -> level.getBlockState(currentPos.below()).is(Blocks.SOUL_SOIL) && level.getBlockState(relativePos).is(Blocks.BLUE_ICE), Blocks.BASALT.defaultBlockState()));
    }

    public record InteractionInformation(HasFluidInteraction predicate, FluidInteraction interaction) {
        public InteractionInformation(FluidType type, BlockState state) {
            this(type, (FluidState fluidState) -> state);
        }

        public InteractionInformation(HasFluidInteraction predicate, BlockState state) {
            this(predicate, (FluidState fluidState) -> state);
        }

        public InteractionInformation(FluidType type, Function<FluidState, BlockState> getState) {
            this((Level level, BlockPos currentPos, BlockPos relativePos, FluidState currentState) -> level.getFluidState(relativePos).getFluidType() == type, getState);
        }

        public InteractionInformation(HasFluidInteraction predicate, Function<FluidState, BlockState> getState) {
            this(predicate, (Level level, BlockPos currentPos, BlockPos relativePos, FluidState currentState) -> {
                level.setBlockAndUpdate(currentPos, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, currentPos, currentPos, (BlockState)getState.apply(currentState)));
                level.levelEvent(1501, currentPos, 0);
            });
        }
    }

    @FunctionalInterface
    public static interface HasFluidInteraction {
        public boolean test(Level var1, BlockPos var2, BlockPos var3, FluidState var4);
    }

    @FunctionalInterface
    public static interface FluidInteraction {
        public void interact(Level var1, BlockPos var2, BlockPos var3, FluidState var4);
    }
}

