/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event.brewing;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import org.jetbrains.annotations.NotNull;

public abstract class PotionBrewEvent
extends Event {
    private NonNullList<ItemStack> stacks;

    protected PotionBrewEvent(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    @NotNull
    public ItemStack getItem(int index) {
        if (index < 0 || index >= this.stacks.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        if (index < this.stacks.size()) {
            this.stacks.set(index, (Object)stack);
        }
    }

    public int getLength() {
        return this.stacks.size();
    }

    public static class Post
    extends PotionBrewEvent {
        public Post(NonNullList<ItemStack> stacks) {
            super(stacks);
        }
    }

    public static class Pre
    extends PotionBrewEvent
    implements ICancellableEvent {
        public Pre(NonNullList<ItemStack> stacks) {
            super(stacks);
        }
    }
}

