/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.stream.Stream;

public class NeoForgeExtraCodecs {
    public static <T> MapCodec<T> aliasedFieldOf(Codec<T> codec, String ... names) {
        if (names.length == 0) {
            throw new IllegalArgumentException("Must have at least one name!");
        }
        MapCodec<T> mapCodec = codec.fieldOf(names[0]);
        for (int i = 1; i < names.length; ++i) {
            mapCodec = NeoForgeExtraCodecs.mapWithAlternative(mapCodec, codec.fieldOf(names[i]));
        }
        return mapCodec;
    }

    public static <T> MapCodec<T> mapWithAlternative(MapCodec<T> mapCodec, MapCodec<? extends T> alternative) {
        return Codec.mapEither(mapCodec, alternative).xmap(either -> either.map(Function.identity(), Function.identity()), Either::left);
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodec(Codec<T> codec, String singularName) {
        return NeoForgeExtraCodecs.singularOrPluralCodec(codec, singularName, "%ss".formatted(singularName));
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodec(Codec<T> codec, String singularName, String pluralName) {
        return Codec.mapEither((MapCodec)codec.fieldOf(singularName), (MapCodec)NeoForgeExtraCodecs.setOf(codec).fieldOf(pluralName)).xmap(either -> (Set)either.map(ImmutableSet::of, ImmutableSet::copyOf), set -> set.size() == 1 ? Either.left(set.iterator().next()) : Either.right((Object)set));
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodecNotEmpty(Codec<T> codec, String singularName) {
        return NeoForgeExtraCodecs.singularOrPluralCodecNotEmpty(codec, singularName, "%ss".formatted(singularName));
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodecNotEmpty(Codec<T> codec, String singularName, String pluralName) {
        return Codec.mapEither((MapCodec)codec.fieldOf(singularName), (MapCodec)NeoForgeExtraCodecs.setOf(codec).fieldOf(pluralName)).xmap(either -> (ImmutableSet)either.map(ImmutableSet::of, ImmutableSet::copyOf), set -> set.size() == 1 ? Either.left((Object)set.iterator().next()) : Either.right((Object)set)).flatXmap(ts -> {
            if (ts.isEmpty()) {
                return DataResult.error(() -> "The set for: %s can not be empty!".formatted(singularName));
            }
            return DataResult.success((Object)ts);
        }, ts -> {
            if (ts.isEmpty()) {
                return DataResult.error(() -> "The set for: %s can not be empty!".formatted(singularName));
            }
            return DataResult.success((Object)ImmutableSet.copyOf((Collection)ts));
        });
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> codec) {
        return Codec.list(codec).xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }

    public static <K, V> Codec<V> dispatchUnsafe(Codec<K> keyCodec, Function<? super V, ? extends K> type, Function<? super K, ? extends Codec<? extends V>> codec) {
        return NeoForgeExtraCodecs.dispatchUnsafe(keyCodec, "type", type, codec);
    }

    public static <K, V> Codec<V> dispatchUnsafe(Codec<K> keyCodec, String typeKey, Function<? super V, ? extends K> type, Function<? super K, ? extends Codec<? extends V>> codec) {
        return NeoForgeExtraCodecs.partialDispatchUnsafe(keyCodec, typeKey, type.andThen(DataResult::success), codec.andThen(DataResult::success));
    }

    public static <K, V> Codec<V> partialDispatchUnsafe(Codec<K> keyCodec, String typeKey, Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Codec<? extends V>>> codec) {
        return KeyDispatchCodec.unsafe((String)typeKey, keyCodec, type, codec, v -> ((DataResult)type.apply((Object)v)).flatMap(k -> ((DataResult)codec.apply((Object)k)).map(Function.identity())).map(e -> e)).codec();
    }

    public static <A> Decoder<List<A>> listDecoderWithOptionalElements(Decoder<Optional<A>> codec) {
        return new ListDecoderWithOptionalElements<A>(codec);
    }

    public static <A> Decoder<List<A>> listDecoderWithIndexConsumer(Decoder<List<A>> decoder, ObjIntConsumer<A> consumer) {
        return new ListDecoderWithIndexConsumer<A>(decoder, consumer);
    }

    public static <Z, A> Decoder<List<A>> listOptionalUnwrapDecoder(Decoder<List<Z>> decoder, Function<Z, Optional<A>> unwrap) {
        return new ListOptionalUnwrapDecoder<Z, A>(decoder, unwrap);
    }

    public static <A> Decoder<List<A>> listDecoder(Decoder<A> decoder) {
        return Codec.of((Encoder)Codec.unit(() -> {
            throw new UnsupportedOperationException("Cannot encode with list decoder!");
        }), decoder, (String)decoder.toString()).listOf();
    }

    public static <T> Codec<T> withAlternative(Codec<T> codec, Codec<T> alternative) {
        return new AlternativeCodec<T>(codec, alternative);
    }

    private record ListDecoderWithOptionalElements<A>(Decoder<Optional<A>> codec) implements Decoder<List<A>>
    {
        public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
                ImmutableList.Builder read = ImmutableList.builder();
                Stream.Builder failed = Stream.builder();
                AtomicReference<DataResult> result = new AtomicReference<DataResult>(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()));
                stream.accept(t -> {
                    DataResult element = this.codec.decode(ops, t);
                    element.error().ifPresent(e -> failed.add(t));
                    result.setPlain(((DataResult)result.getPlain()).apply2stable((r, v) -> {
                        ((Optional)v.getFirst()).ifPresent(arg_0 -> ((ImmutableList.Builder)read).add(arg_0));
                        return r;
                    }, element));
                });
                ImmutableList elements = read.build();
                Object errors = ops.createList(failed.build());
                Pair pair = Pair.of((Object)elements, (Object)errors);
                return result.getPlain().map(unit -> pair).setPartial((Object)pair);
            });
        }

        @Override
        public String toString() {
            return "ListDecoderWithOptionalElements[" + this.codec + "]";
        }
    }

    private record ListDecoderWithIndexConsumer<A>(Decoder<List<A>> decoder, ObjIntConsumer<A> consumer) implements Decoder<List<A>>
    {
        public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
            return this.decoder.decode(ops, input).map(pair -> {
                for (int i = 0; i < ((List)pair.getFirst()).size(); ++i) {
                    this.consumer.accept(((List)pair.getFirst()).get(i), i);
                }
                return pair;
            });
        }

        @Override
        public String toString() {
            return "ListDecoderWithIndexConsumer[" + this.decoder + "]";
        }
    }

    private record ListOptionalUnwrapDecoder<Z, A>(Decoder<List<Z>> codec, Function<Z, Optional<A>> unwrap) implements Decoder<List<A>>
    {
        public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
            return this.codec.decode(ops, input).map(pair -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                ((List)pair.getFirst()).forEach(o -> this.unwrap.apply(o).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)));
                return Pair.of((Object)builder.build(), (Object)pair.getSecond());
            });
        }

        @Override
        public String toString() {
            return "ListOptionalUnwrap[" + this.codec + "]";
        }
    }

    private record AlternativeCodec<T>(Codec<T> codec, Codec<T> alternative) implements Codec<T>
    {
        public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
            DataResult result = this.codec.decode(ops, input);
            if (result.error().isEmpty()) {
                return result;
            }
            return this.alternative.decode(ops, input);
        }

        public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
            DataResult result = this.codec.encode(input, ops, prefix);
            if (result.error().isEmpty()) {
                return result;
            }
            return this.alternative.encode(input, ops, prefix);
        }

        @Override
        public String toString() {
            return "Alternative[" + this.codec + ", " + this.alternative + "]";
        }
    }
}

