/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public abstract class JsonCodecProvider<T>
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final ExistingFileHelper.ResourceType resourceType;
    protected final PackOutput.PathProvider pathProvider;
    protected final ExistingFileHelper existingFileHelper;
    protected final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final String modid;
    protected final String directory;
    protected final Codec<T> codec;
    protected final Map<ResourceLocation, WithConditions<T>> conditions = Maps.newHashMap();

    public JsonCodecProvider(PackOutput output, PackOutput.Target target, String directory, PackType packType, Codec<T> codec, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, ExistingFileHelper existingFileHelper) {
        this.resourceType = new ExistingFileHelper.ResourceType(packType, ".json", directory);
        this.pathProvider = output.createPathProvider(target, directory);
        this.existingFileHelper = existingFileHelper;
        this.modid = modId;
        this.directory = directory;
        this.codec = codec;
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.gather();
        return this.lookupProvider.thenCompose(provider -> {
            ConditionalOps dynamicOps = ConditionalOps.create(RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider), ICondition.IContext.EMPTY);
            this.conditions.forEach((id, withConditions) -> {
                Path path = this.pathProvider.json(id);
                futuresBuilder.add((Object)CompletableFuture.supplyAsync(() -> {
                    Codec withConditionsCodec = ConditionalOps.createConditionalCodecWithConditions(this.codec).codec();
                    return (JsonElement)withConditionsCodec.encodeStart(dynamicOps, Optional.of(withConditions)).getOrThrow(false, msg -> LOGGER.error("Failed to encode {}: {}", (Object)path, msg));
                }).thenComposeAsync(encoded -> DataProvider.saveStable((CachedOutput)cache, (JsonElement)encoded, (Path)path)));
            });
            return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
        });
    }

    protected abstract void gather();

    public String getName() {
        return String.format("%s generator for %s", this.directory, this.modid);
    }

    public void unconditional(ResourceLocation id, T value) {
        this.process(id, new WithConditions<T>(List.of(), value));
    }

    public void conditionally(ResourceLocation id, Consumer<WithConditions.Builder<T>> configurator) {
        WithConditions.Builder builder = new WithConditions.Builder();
        configurator.accept(builder);
        WithConditions withConditions = builder.build();
        this.process(id, withConditions);
    }

    private void process(ResourceLocation id, WithConditions<T> withConditions) {
        this.existingFileHelper.trackGenerated(id, this.resourceType);
        this.conditions.put(id, withConditions);
    }
}

