/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class StrictNBTIngredient
extends Ingredient {
    public static final Codec<StrictNBTIngredient> CODEC = NeoForgeExtraCodecs.mapWithAlternative(((MapCodec.MapCodecCodec)ItemStack.CODEC).codec(), ItemStack.CODEC.fieldOf("stack")).xmap(StrictNBTIngredient::new, StrictNBTIngredient::getStack).codec();

    protected StrictNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack, StrictNBTIngredient::compareStacksWithNbt)), NeoForgeMod.STRICT_NBT_INGREDIENT_TYPE::get);
    }

    public static StrictNBTIngredient of(ItemStack stack) {
        return new StrictNBTIngredient(stack);
    }

    public ItemStack getStack() {
        return this.getItems()[0];
    }

    protected boolean areStacksEqual(ItemStack left, ItemStack right) {
        return StrictNBTIngredient.compareStacksWithNbt(left, right);
    }

    private static boolean compareStacksWithNbt(ItemStack left, ItemStack right) {
        return left.getItem() == right.getItem() && left.getDamageValue() == right.getDamageValue() && left.areShareTagsEqual(right);
    }

    public boolean synchronizeWithContents() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }
}

