/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;

public class DifferenceIngredient
extends Ingredient {
    public static final Codec<DifferenceIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("base").forGetter(DifferenceIngredient::getBase), (App)Ingredient.CODEC.fieldOf("subtracted").forGetter(DifferenceIngredient::getSubtracted)).apply((Applicative)builder, DifferenceIngredient::new));
    public static final Codec<DifferenceIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("base").forGetter(DifferenceIngredient::getBase), (App)Ingredient.CODEC_NONEMPTY.fieldOf("subtracted").forGetter(DifferenceIngredient::getSubtracted)).apply((Applicative)builder, DifferenceIngredient::new));
    private final Ingredient base;
    private final Ingredient subtracted;

    protected DifferenceIngredient(Ingredient base, Ingredient subtracted) {
        super(Arrays.stream(base.getValues()).map(value -> new SubtractingValue((Ingredient.Value)value, subtracted)), NeoForgeMod.DIFFERENCE_INGREDIENT_TYPE::get);
        this.base = base;
        this.subtracted = subtracted;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getSubtracted() {
        return this.subtracted;
    }

    public boolean isSimple() {
        return false;
    }

    public ItemStack[] getItems() {
        if (this.synchronizeWithContents()) {
            return super.getItems();
        }
        ArrayList list = Lists.newArrayList((Object[])this.base.getItems());
        for (ItemStack item : this.subtracted.getItems()) {
            list.removeIf(i -> this.areStacksEqual((ItemStack)i, item));
        }
        return (ItemStack[])list.toArray(ItemStack[]::new);
    }

    public boolean test(@Nullable ItemStack p_43914_) {
        if (this.synchronizeWithContents()) {
            return super.test(p_43914_);
        }
        return this.base.test(p_43914_) && !this.subtracted.test(p_43914_);
    }

    public IntList getStackingIds() {
        return super.getStackingIds();
    }

    public boolean synchronizeWithContents() {
        return this.base.synchronizeWithContents() && this.subtracted.synchronizeWithContents();
    }

    public static DifferenceIngredient of(Ingredient base, Ingredient subtracted) {
        return new DifferenceIngredient(base, subtracted);
    }

    private record SubtractingValue(Ingredient.Value inner, Ingredient subtracted) implements Ingredient.Value
    {
        public Collection<ItemStack> getItems() {
            ArrayList<ItemStack> innerItems = new ArrayList<ItemStack>(this.inner().getItems());
            innerItems.removeIf((Predicate<ItemStack>)this.subtracted);
            return innerItems;
        }
    }
}

