/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.internal;

import java.net.URI;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.neoforged.minecraftdependencies.MinecraftDependenciesPlugin;
import net.neoforged.moddevgradle.internal.ArtifactNamingStrategy;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.DataFileCollections;
import net.neoforged.moddevgradle.internal.ModDevArtifactsWorkflow;
import net.neoforged.moddevgradle.internal.ModDevRunWorkflow;
import net.neoforged.moddevgradle.internal.ModdingDependencies;
import net.neoforged.moddevgradle.internal.RepositoriesPlugin;
import net.neoforged.moddevgradle.internal.jarjar.JarJarPlugin;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.VersionCapabilitiesInternal;
import net.neoforged.moddevgradle.legacyforge.dsl.LegacyForgeExtension;
import net.neoforged.moddevgradle.legacyforge.dsl.LegacyForgeModdingSettings;
import net.neoforged.moddevgradle.legacyforge.dsl.MixinExtension;
import net.neoforged.moddevgradle.legacyforge.dsl.ObfuscationExtension;
import net.neoforged.moddevgradle.legacyforge.internal.LegacyForgeMetadataTransform;
import net.neoforged.moddevgradle.legacyforge.internal.MappingsDisambiguationRule;
import net.neoforged.moddevgradle.legacyforge.internal.McpMetadataTransform;
import net.neoforged.moddevgradle.legacyforge.internal.MinecraftMappings;
import net.neoforged.moddevgradle.legacyforge.internal.NonStrictDependencyTransform;
import net.neoforged.moddevgradle.legacyforge.internal.RemappingTransform;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapJar;
import net.neoforged.nfrtgradle.NeoFormRuntimePlugin;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class LegacyForgeModDevPlugin
implements Plugin<Project> {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyForgeModDevPlugin.class);
    public static final String MIXIN_EXTENSION = "mixin";
    public static final String OBFUSCATION_EXTENSION = "obfuscation";
    public static final String LEGACYFORGE_EXTENSION = "legacyForge";
    public static final String CONFIGURATION_TOOL_ART = "autoRenamingToolRuntime";
    public static final String CONFIGURATION_TOOL_INSTALLERTOOLS = "installerToolsRuntime";
    private final MinecraftMappings namedMappings;
    private final MinecraftMappings srgMappings;

    @Inject
    public LegacyForgeModDevPlugin(ObjectFactory objectFactory) {
        this.namedMappings = (MinecraftMappings)objectFactory.named(MinecraftMappings.class, "named");
        this.srgMappings = (MinecraftMappings)objectFactory.named(MinecraftMappings.class, "srg");
    }

    public void apply(Project project) {
        project.getPlugins().apply(JavaLibraryPlugin.class);
        project.getPlugins().apply(NeoFormRuntimePlugin.class);
        project.getPlugins().apply(MinecraftDependenciesPlugin.class);
        project.getPlugins().apply(JarJarPlugin.class);
        if (!project.getGradle().getPlugins().hasPlugin(RepositoriesPlugin.class)) {
            project.getPlugins().apply(RepositoriesPlugin.class);
        } else {
            LOG.info("Not enabling NeoForged repositories since they were applied at the settings level");
        }
        project.getRepositories().maven(repo -> {
            repo.setName("MinecraftForge");
            repo.setUrl(URI.create("https://maven.minecraftforge.net/"));
        });
        project.getDependencies().getComponents().withModule((Object)"net.neoforged:forge", LegacyForgeMetadataTransform.class);
        project.getDependencies().getComponents().withModule((Object)"net.minecraftforge:forge", LegacyForgeMetadataTransform.class);
        project.getDependencies().getComponents().withModule((Object)"de.oceanlabs.mcp:mcp_config", McpMetadataTransform.class);
        project.getDependencies().getComponents().withModule((Object)"net.neoforged:minecraft-dependencies", NonStrictDependencyTransform.class);
        DependencyFactory depFactory = project.getDependencyFactory();
        Configuration autoRenamingToolRuntime = (Configuration)project.getConfigurations().create(CONFIGURATION_TOOL_ART, spec -> {
            spec.setDescription("The AutoRenamingTool CLI tool");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.setTransitive(false);
            spec.getDependencies().add((Object)depFactory.create((CharSequence)"net.neoforged:AutoRenamingTool:2.0.4:all"));
        });
        Configuration installerToolsRuntime = (Configuration)project.getConfigurations().create(CONFIGURATION_TOOL_INSTALLERTOOLS, spec -> {
            spec.setDescription("The InstallerTools CLI tool");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.setTransitive(false);
            spec.getDependencies().add((Object)depFactory.create((CharSequence)"net.neoforged.installertools:installertools:3.0.4:fatjar"));
        });
        ConfigurableFileCollection extraMixinMappings = project.files(new Object[0]);
        ObfuscationExtension obf = (ObfuscationExtension)project.getExtensions().create(OBFUSCATION_EXTENSION, ObfuscationExtension.class, new Object[]{project, autoRenamingToolRuntime, installerToolsRuntime, extraMixinMappings});
        project.getExtensions().create(MIXIN_EXTENSION, MixinExtension.class, new Object[]{project, obf.getNamedToSrgMappings(), extraMixinMappings});
        this.configureDependencyRemapping(project, obf);
        DataFileCollections dataFileCollections = DataFileCollections.create(project);
        project.getExtensions().create(LEGACYFORGE_EXTENSION, LegacyForgeExtension.class, new Object[]{project, dataFileCollections.accessTransformers().extension(), dataFileCollections.interfaceInjectionData().extension()});
    }

    public void enable(Project project, LegacyForgeModdingSettings settings, LegacyForgeExtension extension) {
        ModdingDependencies dependencies;
        ArtifactNamingStrategy artifactNamingStrategy;
        VersionCapabilitiesInternal versionCapabilities;
        DependencyFactory depFactory = project.getDependencyFactory();
        String forgeVersion = settings.getForgeVersion();
        String neoForgeVersion = settings.getNeoForgeVersion();
        String mcpVersion = settings.getMcpVersion();
        if (forgeVersion != null || neoForgeVersion != null) {
            if (forgeVersion != null && neoForgeVersion != null || mcpVersion != null) {
                throw new InvalidUserCodeException("Specifying a Forge version is mutually exclusive with NeoForge or MCP");
            }
            String version = forgeVersion != null ? forgeVersion : neoForgeVersion;
            versionCapabilities = VersionCapabilitiesInternal.ofForgeVersion(version);
            artifactNamingStrategy = ArtifactNamingStrategy.createNeoForge(versionCapabilities, "forge", version);
            String groupId = forgeVersion != null ? "net.minecraftforge" : "net.neoforged";
            ExternalModuleDependency neoForge = depFactory.create((CharSequence)(groupId + ":forge:" + version));
            String neoForgeNotation = groupId + ":forge:" + version + ":userdev";
            dependencies = ModdingDependencies.create((ModuleDependency)neoForge, neoForgeNotation, null, null, versionCapabilities);
        } else if (mcpVersion != null) {
            versionCapabilities = VersionCapabilitiesInternal.ofMinecraftVersion(mcpVersion);
            artifactNamingStrategy = ArtifactNamingStrategy.createVanilla(mcpVersion);
            ExternalModuleDependency neoForm = depFactory.create((CharSequence)("de.oceanlabs.mcp:mcp_config:" + mcpVersion));
            String neoFormNotation = "de.oceanlabs.mcp:mcp_config:" + mcpVersion + "@zip";
            dependencies = ModdingDependencies.createVanillaOnly((ModuleDependency)neoForm, neoFormNotation);
        } else {
            throw new InvalidUserCodeException("You must specify a Forge, NeoForge or MCP version");
        }
        ConfigurationContainer configurations = project.getConfigurations();
        ModDevArtifactsWorkflow artifacts = ModDevArtifactsWorkflow.create(project, settings.getEnabledSourceSets(), Branding.MDG, extension, dependencies, artifactNamingStrategy, configurations.getByName("accessTransformers"), configurations.getByName("interfaceInjectionData"), versionCapabilities);
        ModDevRunWorkflow runs = ModDevRunWorkflow.create(project, Branding.MDG, artifacts, extension.getRuns());
        MixinExtension mixin = ExtensionUtils.getExtension((ExtensionAware)project, MIXIN_EXTENSION, MixinExtension.class);
        ObfuscationExtension obf = ExtensionUtils.getExtension((ExtensionAware)project, OBFUSCATION_EXTENSION, ObfuscationExtension.class);
        Provider<RegularFile> namedToIntermediate = artifacts.requestAdditionalMinecraftArtifact("namedToIntermediaryMapping", "namedToIntermediate.tsrg");
        obf.getNamedToSrgMappings().set(namedToIntermediate);
        Provider<RegularFile> intermediateToNamed = artifacts.requestAdditionalMinecraftArtifact("intermediaryToNamedMapping", "intermediateToNamed.srg");
        Provider<RegularFile> mappingsCsv = artifacts.requestAdditionalMinecraftArtifact("csvMapping", "intermediateToNamed.zip");
        obf.getSrgToNamedMappings().set(mappingsCsv);
        extension.getRuns().configureEach(run -> {
            run.getJvmArguments().addAll((Object[])new String[]{"--add-exports", "cpw.mods.bootstraplauncher/cpw.mods.bootstraplauncher=ALL-UNNAMED"});
            run.getSystemProperties().put((Object)"mixin.env.remapRefMap", (Object)"true");
            run.getSystemProperties().put((Object)"mixin.env.refMapRemappingFile", intermediateToNamed.map(f -> f.getAsFile().getAbsolutePath()));
            run.getProgramArguments().addAll(mixin.getConfigs().map(cfgs -> cfgs.stream().flatMap(config -> Stream.of("--mixin.config", config)).toList()));
        });
        TaskProvider<RemapJar> reobfJar = obf.reobfuscate((TaskProvider<? extends AbstractArchiveTask>)project.getTasks().named("jar", Jar.class), (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
        project.getTasks().named("assemble", assemble -> assemble.dependsOn(new Object[]{reobfJar}));
        artifacts.runtimeDependencies().getDependencies().add((Object)project.getDependencyFactory().create((FileCollection)project.files(new Object[]{mappingsCsv})));
        Configuration remapDeps = (Configuration)project.getConfigurations().create("remappingDependencies", spec -> {
            spec.setDescription("An internal configuration that contains the Minecraft dependencies, used for remapping mods");
            spec.setCanBeConsumed(false);
            spec.setCanBeDeclared(false);
            spec.setCanBeResolved(true);
            spec.extendsFrom(new Configuration[]{artifacts.runtimeDependencies()});
        });
        project.getDependencies().registerTransform(RemappingTransform.class, params -> {
            params.parameters(parameters -> {
                obf.configureSrgToNamedOperation(parameters.getRemapOperation());
                parameters.getMinecraftDependencies().from(new Object[]{remapDeps});
            });
            params.getFrom().attribute(MinecraftMappings.ATTRIBUTE, (Object)this.srgMappings).attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
            params.getTo().attribute(MinecraftMappings.ATTRIBUTE, (Object)this.namedMappings).attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
        });
    }

    private void configureDependencyRemapping(Project project, ObfuscationExtension obf) {
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        sourceSets.all(sourceSet -> {
            String configurationName = sourceSet.getTaskName(null, "jarJar");
            project.getConfigurations().getByName(configurationName).withDependencies(dependencies -> dependencies.forEach(dep -> {
                if (dep instanceof ProjectDependency) {
                    ProjectDependency projectDependency = (ProjectDependency)dep;
                    projectDependency.attributes(a -> a.attribute(MinecraftMappings.ATTRIBUTE, (Object)this.srgMappings));
                }
            }));
        });
        project.getDependencies().attributesSchema(schema -> {
            AttributeMatchingStrategy attr = schema.attribute(MinecraftMappings.ATTRIBUTE);
            attr.getDisambiguationRules().add(MappingsDisambiguationRule.class, config -> config.params(new Object[]{this.namedMappings}));
        });
        project.getDependencies().getArtifactTypes().named("jar", type -> type.getAttributes().attribute(MinecraftMappings.ATTRIBUTE, (Object)this.srgMappings));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("implementation"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("runtimeOnly"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("compileOnly"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("api"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("compileOnlyApi"));
    }
}

