/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.dsl;

import javax.inject.Inject;
import net.neoforged.moddevgradle.legacyforge.dsl.MixinCompilerArgs;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.tasks.Jar;

public abstract class MixinExtension {
    private final Project project;
    private final Provider<RegularFile> officialToSrg;
    private final ConfigurableFileCollection extraMappingFiles;

    @Inject
    public MixinExtension(Project project, Provider<RegularFile> officialToSrg, ConfigurableFileCollection extraMappingFiles) {
        this.project = project;
        this.officialToSrg = officialToSrg;
        this.extraMappingFiles = extraMappingFiles;
    }

    public abstract ListProperty<String> getConfigs();

    public void config(String name) {
        this.getConfigs().add((Object)name);
    }

    public Provider<RegularFile> add(SourceSet sourceSet, String refmap) {
        Provider mappingFile = this.project.getLayout().getBuildDirectory().dir("mixin").map(d -> d.file(refmap + ".mappings.tsrg"));
        Provider refMapFile = this.project.getLayout().getBuildDirectory().dir("mixin").map(d -> d.file(refmap));
        MixinCompilerArgs compilerArgs = (MixinCompilerArgs)this.project.getObjects().newInstance(MixinCompilerArgs.class, new Object[0]);
        compilerArgs.getRefmap().set(refMapFile);
        compilerArgs.getOutMappings().set(mappingFile);
        compilerArgs.getInMappings().set(this.officialToSrg);
        this.extraMappingFiles.from(new Object[]{mappingFile});
        this.project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class).configure(compile -> compile.getOptions().getCompilerArgumentProviders().add(compilerArgs));
        this.project.getTasks().withType(Jar.class).matching(jar -> jar.getName().equals(sourceSet.getJarTaskName())).configureEach(jar -> jar.from(new Object[]{refMapFile}));
        return refMapFile;
    }
}

