/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.neoforged.moddevgradle.dsl.InternalModelHelper;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.ModFolder;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.OperatingSystem;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;

final class RunUtils {
    public static final String DEV_LAUNCH_GAV = "net.neoforged:DevLaunch:1.0.1";
    public static final String DEV_LAUNCH_MAIN_CLASS = "net.neoforged.devlaunch.Main";
    public static final String DEV_LOGIN_GAV = "net.covers1624:DevLogin:0.1.0.5";
    public static final String DEV_LOGIN_MAIN_CLASS = "net.covers1624.devlogin.DevLogin";

    private RunUtils() {
    }

    public static String escapeJvmArg(String arg) {
        String escaped = arg.replace("\\", "\\\\").replace("\"", "\\\"");
        if (escaped.contains(" ") || escaped.contains("#")) {
            return "\"" + escaped + "\"";
        }
        return escaped;
    }

    public static Provider<String> getRequiredType(Project project, RunModel runModel) {
        return runModel.getType().orElse(project.getProviders().provider(() -> {
            throw new GradleException("The run '" + runModel.getName() + "' did not specify a type property");
        }));
    }

    public static void writeLog4j2Configuration(Level rootLevel, Path destination) throws IOException {
        Files.writeString(destination, (CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Configuration status=\"warn\" shutdownHook=\"disable\">\n    <filters>\n        <ThresholdFilter level=\"WARN\" onMatch=\"ACCEPT\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"NETWORK_PACKETS\" onMatch=\"${sys:forge.logging.marker.networking:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"CLASSLOADING\" onMatch=\"${sys:forge.logging.marker.classloading:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"LAUNCHPLUGIN\" onMatch=\"${sys:forge.logging.marker.launchplugin:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"CLASSDUMP\" onMatch=\"${sys:forge.logging.marker.classdump:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"AXFORM\" onMatch=\"${sys:forge.logging.marker.axform:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"EVENTBUS\" onMatch=\"${sys:forge.logging.marker.eventbus:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"DISTXFORM\" onMatch=\"${sys:forge.logging.marker.distxform:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"SCAN\" onMatch=\"${sys:forge.logging.marker.scan:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"REGISTRIES\" onMatch=\"${sys:forge.logging.marker.registries:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"REGISTRYDUMP\" onMatch=\"${sys:forge.logging.marker.registrydump:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"SPLASH\" onMatch=\"${sys:forge.logging.marker.splash:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"RESOURCE-CACHE\" onMatch=\"${sys:forge.logging.marker.resource.cache:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"FORGEMOD\" onMatch=\"${sys:forge.logging.marker.forgemod:-NEUTRAL}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"LOADING\" onMatch=\"${sys:forge.logging.marker.loading:-NEUTRAL}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"CORE\" onMatch=\"${sys:forge.logging.marker.core:-NEUTRAL}\" onMismatch=\"NEUTRAL\"/>\n    </filters>\n    <Appenders>\n        <Console name=\"Console\">\n            <PatternLayout>\n                <LoggerNamePatternSelector defaultPattern=\"%highlightForge{[%d{HH:mm:ss}] [%t/%level] [%c{2.}/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}%n%tEx}\">\n                    <!-- don't include the full logger name for Mojang's logs since they use full class names and it's very verbose -->\n                    <PatternMatch key=\"net.minecraft.\" pattern=\"%highlightForge{[%d{HH:mm:ss}] [%t/%level] [minecraft/%logger{1}]: %minecraftFormatting{%msg{nolookup}}%n%tEx}\"/>\n                    <PatternMatch key=\"com.mojang.\" pattern=\"%highlightForge{[%d{HH:mm:ss}] [%t/%level] [mojang/%logger{1}]: %minecraftFormatting{%msg{nolookup}}%n%tEx}\"/>\n                </LoggerNamePatternSelector>\n            </PatternLayout>\n        </Console>\n        <Queue name=\"ServerGuiConsole\" ignoreExceptions=\"true\">\n            <PatternLayout>\n                <LoggerNamePatternSelector defaultPattern=\"[%d{HH:mm:ss}] [%t/%level] [%c{2.}/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}{strip}%n\">\n                    <!-- don't include the full logger name for Mojang's logs since they use full class names and it's very verbose -->\n                    <PatternMatch key=\"net.minecraft.\" pattern=\"[%d{HH:mm:ss}] [%t/%level] [minecraft/%logger{1}]: %minecraftFormatting{%msg{nolookup}}{strip}%n\"/>\n                    <PatternMatch key=\"com.mojang.\" pattern=\"[%d{HH:mm:ss}] [%t/%level] [mojang/%logger{1}]: %minecraftFormatting{%msg{nolookup}}{strip}%n\"/>\n                </LoggerNamePatternSelector>\n            </PatternLayout>\n        </Queue>\n        <RollingRandomAccessFile name=\"File\" fileName=\"logs/latest.log\" filePattern=\"logs/%d{yyyy-MM-dd}-%i.log.gz\">\n            <PatternLayout pattern=\"[%d{ddMMMyyyy HH:mm:ss.SSS}] [%t/%level] [%logger/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}{strip}%n%xEx\"/>\n            <Policies>\n                <TimeBasedTriggeringPolicy/>\n                <OnStartupTriggeringPolicy/>\n            </Policies>\n            <DefaultRolloverStrategy max=\"99\" fileIndex=\"min\"/>\n        </RollingRandomAccessFile>\n        <RollingRandomAccessFile name=\"DebugFile\" fileName=\"logs/debug.log\" filePattern=\"logs/debug-%i.log.gz\">\n            <PatternLayout pattern=\"[%d{ddMMMyyyy HH:mm:ss.SSS}] [%t/%level] [%logger/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}{strip}%n%xEx\"/>\n            <Policies>\n                <OnStartupTriggeringPolicy/>\n                <SizeBasedTriggeringPolicy size=\"200MB\"/>\n            </Policies>\n            <DefaultRolloverStrategy max=\"5\" fileIndex=\"min\"/>\n        </RollingRandomAccessFile>\n    </Appenders>\n    <Loggers>\n        <!-- make sure mojang's logging is set to 'info' so that their LOGGER.isDebugEnabled() behavior isn't active -->\n        <Logger level=\"${sys:forge.logging.mojang.level:-info}\" name=\"com.mojang\"/>\n        <Logger level=\"${sys:forge.logging.mojang.level:-info}\" name=\"net.minecraft\"/>\n        <Logger level=\"${sys:forge.logging.classtransformer.level:-info}\" name=\"cpw.mods.modlauncher.ClassTransformer\"/>\n\n        <!-- Netty reflects into JDK internals, and it's causing useless DEBUG-level error stacktraces. We just ignore them -->\n        <Logger name=\"io.netty.util.internal.PlatformDependent0\">\n            <filters>\n                <RegexFilter regex=\"^direct buffer constructor: unavailable$\" onMatch=\"DENY\" onMismatch=\"NEUTRAL\" />\n                <RegexFilter regex=\"^jdk\\.internal\\.misc\\.Unsafe\\.allocateUninitializedArray\\(int\\): unavailable$\" onMatch=\"DENY\" onMismatch=\"NEUTRAL\" />\n            </filters>\n        </Logger>\n\n        <Root level=\"$ROOTLEVEL$\">\n            <AppenderRef ref=\"Console\" />\n            <AppenderRef ref=\"ServerGuiConsole\" level=\"${sys:forge.logging.console.level:-info}\"/>\n            <AppenderRef ref=\"File\" level=\"${sys:forge.logging.file.level:-info}\"/>\n            <AppenderRef ref=\"DebugFile\" />\n        </Root>\n    </Loggers>\n</Configuration>\n".replace("$ROOTLEVEL$", rootLevel.name()), new OpenOption[0]);
    }

    public static Provider<RegularFile> getArgFile(Provider<Directory> modDevFolder, RunModel run, RunArgFile type) {
        return modDevFolder.map(dir -> dir.file(InternalModelHelper.nameOfRun(run, "", type.filename)));
    }

    public static Provider<RegularFile> getLaunchScript(Provider<Directory> modDevFolder, RunModel run) {
        String scriptExtension = switch (OperatingSystem.current()) {
            default -> throw new IncompatibleClassChangeError();
            case OperatingSystem.LINUX, OperatingSystem.MACOS -> ".sh";
            case OperatingSystem.WINDOWS -> ".cmd";
        };
        return modDevFolder.map(dir -> dir.file(InternalModelHelper.nameOfRun(run, "run", scriptExtension)));
    }

    public static String getArgFileParameter(RegularFile argFile) {
        return "@" + argFile.getAsFile().getAbsolutePath();
    }

    public static ModFoldersProvider getGradleModFoldersProvider(Project project, Provider<Set<ModModel>> modsProvider, Provider<ModModel> testedMod) {
        ModFoldersProvider modFoldersProvider = (ModFoldersProvider)project.getObjects().newInstance(ModFoldersProvider.class, new Object[0]);
        modFoldersProvider.getModFolders().set(RunUtils.getModFoldersForGradle(project, modsProvider, testedMod));
        return modFoldersProvider;
    }

    public static Project findSourceSetProject(Project someProject, SourceSet sourceSet) {
        for (SourceSet s : ExtensionUtils.getSourceSets(someProject)) {
            if (s != sourceSet) continue;
            return someProject;
        }
        for (Project p : someProject.getRootProject().getAllprojects()) {
            SourceSetContainer sourceSets = ExtensionUtils.findSourceSets(p);
            if (sourceSets == null) continue;
            for (SourceSet s : sourceSets) {
                if (s != sourceSet) continue;
                return p;
            }
        }
        throw new IllegalArgumentException("Could not find project for source set " + String.valueOf(someProject));
    }

    public static Map<String, String> replaceModClassesEnv(RunModel model, ModFoldersProvider modFoldersProvider) {
        Map vars = (Map)model.getEnvironment().get();
        if (vars.containsKey("MOD_CLASSES")) {
            HashMap<String, String> copy = new HashMap<String, String>(vars);
            copy.put("MOD_CLASSES", (String)modFoldersProvider.getClassesArgument().get());
            return copy;
        }
        return vars;
    }

    public static Provider<Map<String, ModFolder>> getModFoldersForGradle(Project project, Provider<Set<ModModel>> modsProvider, @Nullable Provider<ModModel> testedMod) {
        return RunUtils.buildModFolders(project, modsProvider, testedMod, (sourceSet, output) -> output.from(new Object[]{sourceSet.getOutput()}));
    }

    public static Provider<Map<String, ModFolder>> buildModFolders(Project project, Provider<Set<ModModel>> modsProvider, @Nullable Provider<ModModel> testedModProvider, BiConsumer<SourceSet, ConfigurableFileCollection> outputFolderResolver) {
        if (testedModProvider == null) {
            testedModProvider = project.provider(() -> null);
        }
        Provider optionalTestedModProvider = testedModProvider.map(Optional::of).orElse(Optional.empty());
        return modsProvider.zip(optionalTestedModProvider, (mods, testedMod) -> {
            if (testedMod.isPresent() && !mods.contains(testedMod.get())) {
                throw new InvalidUserCodeException("The tested mod (%s) must be included in the mods loaded for unit testing (%s).".formatted(((ModModel)testedMod.get()).getName(), mods.stream().map(ModModel::getName).toList()));
            }
            return mods.stream().collect(Collectors.toMap(ModModel::getName, mod -> {
                SourceSet testSourceSet;
                ModFolder modFolder = (ModFolder)project.getObjects().newInstance(ModFolder.class, new Object[0]);
                List sourceSets = (List)mod.getModSourceSets().get();
                for (int i = 0; i < sourceSets.size(); ++i) {
                    SourceSet sourceSet = (SourceSet)sourceSets.get(i);
                    if (sourceSets.subList(0, i).contains(sourceSet)) {
                        throw new InvalidUserCodeException("Duplicate source set '%s' in mod '%s'".formatted(sourceSet.getName(), mod.getName()));
                    }
                    outputFolderResolver.accept(sourceSet, modFolder.getFolders());
                }
                if (testedMod.isPresent() && testedMod.get() == mod && (testSourceSet = (SourceSet)ExtensionUtils.getSourceSets(project).findByName("test")) != null && !sourceSets.contains(testSourceSet)) {
                    outputFolderResolver.accept(testSourceSet, modFolder.getFolders());
                }
                return modFolder;
            }));
        });
    }

    public static enum RunArgFile {
        VMARGS("runVmArgs.txt"),
        PROGRAMARGS("runProgramArgs.txt"),
        CLASSPATH("runClasspath.txt"),
        LOG4J_CONFIG("log4j2.xml");

        private final String filename;

        private RunArgFile(String filename) {
            this.filename = filename;
        }
    }
}

