/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.nfrtgradle;

import net.neoforged.nfrtgradle.CreateMinecraftArtifacts;
import net.neoforged.nfrtgradle.NeoFormRuntimeExtension;
import net.neoforged.nfrtgradle.NeoFormRuntimeTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.provider.Provider;

public class NeoFormRuntimePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        NeoFormRuntimeExtension extension = (NeoFormRuntimeExtension)project.getExtensions().create("neoFormRuntime", NeoFormRuntimeExtension.class, new Object[0]);
        ConfigurationContainer configurations = project.getConfigurations();
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        Provider nfrtDependency = extension.getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoform-runtime:" + version)));
        Configuration toolConfiguration = (Configuration)configurations.create("neoFormRuntimeTool", spec -> {
            spec.setDescription("The NeoFormRuntime CLI tool");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.defaultDependencies(dependencies -> dependencies.addLater(nfrtDependency.map(dependency -> dependency.copy().attributes(attributes -> attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "shadowed")))))));
        });
        Configuration externalToolsConfiguration = (Configuration)configurations.create("neoFormRuntimeExternalTools", spec -> {
            spec.setDescription("The external tools used by NeoFormRuntime");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.getDependencies().addLater(nfrtDependency.map(dep -> dep.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-runtime-external-tools"))));
        });
        project.getTasks().withType(NeoFormRuntimeTask.class).configureEach(task -> {
            task.getNeoFormRuntime().convention((Iterable)toolConfiguration);
            task.getVerbose().convention(extension.getVerbose());
            task.addArtifactsToManifest(externalToolsConfiguration);
        });
        project.getTasks().withType(CreateMinecraftArtifacts.class).configureEach(task -> {
            task.getEnableCache().set(extension.getEnableCache());
            task.getAnalyzeCacheMisses().set(extension.getAnalyzeCacheMisses());
            task.getUseEclipseCompiler().set(extension.getUseEclipseCompiler());
        });
    }
}

