/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import javax.inject.Inject;
import net.neoforged.moddevgradle.legacyforge.internal.LegacyMetadataTransform;
import org.gradle.api.Action;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.model.ObjectFactory;

@CacheableRule
class McpMetadataTransform
extends LegacyMetadataTransform {
    @Inject
    public McpMetadataTransform(ObjectFactory objects, RepositoryResourceAccessor repositoryResourceAccessor) {
        super(objects, repositoryResourceAccessor);
    }

    public void execute(ComponentMetadataContext context) {
        this.executeWithConfig(context, this.createPath(context, "", "zip"));
    }

    @Override
    protected void adaptWithConfig(ComponentMetadataContext context, JsonObject config) {
        ComponentMetadataDetails details = context.getDetails();
        ModuleVersionIdentifier id = details.getId();
        String zipDataName = id.getName() + "-" + id.getVersion() + ".zip";
        int javaTarget = config.has("java_target") ? config.getAsJsonPrimitive("java_target").getAsInt() : 8;
        details.addVariant("mcpData", variantMetadata -> {
            variantMetadata.withFiles(files -> files.addFile(zipDataName));
            variantMetadata.attributes(attributes -> attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)javaTarget));
            variantMetadata.withDependencies(dependencies -> {
                JsonObject functions = config.getAsJsonObject("functions");
                for (Map.Entry function : functions.entrySet()) {
                    String toolCoordinate = ((JsonObject)function.getValue()).getAsJsonPrimitive("version").getAsString();
                    dependencies.add(toolCoordinate);
                }
            });
            variantMetadata.withCapabilities(capabilities -> capabilities.addCapability("net.neoforged", "neoform", id.getVersion()));
        });
        this.dependencies(context, "mcpRuntimeElements", javaTarget, "java-runtime", (Action<DirectDependenciesMetadata>)((Action)deps -> {}));
        this.dependencies(context, "mcpApiElements", javaTarget, "java-api", (Action<DirectDependenciesMetadata>)((Action)dependencies -> {
            JsonArray libraries = config.getAsJsonObject("libraries").getAsJsonArray("joined");
            for (JsonElement library : libraries) {
                dependencies.add(library.getAsString());
            }
        }));
    }

    private void dependencies(ComponentMetadataContext context, String name, int javaTarget, String usage, Action<DirectDependenciesMetadata> deps) {
        context.getDetails().addVariant(name, variantMetadata -> {
            variantMetadata.attributes(attributes -> {
                attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)javaTarget);
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objects.named(Usage.class, usage)));
            });
            variantMetadata.withDependencies(dependencies -> {
                deps.execute(dependencies);
                dependencies.add("net.neoforged:minecraft-dependencies:" + context.getDetails().getId().getVersion());
            });
            variantMetadata.withCapabilities(capabilities -> capabilities.addCapability("net.neoforged", "neoform-dependencies", context.getDetails().getId().getVersion()));
        });
    }
}

