/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.dsl;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.neoforged.moddevgradle.legacyforge.internal.MinecraftMappings;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapJar;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapOperation;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.ApiStatus;

public abstract class ObfuscationExtension {
    private final Project project;
    private final Configuration autoRenamingToolRuntime;
    private final Configuration installerToolsRuntime;
    private final FileCollection extraMixinMappings;
    private final MinecraftMappings namedMappings;

    @Inject
    public ObfuscationExtension(Project project, Configuration autoRenamingToolRuntime, Configuration installerToolsRuntime, FileCollection extraMixinMappings) {
        this.project = project;
        this.autoRenamingToolRuntime = autoRenamingToolRuntime;
        this.installerToolsRuntime = installerToolsRuntime;
        this.extraMixinMappings = extraMixinMappings;
        this.namedMappings = (MinecraftMappings)project.getObjects().named(MinecraftMappings.class, "named");
    }

    private <T> Provider<T> assertConfigured(Provider<T> provider) {
        return provider.orElse(this.project.provider(() -> {
            throw new InvalidUserCodeException("Please enable modding by setting legacyForge.version or calling legacyForge.enable()");
        }));
    }

    @ApiStatus.Internal
    public abstract RegularFileProperty getNamedToSrgMappings();

    @ApiStatus.Internal
    public abstract RegularFileProperty getSrgToNamedMappings();

    @ApiStatus.Internal
    public void configureNamedToSrgOperation(RemapOperation operation) {
        operation.getToolType().set((Object)RemapOperation.ToolType.ART);
        operation.getToolClasspath().from(new Object[]{this.autoRenamingToolRuntime});
        operation.getMappings().from(new Object[]{this.assertConfigured((Provider)this.getNamedToSrgMappings())});
    }

    @ApiStatus.Internal
    public void configureSrgToNamedOperation(RemapOperation operation) {
        operation.getToolType().set((Object)RemapOperation.ToolType.INSTALLER_TOOLS);
        operation.getToolClasspath().from(new Object[]{this.installerToolsRuntime});
        operation.getMappings().from(new Object[]{this.assertConfigured((Provider)this.getSrgToNamedMappings())});
    }

    public TaskProvider<RemapJar> reobfuscate(TaskProvider<? extends AbstractArchiveTask> jar, SourceSet sourceSet) {
        return this.reobfuscate(jar, sourceSet, (Action<RemapJar>)((Action)ignored -> {}));
    }

    public TaskProvider<RemapJar> reobfuscate(TaskProvider<? extends AbstractArchiveTask> jar, SourceSet sourceSet, Action<RemapJar> configureTask) {
        TaskProvider reobf = this.project.getTasks().register("reobf" + StringUtils.capitalize((String)jar.getName()), RemapJar.class, task -> {
            task.getInput().set(jar.flatMap(AbstractArchiveTask::getArchiveFile));
            task.getDestinationDirectory().convention(task.getProject().getLayout().getBuildDirectory().dir("libs"));
            task.getArchiveBaseName().convention(jar.flatMap(AbstractArchiveTask::getArchiveBaseName));
            task.getArchiveVersion().convention(jar.flatMap(AbstractArchiveTask::getArchiveVersion));
            task.getArchiveClassifier().convention(jar.flatMap(AbstractArchiveTask::getArchiveClassifier));
            task.getArchiveAppendix().convention(jar.flatMap(AbstractArchiveTask::getArchiveAppendix));
            task.getLibraries().from(new Object[]{sourceSet.getCompileClasspath()});
            this.configureNamedToSrgOperation(task.getRemapOperation());
            task.getRemapOperation().getMappings().from(new Object[]{this.extraMixinMappings});
            configureTask.execute((Object)task);
        });
        jar.configure(task -> {
            task.finalizedBy(new Object[]{reobf});
            task.getDestinationDirectory().set(task.getProject().getLayout().getBuildDirectory().dir("devlibs"));
        });
        ConfigurationContainer configurations = this.project.getConfigurations();
        AdhocComponentWithVariants java = (AdhocComponentWithVariants)this.project.getComponents().getByName("java");
        for (String configurationName : List.of(sourceSet.getRuntimeElementsConfigurationName(), sourceSet.getApiElementsConfigurationName())) {
            Configuration config = configurations.getByName(configurationName);
            config.getAttributes().attribute(MinecraftMappings.ATTRIBUTE, (Object)this.namedMappings);
            Configuration reobfConfig = (Configuration)configurations.maybeCreate("reobf" + StringUtils.capitalize((String)configurationName));
            reobfConfig.setDescription("The artifacts remapped to intermediate (SRG) Minecraft names for use in a production environment");
            reobfConfig.getArtifacts().clear();
            for (Attribute attribute : config.getAttributes().keySet()) {
                if (attribute == MinecraftMappings.ATTRIBUTE) continue;
                ObfuscationExtension.copyAttribute(this.project, attribute, config, reobfConfig);
            }
            this.project.getArtifacts().add(reobfConfig.getName(), (Object)reobf);
            java.withVariantsFromConfiguration(config, ConfigurationVariantDetails::skip);
            java.addVariantsFromConfiguration(reobfConfig, spec -> {});
        }
        return reobf;
    }

    private static <T> void copyAttribute(Project project, Attribute<T> attribute, Configuration fromConfig, Configuration toConfig) {
        toConfig.getAttributes().attributeProvider(attribute, project.provider(() -> Objects.requireNonNull(fromConfig.getAttributes().getAttribute(attribute))));
    }

    public Configuration createRemappingConfiguration(Configuration parent) {
        Configuration remappingConfig = (Configuration)this.project.getConfigurations().create("mod" + StringUtils.capitalize((String)parent.getName()), spec -> {
            spec.setDescription("Configuration for dependencies of " + parent.getName() + " that needs to be remapped");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(false);
            spec.setTransitive(false);
            spec.withDependencies(dependencies -> dependencies.forEach(dep -> {
                if (dep instanceof ExternalModuleDependency) {
                    ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dep;
                    this.project.getDependencies().constraints(constraints -> constraints.add(parent.getName(), (Object)(externalModuleDependency.getGroup() + ":" + externalModuleDependency.getName() + ":" + externalModuleDependency.getVersion()), c -> c.attributes(a -> a.attribute(MinecraftMappings.ATTRIBUTE, (Object)this.namedMappings))));
                    externalModuleDependency.setTransitive(false);
                } else if (dep instanceof FileCollectionDependency) {
                    FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dep;
                    this.project.getDependencies().constraints(constraints -> constraints.add(parent.getName(), (Object)fileCollectionDependency.getFiles(), c -> c.attributes(a -> a.attribute(MinecraftMappings.ATTRIBUTE, (Object)this.namedMappings))));
                } else if (dep instanceof ProjectDependency) {
                    ProjectDependency projectDependency = (ProjectDependency)dep;
                    this.project.getDependencies().constraints(constraints -> constraints.add(parent.getName(), (Object)projectDependency.getDependencyProject(), c -> c.attributes(a -> a.attribute(MinecraftMappings.ATTRIBUTE, (Object)this.namedMappings))));
                    projectDependency.setTransitive(false);
                }
            }));
        });
        parent.extendsFrom(new Configuration[]{remappingConfig});
        return remappingConfig;
    }
}

