/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.problems.Problem;
import net.neoforged.problems.ProblemGroup;
import net.neoforged.problems.ProblemLocation;
import org.gradle.api.Action;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProblemReportingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProblemReportingUtil.class);
    private static final Map<ProblemGroup, org.gradle.api.problems.ProblemGroup> PROBLEM_GROUPS = new ConcurrentHashMap<ProblemGroup, org.gradle.api.problems.ProblemGroup>();
    private static final Map<net.neoforged.problems.ProblemId, ProblemId> PROBLEM_IDS = new ConcurrentHashMap<net.neoforged.problems.ProblemId, ProblemId>();

    private ProblemReportingUtil() {
    }

    public static void report(Problems problems, Problem problem) {
        try {
            ProblemId id = ProblemReportingUtil.getProblemId(problem.problemId());
            Gradle813Adapter.report(problems, id, (Action<ProblemSpec>)((Action)spec -> ProblemReportingUtil.applyProblemToProblemSpec(problem, spec)));
            return;
        }
        catch (ProblemsApiUnsupported problemsApiUnsupported) {
            switch (problem.severity()) {
                case ADVICE: {
                    LOG.info("{}", (Object)problem);
                    break;
                }
                case WARNING: {
                    LOG.warn("{}", (Object)problem);
                    break;
                }
                case ERROR: {
                    LOG.error("{}", (Object)problem);
                }
            }
            return;
        }
    }

    private static void applyProblemToProblemSpec(Problem problem, ProblemSpec spec) {
        ProblemLocation location;
        switch (problem.severity()) {
            case ADVICE: {
                spec.severity(Severity.ADVICE);
                break;
            }
            case WARNING: {
                spec.severity(Severity.WARNING);
                break;
            }
            case ERROR: {
                spec.severity(Severity.ERROR);
            }
        }
        if (problem.contextualLabel() != null) {
            spec.contextualLabel(problem.contextualLabel());
        }
        if (problem.details() != null) {
            spec.details(problem.details());
        }
        if (problem.solution() != null) {
            spec.solution(problem.solution());
        }
        if (problem.documentedAt() != null) {
            spec.documentedAt(problem.documentedAt());
        }
        if ((location = problem.location()) != null) {
            String filePath = location.file().toAbsolutePath().toString();
            if (location.offset() != null) {
                int length = Objects.requireNonNullElse(location.length(), 0);
                spec.offsetInFileLocation(filePath, location.offset().intValue(), length);
            } else if (location.line() != null) {
                if (location.column() != null) {
                    if (location.length() != null) {
                        spec.lineInFileLocation(filePath, location.line().intValue(), location.column().intValue(), location.length().intValue());
                    } else {
                        spec.lineInFileLocation(filePath, location.line().intValue(), location.column().intValue());
                    }
                } else {
                    spec.lineInFileLocation(filePath, location.line().intValue());
                }
            } else {
                spec.fileLocation(filePath);
            }
        }
    }

    private static ProblemId getProblemId(net.neoforged.problems.ProblemId problemId) {
        return PROBLEM_IDS.computeIfAbsent(problemId, ProblemReportingUtil::convertProblemId);
    }

    private static ProblemId convertProblemId(net.neoforged.problems.ProblemId problemId) {
        return Gradle813Adapter.createProblemId(problemId.id(), problemId.displayName(), ProblemReportingUtil.getProblemGroup(problemId.group()));
    }

    private static org.gradle.api.problems.ProblemGroup getProblemGroup(ProblemGroup problemGroup) {
        return PROBLEM_GROUPS.computeIfAbsent(problemGroup, ProblemReportingUtil::convertProblemGroup);
    }

    private static org.gradle.api.problems.ProblemGroup convertProblemGroup(ProblemGroup problemGroup) {
        return Gradle813Adapter.createProblemGroup(problemGroup.id(), problemGroup.displayName(), problemGroup.parent() == null ? null : ProblemReportingUtil.getProblemGroup(problemGroup.parent()));
    }

    private static class Gradle813Adapter {
        private Gradle813Adapter() {
        }

        public static ProblemId createProblemId(String id, String displayName, org.gradle.api.problems.ProblemGroup problemGroup) {
            try {
                Method factory = ProblemId.class.getMethod("create", String.class, String.class, org.gradle.api.problems.ProblemGroup.class);
                return (ProblemId)factory.invoke(null, id, displayName, problemGroup);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.debug("Problems API is unsupported.", (Throwable)e);
                throw new ProblemsApiUnsupported();
            }
        }

        public static org.gradle.api.problems.ProblemGroup createProblemGroup(String id, String displayName, @Nullable org.gradle.api.problems.ProblemGroup parent) {
            try {
                if (parent == null) {
                    Method factory = org.gradle.api.problems.ProblemGroup.class.getMethod("create", String.class, String.class);
                    return (org.gradle.api.problems.ProblemGroup)factory.invoke(null, id, displayName);
                }
                Method factory = org.gradle.api.problems.ProblemGroup.class.getMethod("create", String.class, String.class, org.gradle.api.problems.ProblemGroup.class);
                return (org.gradle.api.problems.ProblemGroup)factory.invoke(null, id, displayName, parent);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.debug("Problems API is unsupported.", (Throwable)e);
                throw new ProblemsApiUnsupported();
            }
        }

        public static void report(Problems problems, ProblemId id, Action<ProblemSpec> consumer) {
            try {
                Object reporter = problems.getClass().getMethod("getReporter", new Class[0]).invoke((Object)problems, new Object[0]);
                Method problemFactory = reporter.getClass().getMethod("create", ProblemId.class, Action.class);
                Object problem = problemFactory.invoke(reporter, id, consumer);
                Class<?> problemClass = Class.forName("org.gradle.api.problems.Problem", true, reporter.getClass().getClassLoader());
                Method problemConsumer = reporter.getClass().getMethod("report", problemClass);
                problemConsumer.invoke(reporter, problem);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.debug("Problems API is unsupported.", (Throwable)e);
                throw new ProblemsApiUnsupported();
            }
        }
    }

    private static class ProblemsApiUnsupported
    extends RuntimeException {
        private ProblemsApiUnsupported() {
        }
    }
}

