/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.EclipseIntegration;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.PrepareRun;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.vsclc.BatchedLaunchWriter;
import net.neoforged.vsclc.LaunchConfiguration;
import net.neoforged.vsclc.attribute.ConsoleType;
import net.neoforged.vsclc.attribute.PathLike;
import net.neoforged.vsclc.attribute.ShortCmdBehaviour;
import net.neoforged.vsclc.writer.WritingMode;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VsCodeIntegration
extends EclipseIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(VsCodeIntegration.class);

    VsCodeIntegration(Project project, Branding branding) {
        super(project, branding);
    }

    @Override
    public void configureRuns(Map<RunModel, TaskProvider<PrepareRun>> prepareRunTasks, Iterable<RunModel> runs) {
        this.project.afterEvaluate(ignored -> {
            BatchedLaunchWriter launchWriter = new BatchedLaunchWriter(WritingMode.MODIFY_CURRENT);
            for (RunModel run : runs) {
                PrepareRun prepareTask = (PrepareRun)((Object)((Object)((TaskProvider)prepareRunTasks.get(run)).get()));
                this.addVscodeLaunchConfiguration(this.project, run, prepareTask, launchWriter);
            }
            try {
                launchWriter.writeToLatestJson(this.project.getRootDir().toPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write VSCode launch files", e);
            }
        });
    }

    private void addVscodeLaunchConfiguration(Project project, RunModel run, PrepareRun prepareTask, BatchedLaunchWriter launchWriter) {
        if (!prepareTask.getEnabled()) {
            LOG.info("Not creating VSCode run {} since its prepare task {} is disabled", (Object)run, (Object)prepareTask);
            return;
        }
        if (!this.shouldGenerateConfigFor(run)) {
            LOG.info("Not creating VSCode run {} since it's explicitly disabled", (Object)run);
            return;
        }
        String runIdeName = (String)run.getIdeName().get();
        String eclipseProjectName = Objects.requireNonNullElse(this.eclipseModel.getProject().getName(), project.getName());
        if (!run.getTasksBefore().isEmpty()) {
            this.eclipseModel.autoBuildTasks(run.getTasksBefore().toArray());
        }
        ModFoldersProvider modFoldersProvider = VsCodeIntegration.getModFoldersProvider(project, run.getLoadedMods(), null);
        ((LaunchConfiguration)((LaunchConfiguration)launchWriter.createGroup("Mod Development - " + project.getName(), WritingMode.REMOVE_EXISTING).createLaunchConfiguration().withName(runIdeName)).withProjectName(eclipseProjectName)).withArguments(List.of(RunUtils.getArgFileParameter((RegularFile)prepareTask.getProgramArgsFile().get()))).withAdditionalJvmArgs(List.of(RunUtils.getArgFileParameter((RegularFile)prepareTask.getVmArgsFile().get()), modFoldersProvider.getArgument())).withEnvironmentVariables(RunUtils.replaceModClassesEnv(run, modFoldersProvider)).withMainClass("net.neoforged.devlaunch.Main").withShortenCommandLine(ShortCmdBehaviour.NONE).withConsoleType(ConsoleType.INTERNAL_CONSOLE).withCurrentWorkingDirectory(PathLike.ofNio((Path)((Directory)run.getGameDirectory().get()).getAsFile().toPath()));
    }
}

