/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.nfrtgradle;

import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import net.neoforged.nfrtgradle.NeoFormRuntimeTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.ApiStatus;

@DisableCachingByDefault(because="Implements its own caching and the output file is system specific")
@ApiStatus.NonExtendable
public abstract class DownloadAssets
extends NeoFormRuntimeTask {
    @Inject
    public DownloadAssets() {
    }

    @Input
    @Optional
    public abstract Property<String> getNeoForgeArtifact();

    @Input
    @Optional
    public abstract Property<String> getNeoFormArtifact();

    @Input
    @Optional
    public abstract Property<String> getMinecraftVersion();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getAssetPropertiesFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getAssetJsonFile();

    @TaskAction
    public void downloadAssets() {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "download-assets");
        if (this.getAssetPropertiesFile().isPresent()) {
            Collections.addAll(args, "--write-properties", ((RegularFile)this.getAssetPropertiesFile().get()).getAsFile().getAbsolutePath());
        }
        if (this.getAssetJsonFile().isPresent()) {
            Collections.addAll(args, "--write-json", ((RegularFile)this.getAssetJsonFile().get()).getAsFile().getAbsolutePath());
        }
        if (this.getMinecraftVersion().isPresent()) {
            Collections.addAll(args, "--minecraft-version", (String)this.getMinecraftVersion().get());
        } else if (this.getNeoFormArtifact().isPresent()) {
            Collections.addAll(args, "--neoform", (String)this.getNeoFormArtifact().get());
        } else if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--neoforge", (String)this.getNeoForgeArtifact().get());
        } else {
            throw new GradleException("One of minecraftVersion, neoFormArtifact or neoForgeArtifact must be specified to download assets.");
        }
        this.run(args);
    }
}

