/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.inject.Inject;
import net.neoforged.moddevgradle.legacyforge.internal.LegacyMetadataTransform;
import org.gradle.api.Action;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVariantFilesMetadata;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;

@CacheableRule
class LegacyForgeMetadataTransform
extends LegacyMetadataTransform {
    @Inject
    public LegacyForgeMetadataTransform(ObjectFactory objects, RepositoryResourceAccessor repositoryResourceAccessor) {
        super(objects, repositoryResourceAccessor);
    }

    public void execute(ComponentMetadataContext context) {
        this.executeWithConfig(context, this.createPath(context, "userdev", "jar"));
    }

    @Override
    public void adaptWithConfig(ComponentMetadataContext context, JsonObject config) {
        ComponentMetadataDetails details = context.getDetails();
        ModuleVersionIdentifier id = details.getId();
        String userdevJarName = id.getName() + "-" + id.getVersion() + "-userdev.jar";
        String universalJarName = id.getName() + "-" + id.getVersion() + "-universal.jar";
        Action vanillaDependencies = deps -> {
            deps.add("de.oceanlabs.mcp:mcp_config:" + id.getVersion().split("-")[0]);
            deps.add("net.neoforged:minecraft-dependencies:" + id.getVersion().split("-")[0]);
        };
        details.addVariant("modDevConfig", variantMetadata -> {
            variantMetadata.withFiles(metadata -> metadata.addFile(userdevJarName, userdevJarName));
            variantMetadata.withCapabilities(capabilities -> capabilities.addCapability("net.neoforged", "neoforge-moddev-config", id.getVersion()));
        });
        details.addVariant("modDevBundle", variantMetadata -> {
            variantMetadata.withFiles(metadata -> metadata.addFile(userdevJarName, userdevJarName));
            variantMetadata.withDependencies(vanillaDependencies);
            variantMetadata.withCapabilities(capabilities -> capabilities.addCapability("net.neoforged", "neoforge-moddev-bundle", id.getVersion()));
        });
        details.addVariant("modDevModulePath", variantMetadata -> {
            variantMetadata.withDependencies(dependencies -> {
                if (config.has("modules")) {
                    JsonArray modules = config.getAsJsonArray("modules");
                    for (JsonElement module : modules) {
                        dependencies.add(module.getAsString());
                    }
                }
            });
            variantMetadata.withCapabilities(capabilities -> capabilities.addCapability("net.neoforged", "neoforge-moddev-module-path", id.getVersion()));
        });
        details.addVariant("modDevApiElements", variantMetadata -> {
            variantMetadata.attributes(attributes -> {
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "library")));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objects.named(Bundling.class, "external")));
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objects.named(Usage.class, "java-api")));
            });
            variantMetadata.withDependencies(dependencies -> {
                JsonArray libraries = config.getAsJsonArray("libraries");
                for (JsonElement library : libraries) {
                    dependencies.add(library.getAsString());
                }
            });
            variantMetadata.withDependencies(vanillaDependencies);
            variantMetadata.withCapabilities(capabilities -> capabilities.addCapability("net.neoforged", "neoforge-dependencies", id.getVersion()));
        });
        details.addVariant("modDevRuntimeElements", variantMetadata -> {
            variantMetadata.attributes(attributes -> {
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "library")));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objects.named(Bundling.class, "external")));
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objects.named(Usage.class, "java-runtime")));
            });
            variantMetadata.withCapabilities(capabilities -> {
                capabilities.removeCapability(id.getGroup(), id.getName());
                capabilities.addCapability("net.neoforged", "neoforge-dependencies", id.getVersion());
            });
            variantMetadata.withDependencies(vanillaDependencies);
            variantMetadata.withFiles(MutableVariantFilesMetadata::removeAllFiles);
            variantMetadata.withDependencies(dependencies -> {
                if (config.has("modules")) {
                    JsonArray modules = config.getAsJsonArray("modules");
                    for (JsonElement module : modules) {
                        dependencies.add(module.getAsString());
                    }
                }
                JsonArray libraries = config.getAsJsonArray("libraries");
                for (JsonElement library : libraries) {
                    dependencies.add(library.getAsString());
                }
            });
        });
        details.addVariant("universalJar", variantMetadata -> {
            variantMetadata.attributes(attributes -> {
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "library")));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objects.named(Bundling.class, "external")));
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objects.named(Usage.class, "java-runtime")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objects.named(LibraryElements.class, "jar")));
            });
            variantMetadata.withFiles(metadata -> metadata.addFile(universalJarName, universalJarName));
        });
        for (String implicitVariantName : List.of("compile", "runtime")) {
            details.withVariant(implicitVariantName, variant -> variant.withCapabilities(caps -> {
                caps.removeCapability(id.getGroup(), id.getName());
                caps.addCapability("___dummy___", "___dummy___", "___dummy___");
            }));
        }
    }
}

