/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.dsl;

import javax.inject.Inject;
import net.neoforged.moddevgradle.dsl.DataFileCollection;
import net.neoforged.moddevgradle.dsl.ModDevExtension;
import net.neoforged.moddevgradle.internal.ModDevArtifactsWorkflow;
import net.neoforged.moddevgradle.internal.ModdingDependencies;
import net.neoforged.moddevgradle.legacyforge.dsl.LegacyForgeModdingSettings;
import net.neoforged.moddevgradle.legacyforge.internal.LegacyForgeModDevPlugin;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;

public abstract class LegacyForgeExtension
extends ModDevExtension {
    private final Project project;

    @Inject
    public LegacyForgeExtension(Project project, DataFileCollection accessTransformers, DataFileCollection interfaceInjectionData) {
        super(project, accessTransformers, interfaceInjectionData);
        this.project = project;
    }

    public void setVersion(String version) {
        this.enable((Action<LegacyForgeModdingSettings>)((Action)settings -> settings.setForgeVersion(version)));
    }

    public void setMcpVersion(String version) {
        this.enable((Action<LegacyForgeModdingSettings>)((Action)settings -> settings.setMcpVersion(version)));
    }

    public String getMcpVersion() {
        ModdingDependencies dependencies = ModDevArtifactsWorkflow.get(this.project).dependencies();
        if (dependencies.neoFormDependency() == null) {
            throw new InvalidUserCodeException("You cannot retrieve the MCP version without setting it first.");
        }
        return dependencies.neoFormDependency().getVersion();
    }

    public void enable(Action<LegacyForgeModdingSettings> customizer) {
        LegacyForgeModDevPlugin plugin = (LegacyForgeModDevPlugin)this.project.getPlugins().getPlugin(LegacyForgeModDevPlugin.class);
        LegacyForgeModdingSettings settings = (LegacyForgeModdingSettings)this.project.getObjects().newInstance(LegacyForgeModdingSettings.class, new Object[0]);
        customizer.execute((Object)settings);
        plugin.enable(this.project, settings, this);
    }
}

