/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.nfrtgradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.nfrtgradle.NeoFormRuntimeTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.ApiStatus;

@DisableCachingByDefault(because="Implements its own caching")
@ApiStatus.NonExtendable
public abstract class CreateMinecraftArtifacts
extends NeoFormRuntimeTask {
    @Inject
    public CreateMinecraftArtifacts() {
        this.getOutputs().upToDateWhen(task -> (Boolean)((CreateMinecraftArtifacts)((Object)task)).getEnableCache().get());
        this.getEnableCache().convention((Object)true);
        this.getUseEclipseCompiler().convention((Object)false);
        this.getAnalyzeCacheMisses().convention((Object)false);
        this.getValidateAccessTransformers().convention((Object)false);
        this.getParchmentEnabled().convention((Object)false);
    }

    @Input
    @Optional
    public abstract Property<String> getToolsJavaExecutable();

    @InputFiles
    public abstract ConfigurableFileCollection getAccessTransformers();

    @InputFiles
    public abstract ConfigurableFileCollection getInterfaceInjectionData();

    @Input
    public abstract Property<Boolean> getValidateAccessTransformers();

    @Input
    public abstract Property<Boolean> getParchmentEnabled();

    @InputFiles
    public abstract ConfigurableFileCollection getParchmentData();

    @Input
    @Optional
    public abstract Property<String> getParchmentConflictResolutionPrefix();

    @OutputFiles
    public abstract MapProperty<String, File> getAdditionalResults();

    @Input
    @Optional
    public abstract Property<String> getNeoForgeArtifact();

    @Input
    @Optional
    public abstract Property<String> getNeoFormArtifact();

    @Internal
    public abstract Property<Boolean> getEnableCache();

    @Internal
    public abstract Property<Boolean> getAnalyzeCacheMisses();

    @Input
    public abstract Property<Boolean> getUseEclipseCompiler();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getCompiledWithSourcesArtifact();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getCompiledArtifact();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getSourcesArtifact();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getResourcesArtifact();

    @TaskAction
    public void createArtifacts() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("run");
        if (this.getToolsJavaExecutable().isPresent()) {
            args.add("--java-executable");
            args.add((String)this.getToolsJavaExecutable().get());
        }
        for (File accessTransformer : this.getAccessTransformers().getFiles()) {
            args.add("--access-transformer");
            args.add(accessTransformer.getAbsolutePath());
        }
        for (File interfaceInjectionFile : this.getInterfaceInjectionData().getFiles()) {
            args.add("--interface-injection-data");
            args.add(interfaceInjectionFile.getAbsolutePath());
        }
        if (((Boolean)this.getValidateAccessTransformers().get()).booleanValue()) {
            args.add("--validate-access-transformers");
        }
        if (((Boolean)this.getParchmentEnabled().get()).booleanValue()) {
            Set parchmentData = this.getParchmentData().getFiles();
            if (parchmentData.size() == 1) {
                args.add("--parchment-data");
                args.add(((File)parchmentData.iterator().next()).getAbsolutePath());
            } else if (parchmentData.size() > 1) {
                throw new GradleException("More than one parchment data file was specified: " + parchmentData);
            }
            String conflictResolutionPrefix = (String)this.getParchmentConflictResolutionPrefix().getOrElse((Object)"");
            if (this.getParchmentConflictResolutionPrefix().isPresent() && !conflictResolutionPrefix.isBlank()) {
                args.add("--parchment-conflict-prefix");
                args.add(conflictResolutionPrefix);
            }
        }
        if (!((Boolean)this.getEnableCache().get()).booleanValue()) {
            args.add("--disable-cache");
        }
        if (((Boolean)this.getAnalyzeCacheMisses().get()).booleanValue()) {
            args.add("--analyze-cache-misses");
        }
        if (((Boolean)this.getUseEclipseCompiler().get()).booleanValue()) {
            args.add("--use-eclipse-compiler");
        }
        if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--neoforge", (String)this.getNeoForgeArtifact().get());
        }
        if (this.getNeoFormArtifact().isPresent()) {
            Collections.addAll(args, "--neoform", (String)this.getNeoFormArtifact().get());
        }
        if (!this.getNeoFormArtifact().isPresent() && !this.getNeoForgeArtifact().isPresent()) {
            throw new GradleException("You need to specify at least 'version' or 'neoFormVersion' in the 'neoForge' block of your build script.");
        }
        Collections.addAll(args, "--dist", "joined");
        ArrayList<RequestedResult> requestedResults = new ArrayList<RequestedResult>();
        ((Map)this.getAdditionalResults().get()).forEach((name, file) -> requestedResults.add(new RequestedResult((String)name, (File)file)));
        if (this.getResourcesArtifact().isPresent()) {
            requestedResults.add(new RequestedResult("clientResources", ((RegularFile)this.getResourcesArtifact().get()).getAsFile()));
        }
        if (this.getNeoForgeArtifact().isPresent()) {
            if (this.getCompiledArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("compiledWithNeoForge", ((RegularFile)this.getCompiledArtifact().get()).getAsFile()));
            }
            if (this.getSourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("sourcesWithNeoForge", ((RegularFile)this.getSourcesArtifact().get()).getAsFile()));
            }
            if (this.getCompiledWithSourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("sourcesAndCompiledWithNeoForge", ((RegularFile)this.getCompiledWithSourcesArtifact().get()).getAsFile()));
            }
        } else {
            if (this.getCompiledArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("compiled", ((RegularFile)this.getCompiledArtifact().get()).getAsFile()));
            }
            if (this.getResourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("sources", ((RegularFile)this.getSourcesArtifact().get()).getAsFile()));
            }
            if (this.getCompiledWithSourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("sourcesAndCompiled", ((RegularFile)this.getCompiledWithSourcesArtifact().get()).getAsFile()));
            }
        }
        for (RequestedResult requestedResult : requestedResults) {
            args.add("--write-result");
            args.add(requestedResult.id() + ":" + requestedResult.destination().getAbsolutePath());
        }
        this.run(args);
    }

    record RequestedResult(String id, File destination) {
    }
}

