/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.internal;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.api.model.ObjectFactory;

abstract class LegacyMetadataTransform
implements ComponentMetadataRule {
    protected final ObjectFactory objects;
    private final RepositoryResourceAccessor repositoryResourceAccessor;

    LegacyMetadataTransform(ObjectFactory objects, RepositoryResourceAccessor repositoryResourceAccessor) {
        this.objects = objects;
        this.repositoryResourceAccessor = repositoryResourceAccessor;
    }

    protected final void executeWithConfig(ComponentMetadataContext context, String path) {
        JsonObject[] configRootHolder = new JsonObject[1];
        this.repositoryResourceAccessor.withResource(path, inputStream -> {
            try (JarInputStream zin = new JarInputStream(new BufferedInputStream((InputStream)inputStream));){
                JarEntry entry = zin.getNextJarEntry();
                while (entry != null) {
                    if (entry.getName().equals("config.json")) {
                        String configJson = new String(zin.readAllBytes(), StandardCharsets.UTF_8);
                        configRootHolder[0] = (JsonObject)new Gson().fromJson(configJson, JsonObject.class);
                    }
                    entry = zin.getNextJarEntry();
                }
            }
            catch (IOException e) {
                throw new GradleException("Failed to read " + path);
            }
        });
        if (configRootHolder[0] == null) {
            throw new GradleException("Couldn't find config.json in " + path);
        }
        this.adaptWithConfig(context, configRootHolder[0]);
    }

    protected abstract void adaptWithConfig(ComponentMetadataContext var1, JsonObject var2);

    protected final String createPath(ComponentMetadataContext context, String classifier, String extension) {
        ModuleVersionIdentifier id = context.getDetails().getId();
        return id.getGroup().replace('.', '/') + "/" + id.getName() + "/" + id.getVersion() + "/" + id.getName() + "-" + id.getVersion() + (String)(classifier.isBlank() ? "" : "-" + classifier) + "." + extension;
    }
}

