/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import javax.inject.Inject;
import net.neoforged.moddevgradle.dsl.DataFileCollection;
import net.neoforged.moddevgradle.dsl.ModDevExtension;
import net.neoforged.moddevgradle.dsl.ModdingVersionSettings;
import net.neoforged.moddevgradle.dsl.UnitTest;
import net.neoforged.moddevgradle.internal.ModDevPlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;

public abstract class NeoForgeExtension
extends ModDevExtension {
    public static final String NAME = "neoForge";
    private final Project project;
    private final UnitTest unitTest;

    @Inject
    public NeoForgeExtension(Project project, DataFileCollection accessTransformers, DataFileCollection interfaceInjectionData) {
        super(project, accessTransformers, interfaceInjectionData);
        this.project = project;
        this.unitTest = (UnitTest)project.getObjects().newInstance(UnitTest.class, new Object[0]);
        this.unitTest.getLoadedMods().convention(this.getMods());
    }

    public void setVersion(String version) {
        this.enable((Action<ModdingVersionSettings>)((Action)settings -> settings.setVersion(version)));
    }

    public void setNeoFormVersion(String version) {
        this.enable((Action<ModdingVersionSettings>)((Action)settings -> settings.setNeoFormVersion(version)));
    }

    public void enable(Action<ModdingVersionSettings> customizer) {
        ModDevPlugin modDevPlugin = (ModDevPlugin)this.project.getPlugins().getPlugin(ModDevPlugin.class);
        ModdingVersionSettings settings = (ModdingVersionSettings)this.project.getObjects().newInstance(ModdingVersionSettings.class, new Object[0]);
        customizer.execute((Object)settings);
        modDevPlugin.enable(this.project, settings, this);
    }

    public UnitTest getUnitTest() {
        return this.unitTest;
    }

    public void unitTest(Action<UnitTest> action) {
        action.execute((Object)this.unitTest);
    }
}

