/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.Metadata;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.MetadataIOHandler;
import net.neoforged.moddevgradle.internal.jarjar.JarJarArtifacts;
import net.neoforged.moddevgradle.internal.jarjar.ResolvedJarJarArtifact;
import net.neoforged.moddevgradle.internal.utils.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.jetbrains.annotations.ApiStatus;

public abstract class JarJar
extends DefaultTask {
    private static final String DEFAULT_GROUP = "jarjar";
    private final FileSystemOperations fileSystemOperations;

    @Nested
    @ApiStatus.Internal
    protected abstract JarJarArtifacts getJarJarArtifacts();

    @InputFiles
    @SkipWhenEmpty
    @ApiStatus.Internal
    protected abstract ConfigurableFileCollection getInputFiles();

    @Inject
    @ApiStatus.Internal
    protected abstract ObjectFactory getObjects();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Internal
    public abstract DirectoryProperty getBuildDirectory();

    @Inject
    public JarJar(FileSystemOperations fileSystemOperations) {
        this.fileSystemOperations = fileSystemOperations;
        this.getOutputDirectory().convention(this.getProject().getLayout().getBuildDirectory().dir("generated/" + this.getName()));
        this.getBuildDirectory().convention((Provider)this.getProject().getLayout().getBuildDirectory());
        this.setGroup(DEFAULT_GROUP);
    }

    public static TaskProvider<JarJar> registerWithConfiguration(Project project, String name) {
        Configuration configuration = (Configuration)project.getConfigurations().create(name);
        configuration.setTransitive(false);
        configuration.setCanBeResolved(true);
        configuration.setCanBeConsumed(false);
        JavaPluginExtension javaPlugin = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        configuration.attributes(attributes -> {
            attributes.attributeProvider(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, javaPlugin.getToolchain().getLanguageVersion().map(JavaLanguageVersion::asInt));
            attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
            attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "jar")));
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "library")));
            attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external")));
        });
        return project.getTasks().register(name, JarJar.class, jarJar -> {
            jarJar.setDescription("Creates the directory structure and metadata needed to embed other Jar files.");
            jarJar.configuration(configuration);
        });
    }

    @TaskAction
    protected void run() throws IOException {
        ArrayList<ResolvedJarJarArtifact> includedJars = new ArrayList<ResolvedJarJarArtifact>((Collection)this.getJarJarArtifacts().getResolvedArtifacts().get());
        this.fileSystemOperations.delete(spec -> spec.delete(new Object[]{this.getOutputDirectory()}));
        ArrayList<File> artifactFiles = new ArrayList<File>(includedJars.stream().map(ResolvedJarJarArtifact::getFile).toList());
        for (File file : this.getInputFiles()) {
            if (artifactFiles.contains(file)) continue;
            Optional<String> moduleName = FileUtils.getExplicitJavaModuleName(file);
            if (moduleName.isEmpty()) {
                throw new GradleException("Cannot embed local file dependency " + file + " because it has no explicit Java module name.\nPlease set either 'Automatic-Module-Name' in the Jar manifest, or make it an explicit Java module.\nThis ensures that your file does not conflict with another mods library that has the same or a similar filename.");
            }
            String hashCode = FileUtils.hashFile(file, "MD5");
            includedJars.add(new ResolvedJarJarArtifact(file, file.getName(), hashCode, "[" + hashCode + "]", "", moduleName.get()));
            artifactFiles.add(file);
        }
        if (!includedJars.isEmpty()) {
            this.fileSystemOperations.copy(spec -> {
                spec.into((Object)this.getOutputDirectory().dir("META-INF/jarjar"));
                spec.from(artifactFiles.toArray());
                for (ResolvedJarJarArtifact includedJar : includedJars) {
                    String embeddedName;
                    String originalName;
                    if ("curse.maven".equals(includedJar.getGroup())) {
                        this.getLogger().warn("Embedding dependency {}:{}:{} from cursemaven using JiJ is likely to cause conflicts at runtime when other mods include the same library from a normal Maven repository.", new Object[]{includedJar.getGroup(), includedJar.getArtifact(), includedJar.getVersion()});
                    } else if ("maven.modrinth".equals(includedJar.getGroup())) {
                        this.getLogger().warn("Embedding dependency {}:{}:{} from Modrinth Maven using JiJ is likely to cause conflicts at runtime when other mods include the same library from a normal Maven repository.", new Object[]{includedJar.getGroup(), includedJar.getArtifact(), includedJar.getVersion()});
                    }
                    if ((originalName = includedJar.getFile().getName()).equals(embeddedName = includedJar.getEmbeddedFilename())) continue;
                    spec.rename(Pattern.quote(originalName), Matcher.quoteReplacement(embeddedName));
                }
                spec.from(new Object[]{this.writeMetadata(includedJars).toFile()});
            });
        }
    }

    private Path writeMetadata(List<ResolvedJarJarArtifact> includedJars) {
        Path metadataPath = this.getJarJarMetadataPath();
        Metadata metadata = this.createMetadata(includedJars);
        try {
            metadataPath.toFile().getParentFile().mkdirs();
            Files.deleteIfExists(metadataPath);
            Files.write(metadataPath, MetadataIOHandler.toLines(metadata), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write JarJar dependency metadata to disk.", e);
        }
        return metadataPath;
    }

    public void configuration(Configuration jarJarConfiguration) {
        this.getInputFiles().from(new Object[]{jarJarConfiguration});
        this.getJarJarArtifacts().configuration(jarJarConfiguration);
        this.dependsOn(new Object[]{jarJarConfiguration});
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        ConfigurableFileCollection newConfig = this.getObjects().fileCollection();
        newConfig.from(configurations.toArray());
        this.getInputFiles().setFrom((Iterable)newConfig);
        this.getJarJarArtifacts().setConfigurations(configurations);
        configurations.forEach(xva$0 -> this.dependsOn(new Object[]{xva$0}));
    }

    private Path getJarJarMetadataPath() {
        return this.getTemporaryDir().toPath().resolve("metadata.json");
    }

    private Metadata createMetadata(List<ResolvedJarJarArtifact> jars) {
        return new Metadata(jars.stream().map(ResolvedJarJarArtifact::createContainerMetadata).collect(Collectors.toList()));
    }
}

