/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.internal;

import java.net.URI;
import java.util.Map;
import java.util.stream.Stream;
import net.neoforged.moddevgradle.dsl.NeoForgeExtension;
import net.neoforged.moddevgradle.internal.LegacyForgeFacade;
import net.neoforged.moddevgradle.internal.ModDevPlugin;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.VersionCapabilities;
import net.neoforged.moddevgradle.legacyforge.dsl.MixinExtension;
import net.neoforged.moddevgradle.legacyforge.dsl.Obfuscation;
import net.neoforged.moddevgradle.legacyforge.internal.LegacyForgeMetadataTransform;
import net.neoforged.moddevgradle.legacyforge.internal.McpMetadataTransform;
import net.neoforged.moddevgradle.legacyforge.internal.NonStrictDependencyTransform;
import net.neoforged.moddevgradle.legacyforge.internal.RemappingTransform;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapJar;
import net.neoforged.nfrtgradle.CreateMinecraftArtifacts;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LegacyForgeModDevPlugin
implements Plugin<Project> {
    public static final Attribute<Boolean> REMAPPED = Attribute.of((String)"net.neoforged.moddevgradle.legacy.remapped", Boolean.class);
    public static final String CONFIGURATION_TOOL_ART = "autoRenamingToolRuntime";
    public static final String CONFIGURATION_TOOL_INSTALLERTOOLS = "installerToolsRuntime";

    public void apply(Project project) {
        project.getPlugins().apply(ModDevPlugin.class);
        project.getRepositories().maven(repo -> {
            repo.setName("MinecraftForge");
            repo.setUrl(URI.create("https://maven.minecraftforge.net/"));
        });
        project.getDependencies().getComponents().withModule((Object)"net.neoforged:forge", LegacyForgeMetadataTransform.class);
        project.getDependencies().getComponents().withModule((Object)"net.minecraftforge:forge", LegacyForgeMetadataTransform.class);
        project.getDependencies().getComponents().withModule((Object)"de.oceanlabs.mcp:mcp_config", McpMetadataTransform.class);
        project.getDependencies().getComponents().withModule((Object)"net.neoforged:minecraft-dependencies", NonStrictDependencyTransform.class);
        DependencyFactory depFactory = project.getDependencyFactory();
        Configuration autoRenamingToolRuntime = (Configuration)project.getConfigurations().create(CONFIGURATION_TOOL_ART, spec -> {
            spec.setDescription("The AutoRenamingTool CLI tool");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.setTransitive(false);
            spec.getDependencies().add((Object)depFactory.create((CharSequence)"net.neoforged:AutoRenamingTool:2.0.4:all"));
        });
        Configuration installerToolsRuntime = (Configuration)project.getConfigurations().create(CONFIGURATION_TOOL_INSTALLERTOOLS, spec -> {
            spec.setDescription("The InstallerTools CLI tool");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.setTransitive(false);
            spec.getDependencies().add((Object)depFactory.create((CharSequence)"net.neoforged.installertools:installertools:2.1.10:fatjar"));
        });
        Provider modDevBuildDir = project.getLayout().getBuildDirectory().dir("moddev");
        Provider namedToIntermediate = modDevBuildDir.map(d -> d.file("namedToIntermediate.tsrg"));
        Provider intermediateToNamed = modDevBuildDir.map(d -> d.file("intermediateToNamed.srg"));
        Provider mappingsCsv = modDevBuildDir.map(d -> d.file("intermediateToNamed.zip"));
        ConfigurableFileCollection extraMixinMappings = project.files(new Object[0]);
        Obfuscation obf = (Obfuscation)project.getExtensions().create("obfuscation", Obfuscation.class, new Object[]{project, namedToIntermediate, mappingsCsv, autoRenamingToolRuntime, installerToolsRuntime, extraMixinMappings});
        MixinExtension mixin = (MixinExtension)project.getExtensions().create("mixin", MixinExtension.class, new Object[]{project, namedToIntermediate, extraMixinMappings});
        project.getExtensions().configure(NeoForgeExtension.class, extension -> {
            extension.getNeoForgeArtifact().set(extension.getVersion().map(version -> "net.minecraftforge:forge:" + version));
            extension.getNeoFormArtifact().set(extension.getNeoFormVersion().map(version -> "de.oceanlabs.mcp:mcp_config:" + version));
            extension.getAdditionalMinecraftArtifacts().put((Object)"namedToIntermediaryMapping", namedToIntermediate.map(RegularFile::getAsFile));
            extension.getAdditionalMinecraftArtifacts().put((Object)"intermediaryToNamedMapping", intermediateToNamed.map(RegularFile::getAsFile));
            extension.getAdditionalMinecraftArtifacts().put((Object)"csvMapping", mappingsCsv.map(RegularFile::getAsFile));
            extension.getRuns().configureEach(run -> {
                LegacyForgeFacade.configureRun(project, run);
                run.getSystemProperties().put((Object)"mixin.env.remapRefMap", (Object)"true");
                run.getSystemProperties().put((Object)"mixin.env.refMapRemappingFile", intermediateToNamed.map(f -> f.getAsFile().getAbsolutePath()));
                run.getProgramArguments().addAll(mixin.getConfigs().map(cfgs -> cfgs.stream().flatMap(config -> Stream.of("--mixin.config", config)).toList()));
            });
        });
        TaskProvider<RemapJar> reobfJar = obf.reobfuscate((TaskProvider<? extends AbstractArchiveTask>)project.getTasks().named("jar", Jar.class), (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
        project.getTasks().named("assemble", assemble -> assemble.dependsOn(new Object[]{reobfJar}));
        project.getConfigurations().getByName("neoForgeRuntimeDependencies").getDependencies().add((Object)project.getDependencyFactory().create((FileCollection)project.files(new Object[]{mappingsCsv})));
        project.getConfigurations().getByName("additionalRuntimeClasspath").extendsFrom(new Configuration[]{project.getConfigurations().getByName("neoForgeRuntimeDependencies")}).exclude(Map.of("group", "net.neoforged", "module", "DevLaunch"));
        project.getDependencies().attributesSchema(schema -> schema.attribute(REMAPPED));
        project.getDependencies().getArtifactTypes().named("jar", a -> a.getAttributes().attribute(REMAPPED, (Object)false));
        Configuration remapDeps = (Configuration)project.getConfigurations().create("remappingDependencies", spec -> {
            spec.setDescription("An internal configuration that contains the Minecraft dependencies, used for remapping mods");
            spec.setCanBeConsumed(false);
            spec.setCanBeDeclared(false);
            spec.setCanBeResolved(true);
            spec.extendsFrom(new Configuration[]{project.getConfigurations().getByName("neoForgeRuntimeDependencies")});
        });
        project.getDependencies().registerTransform(RemappingTransform.class, params -> {
            params.parameters(parameters -> {
                obf.configureSrgToNamedOperation(parameters.getRemapOperation());
                parameters.getMinecraftDependencies().from(new Object[]{remapDeps});
            });
            params.getFrom().attribute(REMAPPED, (Object)false).attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
            params.getTo().attribute(REMAPPED, (Object)true).attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
        });
        project.getTasks().withType(CreateMinecraftArtifacts.class).configureEach(task -> {
            NeoForgeExtension extension = ExtensionUtils.getExtension((ExtensionAware)project, "neoForge", NeoForgeExtension.class);
            JavaToolchainService toolchainService = ExtensionUtils.getExtension((ExtensionAware)project, "javaToolchains", JavaToolchainService.class);
            task.getToolsJavaExecutable().set(toolchainService.launcherFor(spec -> spec.getLanguageVersion().set(extension.getVersion().map(VersionCapabilities::ofForgeVersion).orElse(extension.getNeoFormVersion().map(VersionCapabilities::ofNeoFormVersion)).map(VersionCapabilities::javaVersion).map(JavaLanguageVersion::of))).map(JavaLauncher::getExecutablePath).map(f -> f.getAsFile().getAbsolutePath()));
        });
        obf.createRemappingConfiguration(project.getConfigurations().getByName("implementation"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("runtimeOnly"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("compileOnly"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("api"));
        obf.createRemappingConfiguration(project.getConfigurations().getByName("compileOnlyApi"));
    }
}

