/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.dsl;

import java.util.List;
import javax.inject.Inject;
import net.neoforged.moddev.shadow.org.apache.commons.lang3.StringUtils;
import net.neoforged.moddevgradle.legacyforge.internal.LegacyForgeModDevPlugin;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapJar;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapOperation;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.ApiStatus;

public abstract class Obfuscation {
    private final Project project;
    private final Provider<RegularFile> officialToSrg;
    private final Provider<RegularFile> mappingsCsv;
    private final Configuration autoRenamingToolRuntime;
    private final Configuration installerToolsRuntime;
    private final FileCollection extraMixinMappings;

    @Inject
    public Obfuscation(Project project, Provider<RegularFile> officialToSrg, Provider<RegularFile> mappingsCsv, Configuration autoRenamingToolRuntime, Configuration installerToolsRuntime, FileCollection extraMixinMappings) {
        this.project = project;
        this.officialToSrg = officialToSrg;
        this.mappingsCsv = mappingsCsv;
        this.autoRenamingToolRuntime = autoRenamingToolRuntime;
        this.installerToolsRuntime = installerToolsRuntime;
        this.extraMixinMappings = extraMixinMappings;
    }

    @ApiStatus.Internal
    public void configureNamedToSrgOperation(RemapOperation operation) {
        operation.getToolType().set((Object)RemapOperation.ToolType.ART);
        operation.getToolClasspath().from(new Object[]{this.autoRenamingToolRuntime});
        operation.getMappings().from(new Object[]{this.officialToSrg});
    }

    @ApiStatus.Internal
    public void configureSrgToNamedOperation(RemapOperation operation) {
        operation.getToolType().set((Object)RemapOperation.ToolType.INSTALLER_TOOLS);
        operation.getToolClasspath().from(new Object[]{this.installerToolsRuntime});
        operation.getMappings().from(new Object[]{this.mappingsCsv});
    }

    public TaskProvider<RemapJar> reobfuscate(TaskProvider<? extends AbstractArchiveTask> jar, SourceSet sourceSet) {
        return this.reobfuscate(jar, sourceSet, (Action<RemapJar>)((Action)ignored -> {}));
    }

    public TaskProvider<RemapJar> reobfuscate(TaskProvider<? extends AbstractArchiveTask> jar, SourceSet sourceSet, Action<RemapJar> configuration) {
        TaskProvider reobf = this.project.getTasks().register("reobf" + StringUtils.capitalize(jar.getName()), RemapJar.class, task -> {
            task.getInput().set(jar.flatMap(AbstractArchiveTask::getArchiveFile));
            task.getDestinationDirectory().convention(task.getProject().getLayout().getBuildDirectory().dir("libs"));
            task.getArchiveBaseName().convention(jar.flatMap(AbstractArchiveTask::getArchiveBaseName));
            task.getArchiveVersion().convention(jar.flatMap(AbstractArchiveTask::getArchiveVersion));
            task.getArchiveClassifier().convention(jar.flatMap(AbstractArchiveTask::getArchiveClassifier));
            task.getArchiveAppendix().convention(jar.flatMap(AbstractArchiveTask::getArchiveAppendix));
            task.getLibraries().from(new Object[]{sourceSet.getCompileClasspath()});
            this.configureNamedToSrgOperation(task.getRemapOperation());
            task.getRemapOperation().getMappings().from(new Object[]{this.extraMixinMappings});
            configuration.execute((Object)task);
        });
        jar.configure(task -> {
            task.finalizedBy(new Object[]{reobf});
            task.getDestinationDirectory().set(task.getProject().getLayout().getBuildDirectory().dir("devlibs"));
        });
        AdhocComponentWithVariants java = (AdhocComponentWithVariants)this.project.getComponents().getByName("java");
        for (String configurationName : List.of("runtimeElements", "apiElements")) {
            this.project.getArtifacts().add(configurationName, (Object)reobf);
            java.withVariantsFromConfiguration(this.project.getConfigurations().getByName(configurationName), variant -> variant.getConfigurationVariant().getArtifacts().removeIf(artifact -> artifact.getFile().equals(((RegularFile)((AbstractArchiveTask)jar.get()).getArchiveFile().get()).getAsFile())));
        }
        return reobf;
    }

    public Configuration createRemappingConfiguration(Configuration parent) {
        Configuration remappingConfig = (Configuration)this.project.getConfigurations().create("mod" + StringUtils.capitalize(parent.getName()), spec -> {
            spec.setDescription("Configuration for dependencies of " + parent.getName() + " that needs to be remapped");
            spec.attributes(attributeContainer -> attributeContainer.attribute(LegacyForgeModDevPlugin.REMAPPED, (Object)true));
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(false);
            spec.setTransitive(false);
            spec.withDependencies(dependencies -> dependencies.forEach(dep -> {
                if (dep instanceof ExternalModuleDependency) {
                    ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dep;
                    this.project.getDependencies().constraints(constraints -> constraints.add(parent.getName(), (Object)(externalModuleDependency.getGroup() + ":" + externalModuleDependency.getName() + ":" + externalModuleDependency.getVersion()), c -> c.attributes(a -> a.attribute(LegacyForgeModDevPlugin.REMAPPED, (Object)true))));
                    externalModuleDependency.setTransitive(false);
                } else if (dep instanceof FileCollectionDependency) {
                    FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dep;
                    this.project.getDependencies().constraints(constraints -> constraints.add(parent.getName(), (Object)fileCollectionDependency.getFiles(), c -> c.attributes(a -> a.attribute(LegacyForgeModDevPlugin.REMAPPED, (Object)true))));
                } else if (dep instanceof ProjectDependency) {
                    ProjectDependency projectDependency = (ProjectDependency)dep;
                    this.project.getDependencies().constraints(constraints -> constraints.add(parent.getName(), (Object)projectDependency.getDependencyProject(), c -> c.attributes(a -> a.attribute(LegacyForgeModDevPlugin.REMAPPED, (Object)true))));
                    projectDependency.setTransitive(false);
                }
            }));
        });
        parent.extendsFrom(new Configuration[]{remappingConfig});
        return remappingConfig;
    }
}

