/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.moddevgradle.internal.generated.MinecraftVersionList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record VersionCapabilities(int javaVersion, boolean splitDataRuns) implements Serializable
{
    private static final Logger LOG = LoggerFactory.getLogger(VersionCapabilities.class);
    private static final VersionCapabilities LATEST = new VersionCapabilities(21, true);
    private static final Pattern NEOFORGE_PATTERN = Pattern.compile("^(\\d+\\.\\d+)\\.\\d+(|-.*)$");
    private static final int MC_24W45A_INDEX = VersionCapabilities.getReferenceVersionIndex("24w45a");
    private static final int MC_24W14A_INDEX = VersionCapabilities.getReferenceVersionIndex("24w14a");
    private static final int MC_1_18_PRE2_INDEX = VersionCapabilities.getReferenceVersionIndex("1.18-pre2");
    private static final int MC_21W19A_INDEX = VersionCapabilities.getReferenceVersionIndex("21w19a");

    public static VersionCapabilities latest() {
        return LATEST;
    }

    public static VersionCapabilities ofMinecraftVersion(String minecraftVersion) {
        int versionIndex = MinecraftVersionList.VERSIONS.indexOf(minecraftVersion);
        if (versionIndex == -1) {
            LOG.info("Minecraft Version {} is unknown. Assuming latest capabilities.", (Object)versionIndex);
            return LATEST;
        }
        return VersionCapabilities.ofVersionIndex(versionIndex);
    }

    public static VersionCapabilities ofVersionIndex(int versionIndex) {
        int javaVersion = VersionCapabilities.getJavaVersion(versionIndex);
        boolean splitData = VersionCapabilities.hasSplitDataEntrypoints(versionIndex);
        return new VersionCapabilities(javaVersion, splitData);
    }

    static int getJavaVersion(int versionIndex) {
        if (versionIndex <= MC_24W14A_INDEX) {
            return 21;
        }
        if (versionIndex <= MC_1_18_PRE2_INDEX) {
            return 17;
        }
        if (versionIndex <= MC_21W19A_INDEX) {
            return 16;
        }
        return 8;
    }

    static boolean hasSplitDataEntrypoints(int versionIndex) {
        return versionIndex <= MC_24W45A_INDEX;
    }

    static int indexOfNeoForgeVersion(String version) {
        Matcher matcher = NEOFORGE_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return -1;
        }
        return MinecraftVersionList.VERSIONS.indexOf("1." + matcher.group(1));
    }

    public static VersionCapabilities ofNeoForgeVersion(String version) {
        int index = VersionCapabilities.indexOfNeoForgeVersion(version);
        if (index == -1) {
            LOG.warn("Failed to parse MC version from NeoForge version {}. Using capabilities of latest known Minecraft version.", (Object)version);
            return LATEST;
        }
        return VersionCapabilities.ofVersionIndex(index);
    }

    static int indexOfNeoFormVersion(String version) {
        return MinecraftVersionList.indexOfByPrefix(version, "-");
    }

    public static VersionCapabilities ofNeoFormVersion(String version) {
        int index = VersionCapabilities.indexOfNeoFormVersion(version);
        if (index == -1) {
            LOG.warn("Failed to parse MC version from NeoForm version {}. Using capabilities of latest known Minecraft version.", (Object)version);
            return LATEST;
        }
        return VersionCapabilities.ofVersionIndex(index);
    }

    static int indexOfForgeVersion(String version) {
        return MinecraftVersionList.indexOfByPrefix(version, "-");
    }

    public static VersionCapabilities ofForgeVersion(String version) {
        int index = VersionCapabilities.indexOfForgeVersion(version);
        if (index == -1) {
            LOG.warn("Failed to parse MC version from Forge version {}. Using capabilities of latest known Minecraft version.", (Object)version);
            return LATEST;
        }
        return VersionCapabilities.ofVersionIndex(index);
    }

    private static int getReferenceVersionIndex(String v) {
        int idx = MinecraftVersionList.VERSIONS.indexOf(v);
        if (idx == -1) {
            throw new IllegalArgumentException("Reference version " + v + " is not in version list!");
        }
        return idx;
    }
}

