/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import net.neoforged.minecraftdependencies.MinecraftDependenciesPlugin;
import net.neoforged.minecraftdependencies.MinecraftDistribution;
import net.neoforged.moddevgradle.dsl.DataFileCollection;
import net.neoforged.moddevgradle.dsl.InternalModelHelper;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.NeoForgeExtension;
import net.neoforged.moddevgradle.dsl.Parchment;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.CreateLaunchScriptTask;
import net.neoforged.moddevgradle.internal.IdeIntegration;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.PrepareRun;
import net.neoforged.moddevgradle.internal.PrepareTest;
import net.neoforged.moddevgradle.internal.RepositoriesPlugin;
import net.neoforged.moddevgradle.internal.RunGameTask;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.moddevgradle.internal.WriteLegacyClasspath;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.VersionCapabilities;
import net.neoforged.moddevgradle.tasks.JarJar;
import net.neoforged.nfrtgradle.CreateMinecraftArtifacts;
import net.neoforged.nfrtgradle.DownloadAssets;
import net.neoforged.nfrtgradle.NeoFormRuntimePlugin;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ModDevPlugin
implements Plugin<Project> {
    private static final Logger LOG = LoggerFactory.getLogger(ModDevPlugin.class);
    static final String JUNIT_GAME_DIR = "build/minecraft-junit";
    public static final String CONFIGURATION_RUNTIME_DEPENDENCIES = "neoForgeRuntimeDependencies";
    public static final String CONFIGURATION_COMPILE_DEPENDENCIES = "neoForgeCompileDependencies";
    private final ObjectFactory objectFactory;
    private Runnable configureTesting = null;

    @Inject
    public ModDevPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project) {
        project.getPlugins().apply(JavaLibraryPlugin.class);
        project.getPlugins().apply(NeoFormRuntimePlugin.class);
        project.getPlugins().apply(MinecraftDependenciesPlugin.class);
        if (!project.getGradle().getPlugins().hasPlugin(RepositoriesPlugin.class)) {
            project.getPlugins().apply(RepositoriesPlugin.class);
        } else {
            LOG.info("Not enabling NeoForged repositories since they were applied at the settings level");
        }
        JavaPluginExtension javaExtension = ExtensionUtils.getExtension((ExtensionAware)project, "java", JavaPluginExtension.class);
        ConfigurationContainer configurations = project.getConfigurations();
        ProjectLayout layout = project.getLayout();
        TaskContainer tasks = project.getTasks();
        IdeIntegration ideIntegration = IdeIntegration.of(project, Branding.MDG);
        Provider modDevBuildDir = layout.getBuildDirectory().dir("moddev");
        DataFileCollectionWrapper accessTransformers = ModDevPlugin.dataFileConfiguration(project, "accessTransformers", "AccessTransformers to widen visibility of Minecraft classes/fields/methods", "accesstransformer");
        accessTransformers.extension.getFiles().convention(new Object[]{project.provider(() -> {
            ConfigurableFileCollection collection = project.getObjects().fileCollection();
            SourceSet mainSourceSet = (SourceSet)ExtensionUtils.getSourceSets(project).getByName("main");
            for (File resources : mainSourceSet.getResources().getSrcDirs()) {
                File defaultPath = new File(resources, "META-INF/accesstransformer.cfg");
                if (!project.file((Object)defaultPath).exists()) continue;
                return collection.from(new Object[]{defaultPath.getAbsolutePath()});
            }
            return collection;
        })});
        DataFileCollectionWrapper interfaceInjectionData = ModDevPlugin.dataFileConfiguration(project, "interfaceInjectionData", "Interface injection data adds extend/implements clauses for interfaces to Minecraft code at development time", "interfaceinjection");
        NeoForgeExtension extension = (NeoForgeExtension)project.getExtensions().create("neoForge", NeoForgeExtension.class, new Object[]{accessTransformers.extension, interfaceInjectionData.extension});
        ideIntegration.runTaskOnProjectSync(extension.getIdeSyncTasks());
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        Provider versionCapabilities = extension.getVersion().map(VersionCapabilities::ofForgeVersion).orElse(extension.getNeoFormVersion().map(VersionCapabilities::ofNeoFormVersion)).orElse((Object)VersionCapabilities.latest());
        Provider neoForgeModDevLibrariesDependency = extension.getNeoForgeArtifact().map(artifactId -> dependencyFactory.create((CharSequence)artifactId).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies"))).orElse(extension.getNeoFormArtifact().map(artifact -> dependencyFactory.create((CharSequence)artifact).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-dependencies"))));
        List<Configuration> createManifestConfigurations = this.configureArtifactManifestConfigurations(project, extension);
        Parchment parchment = extension.getParchment();
        Configuration parchmentData = (Configuration)configurations.create("parchmentData", spec -> {
            spec.setDescription("Data used to add parameter names and javadoc to Minecraft sources");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.setTransitive(false);
            spec.getDependencies().addLater(parchment.getParchmentArtifact().map(arg_0 -> ((DependencyFactory)project.getDependencyFactory()).create(arg_0)));
        });
        TaskProvider createArtifacts = tasks.register("createMinecraftArtifacts", CreateMinecraftArtifacts.class, task -> {
            task.setGroup(Branding.MDG.internalTaskGroup());
            task.setDescription("Creates the NeoForge and Minecraft artifacts by invoking NFRT.");
            for (Configuration configuration : createManifestConfigurations) {
                task.addArtifactsToManifest(configuration);
            }
            task.getAccessTransformers().from(new Object[]{accessTransformers.configuration});
            task.getInterfaceInjectionData().from(new Object[]{interfaceInjectionData.configuration});
            task.getValidateAccessTransformers().set(extension.getValidateAccessTransformers());
            task.getParchmentData().from(new Object[]{parchmentData});
            task.getParchmentEnabled().set(parchment.getEnabled());
            task.getParchmentConflictResolutionPrefix().set(parchment.getConflictResolutionPrefix());
            Provider minecraftArtifactsDir = modDevBuildDir.map(dir -> dir.dir("artifacts"));
            Function<String, Provider> jarPathFactory = suffix -> minecraftArtifactsDir.zip(extension.getNeoForgeArtifact().map(art -> {
                String[] split = art.split(":", 3);
                return split[1] + "-" + split[2];
            }).orElse(extension.getNeoFormArtifact().map(v -> "vanilla-" + v.split(":", 3)[2])), (dir, prefix) -> dir.file(prefix + "-minecraft" + suffix + ".jar"));
            task.getCompiledArtifact().set(jarPathFactory.apply(""));
            task.getCompiledWithSourcesArtifact().set(jarPathFactory.apply("-merged"));
            task.getSourcesArtifact().set(jarPathFactory.apply("-sources"));
            task.getResourcesArtifact().set(minecraftArtifactsDir.zip(extension.getNeoForgeArtifact().map(art -> {
                String[] split = art.split(":", 3);
                return split[2] + "-" + split[1];
            }).orElse(extension.getNeoFormArtifact().map(v -> "vanilla-" + v.split(":", 3)[2])), (dir, prefix) -> dir.file("client-extra-aka-minecraft-resources-" + prefix + ".jar")));
            task.getNeoForgeArtifact().set(ModDevPlugin.getNeoForgeUserDevDependencyNotation(extension));
            task.getNeoFormArtifact().set(ModDevPlugin.getNeoFormDataDependencyNotation(extension));
            task.getAdditionalResults().putAll(extension.getAdditionalMinecraftArtifacts());
        });
        ideIntegration.runTaskOnProjectSync(createArtifacts);
        TaskProvider downloadAssets = tasks.register("downloadAssets", DownloadAssets.class, task -> {
            task.setGroup(Branding.MDG.publicTaskGroup());
            task.setDescription("Downloads the Minecraft assets and asset index needed to run a Minecraft client or generate client-side resources.");
            for (Configuration configuration : createManifestConfigurations) {
                task.addArtifactsToManifest(configuration);
            }
            task.getAssetPropertiesFile().set(modDevBuildDir.map(dir -> dir.file("minecraft_assets.properties")));
            task.getNeoForgeArtifact().set(ModDevPlugin.getNeoForgeUserDevDependencyNotation(extension));
            task.getNeoFormArtifact().set(ModDevPlugin.getNeoFormDataDependencyNotation(extension));
        });
        Provider minecraftClassesArtifact = ideIntegration.shouldUseCombinedSourcesAndClassesArtifact() ? createArtifacts.map(task -> project.files(new Object[]{task.getCompiledWithSourcesArtifact()})) : createArtifacts.map(task -> project.files(new Object[]{task.getCompiledArtifact()}));
        configurations.create(CONFIGURATION_RUNTIME_DEPENDENCIES, config -> {
            config.setDescription("The runtime dependencies to develop a mod for NeoForge, including Minecraft classes.");
            config.setCanBeResolved(false);
            config.setCanBeConsumed(false);
            config.getDependencies().addLater(minecraftClassesArtifact.map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
            config.getDependencies().addLater(createArtifacts.map(task -> project.files(new Object[]{task.getResourcesArtifact()})).map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
            config.getDependencies().addLater(neoForgeModDevLibrariesDependency);
        });
        configurations.create(CONFIGURATION_COMPILE_DEPENDENCIES, config -> {
            config.setDescription("The compile-time dependencies to develop a mod for NeoForge, including Minecraft classes.");
            config.setCanBeResolved(false);
            config.setCanBeConsumed(false);
            config.getDependencies().addLater(minecraftClassesArtifact.map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
            config.getDependencies().addLater(neoForgeModDevLibrariesDependency);
        });
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        extension.addModdingDependenciesTo((SourceSet)sourceSets.getByName("main"));
        project.afterEvaluate(ignored -> {
            JavaToolchainSpec toolchainSpec = javaExtension.getToolchain();
            try {
                toolchainSpec.getLanguageVersion().convention(versionCapabilities.map(VersionCapabilities::javaVersion).map(JavaLanguageVersion::of));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        Configuration userDevConfigOnly = (Configuration)project.getConfigurations().create("neoForgeConfigOnly", spec -> {
            spec.setDescription("Resolves exclusively the NeoForge userdev JSON for configuring runs");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.setTransitive(false);
            spec.getDependencies().addLater(extension.getNeoForgeArtifact().map(artifact -> dependencyFactory.create((CharSequence)artifact).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-config"))));
        });
        Configuration additionalClasspath = (Configuration)configurations.create("additionalRuntimeClasspath", spec -> {
            spec.setDescription("Contains dependencies of every run, that should not be considered boot classpath modules.");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.getDependencies().addLater(neoForgeModDevLibrariesDependency);
            ModDevPlugin.addClientResources(project, spec, (TaskProvider<CreateMinecraftArtifacts>)createArtifacts);
        });
        Provider modulePathDependency = extension.getNeoForgeArtifact().map(artifactId -> dependencyFactory.create((CharSequence)artifactId).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-module-path")).exclude(Map.of("group", "org.jetbrains", "module", "annotations")));
        ModDevPlugin.setupRuns(project, Branding.MDG, (Provider<Directory>)modDevBuildDir, extension.getRuns(), userDevConfigOnly, modulePath -> modulePath.getDependencies().addLater(modulePathDependency), legacyClassPath -> legacyClassPath.extendsFrom(new Configuration[]{additionalClasspath}), (Provider<RegularFile>)downloadAssets.flatMap(DownloadAssets::getAssetPropertiesFile), (Provider<VersionCapabilities>)versionCapabilities);
        ModDevPlugin.setupJarJar(project);
        this.configureTesting = () -> {
            configurations.named("testCompileOnly").configure(configuration -> {
                configuration.getDependencies().addLater(minecraftClassesArtifact.map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
                configuration.getDependencies().addLater(neoForgeModDevLibrariesDependency);
            });
            Configuration testFixtures = (Configuration)configurations.create("neoForgeTestFixtures", config -> {
                config.setDescription("Additional JUnit helpers provided by NeoForge");
                config.setCanBeResolved(false);
                config.setCanBeConsumed(false);
                config.getDependencies().addLater(extension.getNeoForgeArtifact().map(artifact -> dependencyFactory.create((CharSequence)artifact).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-test-fixtures"))));
            });
            configurations.getByName("testRuntimeClasspath", files -> {
                files.extendsFrom(new Configuration[]{configurations.getByName(CONFIGURATION_RUNTIME_DEPENDENCIES)});
                files.extendsFrom(new Configuration[]{testFixtures});
            });
            ModDevPlugin.setupTestTask(project, Branding.MDG, userDevConfigOnly, (TaskProvider<Test>)tasks.named("test", Test.class), extension.getUnitTest().getLoadedMods(), extension.getUnitTest().getTestedMod(), (Provider<Directory>)modDevBuildDir, modulePath -> modulePath.getDependencies().addLater(modulePathDependency), spec -> {
                spec.getDependencies().addLater(neoForgeModDevLibrariesDependency);
                ModDevPlugin.addClientResources(project, spec, (TaskProvider<CreateMinecraftArtifacts>)createArtifacts);
            }, (Provider<RegularFile>)downloadAssets.flatMap(DownloadAssets::getAssetPropertiesFile));
        };
        if (!ideIntegration.shouldUseCombinedSourcesAndClassesArtifact()) {
            ideIntegration.attachSources(Map.of(((CreateMinecraftArtifacts)((Object)createArtifacts.get())).getCompiledArtifact(), ((CreateMinecraftArtifacts)((Object)createArtifacts.get())).getSourcesArtifact()));
        }
    }

    private static void addClientResources(Project project, Configuration spec, TaskProvider<CreateMinecraftArtifacts> createArtifacts) {
        spec.getDependencies().add((Object)project.getDependencyFactory().create((FileCollection)project.files(new Object[]{createArtifacts.flatMap(CreateMinecraftArtifacts::getResourcesArtifact)})));
    }

    private static Provider<String> getNeoFormDataDependencyNotation(NeoForgeExtension extension) {
        return extension.getNeoFormArtifact().map(art -> art + "@zip");
    }

    private static Provider<String> getNeoForgeUserDevDependencyNotation(NeoForgeExtension extension) {
        return extension.getNeoForgeArtifact().map(art -> art + ":userdev");
    }

    private List<Configuration> configureArtifactManifestConfigurations(Project project, NeoForgeExtension extension) {
        ConfigurationContainer configurations = project.getConfigurations();
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        String configurationPrefix = "neoFormRuntimeDependencies";
        Provider neoForgeDependency = extension.getNeoForgeArtifact().map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0));
        Provider neoFormDependency = extension.getNeoFormArtifact().map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0));
        Configuration neoForgeClassesAndData = (Configuration)configurations.create(configurationPrefix + "NeoForgeClasses", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (NeoForge classes)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.getDependencies().addLater(neoForgeDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-bundle"))));
            spec.getDependencies().addLater(neoFormDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform"))));
        });
        Configuration neoForgeSources = (Configuration)configurations.create(configurationPrefix + "NeoForgeSources", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (NeoForge sources)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.getDependencies().addLater(neoForgeDependency);
            spec.attributes(attributes -> {
                ModDevPlugin.setNamedAttribute(project, attributes, Category.CATEGORY_ATTRIBUTE, "documentation");
                ModDevPlugin.setNamedAttribute(project, attributes, DocsType.DOCS_TYPE_ATTRIBUTE, "sources");
            });
        });
        Configuration compileClasspath = (Configuration)configurations.create(configurationPrefix + "CompileClasspath", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (Classpath)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.getDependencies().addLater(neoForgeDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies"))));
            spec.getDependencies().addLater(neoFormDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-dependencies"))));
            spec.attributes(attributes -> {
                this.setNamedAttribute((AttributeContainer)attributes, (Attribute)Usage.USAGE_ATTRIBUTE, "java-api");
                this.setNamedAttribute((AttributeContainer)attributes, (Attribute)MinecraftDistribution.ATTRIBUTE, "client");
            });
        });
        Configuration runtimeClasspath = (Configuration)configurations.create(configurationPrefix + "RuntimeClasspath", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (Classpath)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.getDependencies().addLater(neoForgeDependency);
            spec.getDependencies().addLater(neoForgeDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies"))));
            spec.getDependencies().addLater(neoFormDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-dependencies"))));
            spec.attributes(attributes -> {
                this.setNamedAttribute((AttributeContainer)attributes, (Attribute)Usage.USAGE_ATTRIBUTE, "java-runtime");
                this.setNamedAttribute((AttributeContainer)attributes, (Attribute)MinecraftDistribution.ATTRIBUTE, "client");
            });
        });
        return List.of(neoForgeClassesAndData, neoForgeSources, compileClasspath, runtimeClasspath);
    }

    static void setupRuns(Project project, Branding branding, Provider<Directory> argFileDir, DomainObjectCollection<RunModel> runs, Object runTemplatesSourceFile, Consumer<Configuration> configureModulePath, Consumer<Configuration> configureLegacyClasspath, Provider<RegularFile> assetPropertiesFile, Provider<VersionCapabilities> versionCapabilities) {
        IdeIntegration ideIntegration = IdeIntegration.of(project, branding);
        Configuration devLaunchConfig = (Configuration)project.getConfigurations().create("devLaunchConfig", spec -> {
            spec.setDescription("This configuration is used to inject DevLaunch into the runtime classpaths of runs.");
            spec.getDependencies().add((Object)project.getDependencyFactory().create((CharSequence)RunUtils.DEV_LAUNCH_GAV));
        });
        TaskProvider createLaunchScriptsTask = project.getTasks().register("createLaunchScripts", Task.class, task -> {
            task.setGroup(branding.publicTaskGroup());
            task.setDescription("Creates batch files/shell scripts to launch the game from outside of Gradle (i.e. Renderdoc, NVidia Nsight, etc.)");
        });
        IdentityHashMap<RunModel, TaskProvider<PrepareRun>> prepareRunTasks = new IdentityHashMap<RunModel, TaskProvider<PrepareRun>>();
        runs.all(run -> {
            TaskProvider<PrepareRun> prepareRunTask = ModDevPlugin.setupRunInGradle(project, branding, argFileDir, run, runTemplatesSourceFile, configureModulePath, configureLegacyClasspath, assetPropertiesFile, devLaunchConfig, versionCapabilities, (TaskProvider<Task>)createLaunchScriptsTask);
            prepareRunTasks.put((RunModel)run, prepareRunTask);
        });
        ideIntegration.configureRuns((Map<RunModel, TaskProvider<PrepareRun>>)prepareRunTasks, (Iterable<RunModel>)runs);
    }

    private static TaskProvider<PrepareRun> setupRunInGradle(Project project, Branding branding, Provider<Directory> argFileDir, RunModel run, Object runTemplatesFile, Consumer<Configuration> configureModulePath, Consumer<Configuration> configureLegacyClasspath, Provider<RegularFile> assetPropertiesFile, Configuration devLaunchConfig, Provider<VersionCapabilities> versionCapabilities, TaskProvider<Task> createLaunchScriptsTask) {
        IdeIntegration ideIntegration = IdeIntegration.of(project, branding);
        ConfigurationContainer configurations = project.getConfigurations();
        JavaPluginExtension javaExtension = ExtensionUtils.getExtension((ExtensionAware)project, "java", JavaPluginExtension.class);
        TaskContainer tasks = project.getTasks();
        Provider runtimeClasspathConfig = run.getSourceSet().map(SourceSet::getRuntimeClasspathConfigurationName).map(arg_0 -> ((ConfigurationContainer)configurations).getByName(arg_0));
        project.afterEvaluate(ignored -> ((Configuration)runtimeClasspathConfig.get()).extendsFrom(new Configuration[]{devLaunchConfig}));
        Provider<String> type = RunUtils.getRequiredType(project, run);
        Configuration modulePathConfiguration = (Configuration)project.getConfigurations().create(InternalModelHelper.nameOfRun(run, "", "modulesOnly"), spec -> {
            spec.setDescription("Libraries that should be placed on the JVMs boot module path for run " + run.getName() + ".");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith((Configuration)runtimeClasspathConfig.get());
            configureModulePath.accept((Configuration)spec);
        });
        Configuration legacyClasspathConfiguration = (Configuration)configurations.create(InternalModelHelper.nameOfRun(run, "", "legacyClasspath"), spec -> {
            spec.setDescription("Contains all dependencies of the " + run.getName() + " run that should not be considered boot classpath modules.");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith((Configuration)runtimeClasspathConfig.get());
            spec.attributes(attributes -> {
                attributes.attributeProvider(MinecraftDistribution.ATTRIBUTE, type.map(t -> {
                    String name = t.equals("client") || t.equals("data") || t.equals("clientData") ? "client" : "server";
                    return (MinecraftDistribution)project.getObjects().named(MinecraftDistribution.class, name);
                }));
                ModDevPlugin.setNamedAttribute(project, attributes, Usage.USAGE_ATTRIBUTE, "java-runtime");
            });
            configureLegacyClasspath.accept((Configuration)spec);
            spec.extendsFrom(new Configuration[]{run.getAdditionalRuntimeClasspathConfiguration()});
        });
        TaskProvider writeLcpTask = tasks.register(InternalModelHelper.nameOfRun(run, "write", "legacyClasspath"), WriteLegacyClasspath.class, writeLcp -> {
            writeLcp.setGroup(branding.internalTaskGroup());
            writeLcp.setDescription("Writes the legacyClasspath file for the " + run.getName() + " Minecraft run, containing all dependencies that shouldn't be considered boot modules.");
            writeLcp.getLegacyClasspathFile().set(argFileDir.map(dir -> dir.file(InternalModelHelper.nameOfRun(run, "", "legacyClasspath") + ".txt")));
            writeLcp.addEntries(legacyClasspathConfiguration);
        });
        TaskProvider prepareRunTask = tasks.register(InternalModelHelper.nameOfRun(run, "prepare", "run"), PrepareRun.class, task -> {
            task.setGroup(branding.internalTaskGroup());
            task.setDescription("Prepares all files needed to launch the " + run.getName() + " Minecraft run.");
            task.getGameDirectory().set((Provider)run.getGameDirectory());
            task.getVmArgsFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.VMARGS));
            task.getProgramArgsFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.PROGRAMARGS));
            task.getLog4jConfigFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.LOG4J_CONFIG));
            task.getRunType().set(run.getType());
            task.getRunTypeTemplatesSource().from(new Object[]{runTemplatesFile});
            task.getModules().from(new Object[]{modulePathConfiguration});
            task.getLegacyClasspathFile().set((Provider)((WriteLegacyClasspath)((Object)((Object)writeLcpTask.get()))).getLegacyClasspathFile());
            task.getAssetProperties().set(assetPropertiesFile);
            task.getSystemProperties().set(run.getSystemProperties().map(props -> {
                props = new HashMap(props);
                return props;
            }));
            task.getMainClass().set(run.getMainClass());
            task.getProgramArguments().set(run.getProgramArguments());
            task.getJvmArguments().set(run.getJvmArguments());
            task.getGameLogLevel().set(run.getLogLevel());
            task.getVersionCapabilities().set(versionCapabilities);
        });
        ideIntegration.runTaskOnProjectSync(prepareRunTask);
        TaskProvider launchScriptTask = tasks.register(InternalModelHelper.nameOfRun(run, "create", "launchScript"), CreateLaunchScriptTask.class, task -> {
            task.setGroup(branding.internalTaskGroup());
            task.setDescription("Creates a bash/shell-script to launch the " + run.getName() + " Minecraft run from outside Gradle or your IDE.");
            task.getWorkingDirectory().set(run.getGameDirectory().map(d -> d.getAsFile().getAbsolutePath()));
            task.getRuntimeClasspath().setFrom(new Object[]{runtimeClasspathConfig});
            task.getLaunchScript().set(RunUtils.getLaunchScript(argFileDir, run));
            task.getClasspathArgsFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.CLASSPATH));
            task.getVmArgsFile().set(((PrepareRun)((Object)((Object)prepareRunTask.get()))).getVmArgsFile().map(d -> d.getAsFile().getAbsolutePath()));
            task.getProgramArgsFile().set(((PrepareRun)((Object)((Object)prepareRunTask.get()))).getProgramArgsFile().map(d -> d.getAsFile().getAbsolutePath()));
            task.getEnvironment().set(run.getEnvironment());
            task.getModFolders().set((Object)RunUtils.getGradleModFoldersProvider(project, run.getLoadedMods(), null));
        });
        createLaunchScriptsTask.configure(task -> task.dependsOn(new Object[]{launchScriptTask}));
        tasks.register(InternalModelHelper.nameOfRun(run, "run", ""), RunGameTask.class, task -> {
            task.setGroup(branding.publicTaskGroup());
            task.setDescription("Runs the " + run.getName() + " Minecraft run configuration.");
            JavaToolchainService toolchainService = ExtensionUtils.findExtension((ExtensionAware)project, "javaToolchains", JavaToolchainService.class);
            task.getJavaLauncher().set(toolchainService.launcherFor(spec -> spec.getLanguageVersion().set((Provider)javaExtension.getToolchain().getLanguageVersion())));
            task.getClasspathProvider().from(new Object[]{run.getSourceSet().map(SourceSet::getRuntimeClasspath)});
            task.getGameDirectory().set((Provider)run.getGameDirectory());
            task.getEnvironmentProperty().set(run.getEnvironment());
            task.jvmArgs(new Object[]{RunUtils.getArgFileParameter((RegularFile)((PrepareRun)((Object)((Object)prepareRunTask.get()))).getVmArgsFile().get()).replace("\\", "\\\\")});
            task.getMainClass().set((Object)RunUtils.DEV_LAUNCH_MAIN_CLASS);
            task.args(new Object[]{RunUtils.getArgFileParameter((RegularFile)((PrepareRun)((Object)((Object)prepareRunTask.get()))).getProgramArgsFile().get()).replace("\\", "\\\\")});
            task.dependsOn(new Object[]{prepareRunTask});
            task.dependsOn(new Object[]{run.getTasksBefore()});
            task.getJvmArgumentProviders().add(RunUtils.getGradleModFoldersProvider(project, run.getLoadedMods(), null));
        });
        return prepareRunTask;
    }

    public void setupTestTask() {
        if (this.configureTesting == null) {
            throw new IllegalStateException("Unit testing was already enabled once!");
        }
        this.configureTesting.run();
        this.configureTesting = null;
    }

    static void setupTestTask(Project project, Branding branding, Object runTemplatesSourceFile, TaskProvider<Test> testTask, SetProperty<ModModel> loadedMods, Property<ModModel> testedMod, Provider<Directory> argFileDir, Consumer<Configuration> configureModulePath, Consumer<Configuration> configureLegacyClasspath, Provider<RegularFile> assetPropertiesFile) {
        File gameDirectory = new File(project.getProjectDir(), JUNIT_GAME_DIR);
        IdeIntegration ideIntegration = IdeIntegration.of(project, branding);
        TaskContainer tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration testRuntimeClasspath = configurations.getByName("testRuntimeClasspath");
        Configuration neoForgeModDevModules = (Configuration)project.getConfigurations().create("neoForgeTestModules", spec -> {
            spec.setDescription("Libraries that should be placed on the JVMs boot module path for unit tests.");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith(testRuntimeClasspath);
            configureModulePath.accept((Configuration)spec);
        });
        Configuration legacyClasspathConfiguration = (Configuration)configurations.create("neoForgeTestLibraries", spec -> {
            spec.setDescription("Contains the legacy classpath of unit tests.");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith(testRuntimeClasspath);
            spec.attributes(attributes -> {
                ModDevPlugin.setNamedAttribute(project, attributes, MinecraftDistribution.ATTRIBUTE, "client");
                ModDevPlugin.setNamedAttribute(project, attributes, Usage.USAGE_ATTRIBUTE, "java-runtime");
            });
            configureLegacyClasspath.accept((Configuration)spec);
        });
        Provider runArgsDir = argFileDir.map(dir -> dir.dir("junit"));
        TaskProvider writeLcpTask = tasks.register("writeNeoForgeTestClasspath", WriteLegacyClasspath.class, writeLcp -> {
            writeLcp.setGroup(branding.internalTaskGroup());
            writeLcp.setDescription("Writes the legacyClasspath file for the test run, containing all dependencies that shouldn't be considered boot modules.");
            writeLcp.getLegacyClasspathFile().convention(runArgsDir.map(dir -> dir.file("legacyClasspath.txt")));
            writeLcp.addEntries(legacyClasspathConfiguration);
        });
        Provider vmArgsFile = runArgsDir.map(dir -> dir.file("vmArgs.txt"));
        Provider programArgsFile = runArgsDir.map(dir -> dir.file("programArgs.txt"));
        Provider log4j2ConfigFile = runArgsDir.map(dir -> dir.file("log4j2.xml"));
        TaskProvider prepareTask = tasks.register("prepareNeoForgeTestFiles", PrepareTest.class, task -> {
            task.setGroup(branding.internalTaskGroup());
            task.setDescription("Prepares all files needed to run the JUnit test task.");
            task.getGameDirectory().set(gameDirectory);
            task.getVmArgsFile().set(vmArgsFile);
            task.getProgramArgsFile().set(programArgsFile);
            task.getLog4jConfigFile().set(log4j2ConfigFile);
            task.getRunTypeTemplatesSource().from(new Object[]{runTemplatesSourceFile});
            task.getModules().from(new Object[]{neoForgeModDevModules});
            task.getLegacyClasspathFile().set((Provider)((WriteLegacyClasspath)((Object)((Object)writeLcpTask.get()))).getLegacyClasspathFile());
            task.getAssetProperties().set(assetPropertiesFile);
            task.getGameLogLevel().set((Object)Level.INFO);
        });
        ideIntegration.runTaskOnProjectSync(prepareTask);
        testTask.configure(task -> {
            task.dependsOn(new Object[]{prepareTask});
            task.systemProperty("fml.junit.argsfile", (Object)((RegularFile)programArgsFile.get()).getAsFile().getAbsolutePath());
            task.jvmArgs(new Object[]{RunUtils.getArgFileParameter((RegularFile)vmArgsFile.get())});
            ModFoldersProvider modFoldersProvider = RunUtils.getGradleModFoldersProvider(project, (Provider<Set<ModModel>>)loadedMods, (Provider<ModModel>)testedMod);
            task.getJvmArgumentProviders().add(modFoldersProvider);
        });
        project.afterEvaluate(p -> testTask.configure(task -> task.setWorkingDir(gameDirectory)));
        ideIntegration.configureTesting(loadedMods, testedMod, (Provider<Directory>)runArgsDir, gameDirectory, (Provider<RegularFile>)programArgsFile, (Provider<RegularFile>)vmArgsFile);
    }

    private static void setupJarJar(Project project) {
        SourceSetContainer sourceSets = ExtensionUtils.getExtension((ExtensionAware)project, "sourceSets", SourceSetContainer.class);
        sourceSets.all(sourceSet -> {
            TaskProvider<JarJar> jarJarTask = JarJar.registerWithConfiguration(project, sourceSet.getTaskName(null, "jarJar"));
            jarJarTask.configure(task -> task.setGroup(Branding.MDG.internalTaskGroup()));
            String jarTaskName = sourceSet.getJarTaskName();
            project.getTasks().withType(AbstractArchiveTask.class).named(name -> name.equals(jarTaskName)).configureEach(task -> task.from(new Object[]{jarJarTask}));
        });
    }

    private static DataFileCollectionWrapper dataFileConfiguration(final Project project, String name, String description, final String category) {
        Configuration configuration = (Configuration)project.getConfigurations().create(name, spec -> {
            spec.setDescription(description);
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.attributes(attributes -> ModDevPlugin.setNamedAttribute(project, attributes, Category.CATEGORY_ATTRIBUTE, category));
        });
        final Configuration elementsConfiguration = (Configuration)project.getConfigurations().create(name + "Elements", spec -> {
            spec.setDescription("Published data files for " + name);
            spec.setCanBeConsumed(true);
            spec.setCanBeResolved(false);
            spec.attributes(attributes -> ModDevPlugin.setNamedAttribute(project, attributes, Category.CATEGORY_ATTRIBUTE, category));
        });
        AdhocComponentWithVariants java = (AdhocComponentWithVariants)project.getComponents().getByName("java");
        java.addVariantsFromConfiguration(elementsConfiguration, variant -> {
            if (variant.getConfigurationVariant().getArtifacts().isEmpty()) {
                variant.skip();
            }
        });
        final DependencyFactory depFactory = project.getDependencyFactory();
        Consumer<Object> publishCallback = new Consumer<Object>(){
            ConfigurablePublishArtifact firstArtifact;
            int artifactCount;

            @Override
            public void accept(Object artifactNotation) {
                elementsConfiguration.getDependencies().add((Object)depFactory.create((FileCollection)project.files(new Object[]{artifactNotation})));
                project.getArtifacts().add(elementsConfiguration.getName(), artifactNotation, artifact -> {
                    if (this.firstArtifact == null) {
                        this.firstArtifact = artifact;
                        artifact.setClassifier(category);
                        this.artifactCount = 1;
                    } else {
                        if (this.artifactCount == 1) {
                            this.firstArtifact.setClassifier(category + this.artifactCount);
                        }
                        artifact.setClassifier(category + ++this.artifactCount);
                    }
                });
            }
        };
        DataFileCollection extension = (DataFileCollection)project.getObjects().newInstance(DataFileCollection.class, new Object[]{publishCallback});
        configuration.getDependencies().add((Object)depFactory.create((FileCollection)extension.getFiles()));
        return new DataFileCollectionWrapper(extension, configuration);
    }

    private <T extends Named> void setNamedAttribute(AttributeContainer attributes, Attribute<T> attribute, String value) {
        attributes.attribute(attribute, (Object)this.objectFactory.named(attribute.getType(), value));
    }

    private static <T extends Named> void setNamedAttribute(Project project, AttributeContainer attributes, Attribute<T> attribute, String value) {
        attributes.attribute(attribute, (Object)project.getObjects().named(attribute.getType(), value));
    }

    record DataFileCollectionWrapper(DataFileCollection extension, Configuration configuration) {
    }
}

