/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.Map;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.EclipseIntegration;
import net.neoforged.moddevgradle.internal.IntelliJIntegration;
import net.neoforged.moddevgradle.internal.NoIdeIntegration;
import net.neoforged.moddevgradle.internal.PrepareRun;
import net.neoforged.moddevgradle.internal.VsCodeIntegration;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.IdeDetection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class IdeIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(IdeIntegration.class);
    protected final TaskProvider<Task> ideSyncTask;
    protected final Project project;

    public IdeIntegration(Project project, Branding branding) {
        this.project = project;
        this.ideSyncTask = project.getTasks().register("neoForgeIdeSync", task -> {
            task.setGroup(branding.internalTaskGroup());
            task.setDescription("A utility task that is used to create necessary files when the Gradle project is synchronized with the IDE project.");
        });
    }

    public static IdeIntegration of(Project project, Branding branding) {
        IdeIntegration ideIntegration = ExtensionUtils.findExtension((ExtensionAware)project, "mdgInternalIdeIntegration", IdeIntegration.class);
        if (ideIntegration == null) {
            ideIntegration = IdeIntegration.createForProject(project, branding);
            project.getExtensions().add(IdeIntegration.class, "mdgInternalIdeIntegration", (Object)ideIntegration);
        }
        return ideIntegration;
    }

    private static IdeIntegration createForProject(Project project, Branding branding) {
        if (IdeDetection.isVsCode()) {
            LOG.debug("Activating VSCode integration for project {}.", (Object)project.getPath());
            return new VsCodeIntegration(project, branding);
        }
        if (IdeDetection.isEclipse()) {
            LOG.debug("Activating Eclipse integration for project {}.", (Object)project.getPath());
            return new EclipseIntegration(project, branding);
        }
        if (IdeDetection.isIntelliJSync()) {
            LOG.debug("Activating IntelliJ integration for project {}.", (Object)project.getPath());
            return new IntelliJIntegration(project, branding);
        }
        return new NoIdeIntegration(project, branding);
    }

    void attachSources(Map<Provider<RegularFile>, Provider<RegularFile>> jarToSourceJarMapping) {
    }

    boolean shouldUseCombinedSourcesAndClassesArtifact() {
        return false;
    }

    public final void runTaskOnProjectSync(Object task) {
        this.ideSyncTask.configure(ideSyncTask -> ideSyncTask.dependsOn(new Object[]{task}));
    }

    void configureRuns(Map<RunModel, TaskProvider<PrepareRun>> prepareRunTasks, Iterable<RunModel> runs) {
    }

    void configureTesting(SetProperty<ModModel> loadedMods, Property<ModModel> testedMod, Provider<Directory> runArgsDir, File gameDirectory, Provider<RegularFile> programArgsFile, Provider<RegularFile> vmArgsFile) {
    }

    protected boolean shouldGenerateConfigFor(RunModel run) {
        String ideName = (String)run.getIdeName().get();
        return !ideName.isBlank();
    }
}

