/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.neoforged.moddev.shadow.net.neoforged.elc.configs.GradleLaunchConfig;
import net.neoforged.moddev.shadow.net.neoforged.elc.configs.JavaApplicationLaunchConfig;
import net.neoforged.moddev.shadow.net.neoforged.elc.configs.LaunchConfig;
import net.neoforged.moddev.shadow.net.neoforged.elc.configs.LaunchGroup;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.IdeIntegration;
import net.neoforged.moddevgradle.internal.ModFolder;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.PrepareRun;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class EclipseIntegration
extends IdeIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseIntegration.class);
    protected final EclipseModel eclipseModel;

    protected EclipseIntegration(Project project, Branding branding) {
        super(project, branding);
        this.eclipseModel = EclipseIntegration.getOrCreateEclipseModel(project);
        LOG.debug("Configuring Eclipse model for Eclipse project '{}'.", (Object)this.eclipseModel.getProject().getName());
        this.eclipseModel.synchronizationTasks(new Object[]{this.ideSyncTask});
    }

    @Override
    public void attachSources(Map<Provider<RegularFile>, Provider<RegularFile>> jarToSourceJarMapping) {
        XmlFileContentMerger fileClasspath = this.eclipseModel.getClasspath().getFile();
        fileClasspath.whenMerged(classpath -> {
            for (Map.Entry mapping : jarToSourceJarMapping.entrySet()) {
                File classesPath = ((RegularFile)((Provider)mapping.getKey()).get()).getAsFile();
                File sourcesPath = ((RegularFile)((Provider)mapping.getValue()).get()).getAsFile();
                for (ClasspathEntry entry : classpath.getEntries()) {
                    Library library;
                    if (!(entry instanceof Library) || !classesPath.equals(new File((library = (Library)entry).getPath()))) continue;
                    library.setSourcePath(classpath.fileReference((Object)sourcesPath));
                }
            }
        });
    }

    @Override
    public void configureRuns(Map<RunModel, TaskProvider<PrepareRun>> prepareRunTasks, Iterable<RunModel> runs) {
        this.project.afterEvaluate(ignored -> {
            for (RunModel run : runs) {
                PrepareRun prepareTask = (PrepareRun)((Object)((Object)((TaskProvider)prepareRunTasks.get(run)).get()));
                this.addEclipseLaunchConfiguration(this.project, run, prepareTask);
            }
        });
    }

    @Override
    public void configureTesting(SetProperty<ModModel> loadedMods, Property<ModModel> testedMod, Provider<Directory> runArgsDir, File gameDirectory, Provider<RegularFile> programArgsFile, Provider<RegularFile> vmArgsFile) {
    }

    private static EclipseModel getOrCreateEclipseModel(Project project) {
        EclipseModel eclipseModel = ExtensionUtils.findExtension((ExtensionAware)project, "eclipse", EclipseModel.class);
        if (eclipseModel == null) {
            project.getPlugins().apply(EclipsePlugin.class);
            eclipseModel = ExtensionUtils.findExtension((ExtensionAware)project, "eclipse", EclipseModel.class);
            if (eclipseModel == null) {
                throw new GradleException("Even after applying the Eclipse plugin, no 'eclipse' extension was present!");
            }
        }
        return eclipseModel;
    }

    private void addEclipseLaunchConfiguration(Project project, RunModel run, PrepareRun prepareTask) {
        if (!prepareTask.getEnabled()) {
            LOG.info("Not creating Eclipse run {} since its prepare task {} is disabled", (Object)run, (Object)prepareTask);
            return;
        }
        if (!this.shouldGenerateConfigFor(run)) {
            LOG.info("Not creating Eclipse run {} since it's explicitly disabled", (Object)run);
            return;
        }
        String runIdeName = (String)run.getIdeName().get();
        Object launchConfigName = runIdeName;
        String eclipseProjectName = Objects.requireNonNullElse(this.eclipseModel.getProject().getName(), project.getName());
        if (!run.getTasksBefore().isEmpty()) {
            launchConfigName = "Run " + runIdeName;
            GradleLaunchConfig prepareRunConfig = GradleLaunchConfig.builder(eclipseProjectName).tasks((String[])run.getTasksBefore().stream().map(task -> ((Task)task.get()).getPath()).toArray(String[]::new)).build();
            String prepareRunLaunchName = "Prepare " + runIdeName;
            EclipseIntegration.writeEclipseLaunchConfig(project, prepareRunLaunchName, prepareRunConfig);
            LaunchGroup withGradleTasksConfig = LaunchGroup.builder().entry(LaunchGroup.entry(prepareRunLaunchName).enabled(true).adoptIfRunning(false).mode(LaunchGroup.Mode.RUN).action(LaunchGroup.Action.delay(2))).entry(LaunchGroup.entry((String)launchConfigName).enabled(true).adoptIfRunning(false).mode(LaunchGroup.Mode.INHERIT).action(LaunchGroup.Action.none())).build();
            EclipseIntegration.writeEclipseLaunchConfig(project, runIdeName, withGradleTasksConfig);
        }
        ModFoldersProvider modFoldersProvider = EclipseIntegration.getModFoldersProvider(project, run.getLoadedMods(), null);
        JavaApplicationLaunchConfig config = JavaApplicationLaunchConfig.builder(eclipseProjectName).vmArgs(RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getVmArgsFile().get())), RunUtils.escapeJvmArg(modFoldersProvider.getArgument())).args(RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getProgramArgsFile().get()))).envVar(RunUtils.replaceModClassesEnv(run, modFoldersProvider)).workingDirectory(((Directory)run.getGameDirectory().get()).getAsFile().getAbsolutePath()).build(RunUtils.DEV_LAUNCH_MAIN_CLASS);
        EclipseIntegration.writeEclipseLaunchConfig(project, (String)launchConfigName, config);
    }

    protected static ModFoldersProvider getModFoldersProvider(Project project, Provider<Set<ModModel>> modsProvider, @Nullable Provider<ModModel> testedMod) {
        Provider<Map<String, ModFolder>> folders = RunUtils.buildModFolders(project, modsProvider, testedMod, (sourceSet, output) -> output.from(new Object[]{RunUtils.findSourceSetProject(project, sourceSet).getProjectDir().toPath().resolve("bin").resolve(sourceSet.getName())}));
        ModFoldersProvider modFoldersProvider = (ModFoldersProvider)project.getObjects().newInstance(ModFoldersProvider.class, new Object[0]);
        modFoldersProvider.getModFolders().set(folders);
        return modFoldersProvider;
    }

    private static void writeEclipseLaunchConfig(Project project, String name, LaunchConfig config) {
        File file = project.file((Object)(".eclipse/configurations/" + name + ".launch"));
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, false);){
            config.write(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write launch file: " + file, e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to write launch file: " + file, e);
        }
    }
}

