/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import java.io.File;
import javax.inject.Inject;
import net.neoforged.moddevgradle.dsl.DataFileCollection;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.Parchment;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.dsl.UnitTest;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class NeoForgeExtension {
    public static final String NAME = "neoForge";
    private final Project project;
    private final NamedDomainObjectContainer<ModModel> mods;
    private final NamedDomainObjectContainer<RunModel> runs;
    private final Parchment parchment;
    private final UnitTest unitTest;
    private final DataFileCollection accessTransformers;
    private final DataFileCollection interfaceInjectionData;

    @Inject
    public NeoForgeExtension(Project project, DataFileCollection accessTransformers, DataFileCollection interfaceInjectionData) {
        this.project = project;
        this.mods = project.container(ModModel.class);
        this.runs = project.container(RunModel.class, name -> (RunModel)project.getObjects().newInstance(RunModel.class, new Object[]{name, project, this.mods}));
        this.parchment = (Parchment)project.getObjects().newInstance(Parchment.class, new Object[0]);
        this.unitTest = (UnitTest)project.getObjects().newInstance(UnitTest.class, new Object[0]);
        this.getNeoForgeArtifact().convention(this.getVersion().map(version -> "net.neoforged:neoforge:" + version));
        this.getNeoFormArtifact().convention(this.getNeoFormVersion().map(version -> "net.neoforged:neoform:" + version));
        this.accessTransformers = accessTransformers;
        this.interfaceInjectionData = interfaceInjectionData;
        this.getValidateAccessTransformers().convention((Object)false);
        this.unitTest.getLoadedMods().convention(this.getMods());
    }

    public void addModdingDependenciesTo(SourceSet sourceSet) {
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(this.project);
        if (!sourceSets.contains((Object)sourceSet)) {
            throw new GradleException("Cannot add to the source set in another project.");
        }
        configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{configurations.getByName("neoForgeRuntimeDependencies")});
        configurations.getByName(sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{configurations.getByName("neoForgeCompileDependencies")});
    }

    public abstract Property<String> getVersion();

    public abstract Property<String> getNeoFormVersion();

    public abstract Property<String> getNeoForgeArtifact();

    public abstract Property<String> getNeoFormArtifact();

    public void accessTransformers(Action<DataFileCollection> action) {
        action.execute((Object)this.accessTransformers);
    }

    public DataFileCollection getAccessTransformers() {
        return this.accessTransformers;
    }

    public void setAccessTransformers(Object ... paths) {
        this.getAccessTransformers().getFiles().setFrom(paths);
    }

    public void interfaceInjectionData(Action<DataFileCollection> action) {
        action.execute((Object)this.interfaceInjectionData);
    }

    public DataFileCollection getInterfaceInjectionData() {
        return this.interfaceInjectionData;
    }

    public void setInterfaceInjectionData(Object ... paths) {
        this.getInterfaceInjectionData().getFiles().setFrom(paths);
    }

    public abstract Property<Boolean> getValidateAccessTransformers();

    public NamedDomainObjectContainer<ModModel> getMods() {
        return this.mods;
    }

    public void mods(Action<NamedDomainObjectContainer<ModModel>> action) {
        action.execute(this.mods);
    }

    public NamedDomainObjectContainer<RunModel> getRuns() {
        return this.runs;
    }

    public void runs(Action<NamedDomainObjectContainer<RunModel>> action) {
        action.execute(this.runs);
    }

    public Parchment getParchment() {
        return this.parchment;
    }

    public void parchment(Action<Parchment> action) {
        action.execute((Object)this.parchment);
    }

    public UnitTest getUnitTest() {
        return this.unitTest;
    }

    public void unitTest(Action<UnitTest> action) {
        action.execute((Object)this.unitTest);
    }

    public abstract ListProperty<TaskProvider<?>> getIdeSyncTasks();

    public void ideSyncTask(TaskProvider<?> task) {
        this.getIdeSyncTasks().add(task);
    }

    public void ideSyncTask(Task task) {
        this.getIdeSyncTasks().add((Object)task.getProject().getTasks().named(task.getName()));
    }

    public abstract MapProperty<String, File> getAdditionalMinecraftArtifacts();
}

