/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.io.File;
import java.util.Optional;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdeDetection {
    private static final Logger LOG = LoggerFactory.getLogger(IdeDetection.class);

    private IdeDetection() {
    }

    public static boolean isIntelliJ() {
        if (Boolean.getBoolean("idea.active")) {
            LOG.debug("idea.active system property is set. Running under IntelliJ.");
            return true;
        }
        return false;
    }

    public static boolean isIntelliJSync() {
        if (Boolean.getBoolean("idea.sync.active")) {
            LOG.debug("idea.sync.active system property is set. Running IntelliJ Gradle import.");
            return true;
        }
        return false;
    }

    public static boolean isEclipse() {
        if (System.getProperty("eclipse.application") != null) {
            LOG.debug("eclipse.application system property is set. Running from Eclipse (or VSCode).");
            return true;
        }
        LOG.debug("eclipse.application system property is not set. Not running under Eclipse (or VSCode).");
        return false;
    }

    public static boolean isVsCode() {
        long vsCodePid;
        String vsCodePidString = System.getenv("VSCODE_PID");
        if (vsCodePidString == null) {
            LOG.debug("VSCODE_PID is not set. Not running under VSCode");
            return false;
        }
        try {
            vsCodePid = Long.parseUnsignedLong(vsCodePidString);
        }
        catch (NumberFormatException e) {
            LOG.debug("VSCODE_PID does not contain a numeric PID: '{}'", (Object)vsCodePidString);
            return false;
        }
        ProcessHandle ourProcess = ProcessHandle.current();
        Optional<ProcessHandle> maybeParent = ourProcess.parent();
        while (maybeParent.isPresent()) {
            ProcessHandle parent = maybeParent.get();
            if (parent.pid() == vsCodePid) {
                LOG.debug("VSCODE_PID is set to {}, and we are a child process of it. Running under VSCode", (Object)vsCodePid);
                return true;
            }
            maybeParent = parent.parent();
        }
        LOG.debug("VSCODE_PID is set to {}, but we ({}) are not running as a child of that process.", (Object)vsCodePid, (Object)ourProcess.pid());
        return false;
    }

    @Nullable
    public static File getIntellijProjectDir(Project project) {
        Gradle root = project.getGradle().getParent();
        if (root != null) {
            while (root.getParent() != null) {
                root = root.getParent();
            }
            return IdeDetection.getIntellijProjectDir(root.getRootProject().getProjectDir());
        }
        return IdeDetection.getIntellijProjectDir(project.getRootDir());
    }

    @Nullable
    private static File getIntellijProjectDir(File gradleProjectDir) {
        File ideaDir = new File(gradleProjectDir, ".idea");
        return ideaDir.exists() ? ideaDir : null;
    }
}

