/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.util.List;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DependencyUtils {
    private DependencyUtils() {
    }

    public static String guessMavenGav(ResolvedArtifactResult result) {
        Object artifactId;
        ComponentArtifactIdentifier componentArtifactIdentifier;
        String ext = "";
        String classifier = null;
        String filename = result.getFile().getName();
        int startOfExt = filename.lastIndexOf(46);
        if (startOfExt != -1) {
            ext = filename.substring(startOfExt + 1);
            filename = filename.substring(0, startOfExt);
        }
        if ((componentArtifactIdentifier = result.getId()) instanceof ModuleComponentArtifactIdentifier) {
            String version;
            ModuleComponentArtifactIdentifier moduleId = (ModuleComponentArtifactIdentifier)componentArtifactIdentifier;
            String artifact = moduleId.getComponentIdentifier().getModule();
            String expectedBasename = artifact + "-" + (version = moduleId.getComponentIdentifier().getVersion());
            if (filename.startsWith(expectedBasename + "-")) {
                classifier = filename.substring((expectedBasename + "-").length());
            }
            artifactId = moduleId.getComponentIdentifier().getGroup() + ":" + artifact + ":" + version;
        } else {
            List capabilities = result.getVariant().getCapabilities();
            if (capabilities.size() == 1) {
                Capability capability = (Capability)capabilities.get(0);
                artifactId = capability.getGroup() + ":" + capability.getName() + ":" + capability.getVersion();
            } else {
                artifactId = result.getId().getComponentIdentifier().toString();
            }
        }
        Object gav = artifactId;
        if (classifier != null) {
            gav = (String)gav + ":" + classifier;
        }
        if (!"jar".equals(ext)) {
            gav = (String)gav + "@" + ext;
        }
        return gav;
    }
}

