/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.FileUtils;
import net.neoforged.moddevgradle.internal.utils.OperatingSystem;
import net.neoforged.moddevgradle.internal.utils.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaToolchainService;

abstract class CreateLaunchScriptTask
extends DefaultTask {
    @Input
    abstract Property<String> getWorkingDirectory();

    @InputFile
    abstract Property<String> getVmArgsFile();

    @InputFile
    abstract Property<String> getProgramArgsFile();

    @OutputFile
    abstract RegularFileProperty getClasspathArgsFile();

    @OutputFile
    abstract RegularFileProperty getLaunchScript();

    @Input
    abstract ListProperty<String> getRuntimeClasspath();

    @Input
    abstract Property<ModFoldersProvider> getModFolders();

    @Input
    abstract MapProperty<String, String> getEnvironment();

    @Input
    abstract Property<String> getJavaExecutable();

    @Inject
    protected abstract JavaToolchainService getJavaToolchainService();

    @Inject
    public CreateLaunchScriptTask() {
        JavaPluginExtension java = ExtensionUtils.getExtension((ExtensionAware)this.getProject(), "java", JavaPluginExtension.class);
        this.getJavaExecutable().convention(this.getJavaToolchainService().launcherFor(java.getToolchain()).map(javaLauncher -> javaLauncher.getExecutablePath().getAsFile().getAbsolutePath()));
    }

    @TaskAction
    public void createScripts() throws IOException {
        this.writeClasspathArguments();
        if (!this.getLaunchScript().isPresent()) {
            return;
        }
        ArrayList<String> javaCommand = new ArrayList<String>();
        javaCommand.add((String)this.getJavaExecutable().get());
        javaCommand.add("@" + ((RegularFile)this.getClasspathArgsFile().get()).getAsFile().getAbsolutePath());
        javaCommand.add("@" + (String)this.getVmArgsFile().get());
        javaCommand.add(((ModFoldersProvider)this.getModFolders().get()).getArgument());
        javaCommand.add(RunUtils.DEV_LAUNCH_MAIN_CLASS);
        javaCommand.add("@" + (String)this.getProgramArgsFile().get());
        OperatingSystem os = OperatingSystem.current();
        if (os == OperatingSystem.WINDOWS) {
            this.writeLaunchScriptForWindows(javaCommand);
        } else {
            this.writeLaunchScriptForUnix(javaCommand);
        }
    }

    private void writeClasspathArguments() throws IOException {
        if (!this.getClasspathArgsFile().isPresent()) {
            return;
        }
        String classpathFileList = String.join((CharSequence)File.pathSeparator, (Iterable)this.getRuntimeClasspath().get());
        List<String> lines = List.of("-classpath", RunUtils.escapeJvmArg(classpathFileList));
        FileUtils.writeLinesSafe(((RegularFile)this.getClasspathArgsFile().get()).getAsFile().toPath(), lines, StringUtils.getNativeCharset());
    }

    private void writeLaunchScriptForWindows(List<String> javaCommand) throws IOException {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        Collections.addAll(lines, "@echo off", "setlocal", "for /f \"tokens=2 delims=:.\" %%x in ('chcp') do set _codepage=%%x", "chcp 65001>nul");
        for (Map.Entry entry : ((Map)this.getEnvironment().get()).entrySet()) {
            lines.add((CallSite)((Object)("set " + this.escapeBatchScriptArg((String)entry.getKey()) + "=" + this.escapeBatchScriptArg((String)entry.getValue()))));
        }
        Collections.addAll(lines, "cd " + (String)this.getWorkingDirectory().get(), javaCommand.stream().map(this::escapeBatchScriptArg).collect(Collectors.joining(" ")), "if not ERRORLEVEL 0 (  echo Minecraft failed with exit code %ERRORLEVEL%  pause)", "chcp %_codepage%>nul", "endlocal");
        FileUtils.writeStringSafe(((RegularFile)this.getLaunchScript().get()).getAsFile().toPath(), String.join((CharSequence)"\r\n", lines), StandardCharsets.UTF_8);
    }

    private String escapeBatchScriptArg(String text) {
        if (((String)(text = ((String)text).replace("%", "%%"))).contains(" ")) {
            text = "\"" + (String)text + "\"";
        }
        return text;
    }

    private void writeLaunchScriptForUnix(List<String> javaCommand) throws IOException {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (Map.Entry entry : ((Map)this.getEnvironment().get()).entrySet()) {
            lines.add((CallSite)((Object)("export " + this.escapeShellArg((String)entry.getKey()) + "=" + this.escapeShellArg((String)entry.getValue()))));
        }
        Collections.addAll(lines, "(cd " + this.escapeShellArg((String)this.getWorkingDirectory().get()) + "; exec " + javaCommand.stream().map(this::escapeShellArg).collect(Collectors.joining(" ")) + ")");
        FileUtils.writeStringSafe(((RegularFile)this.getLaunchScript().get()).getAsFile().toPath(), String.join((CharSequence)"\n", lines), StandardCharsets.UTF_8);
    }

    private String escapeShellArg(String text) {
        return "'" + text.replace("'", "'\"'\"'") + "'";
    }
}

