/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.ArtifactManifestEntry;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

abstract class CreateArtifactManifestTask
extends DefaultTask {
    @Input
    abstract SetProperty<ArtifactManifestEntry> getNeoForgeModDevArtifacts();

    @OutputFile
    abstract RegularFileProperty getManifestFile();

    @Inject
    public CreateArtifactManifestTask() {
    }

    @TaskAction
    public void writeManifest() throws IOException {
        Properties artifactsManifest = new Properties();
        for (ArtifactManifestEntry artifact : (Set)this.getNeoForgeModDevArtifacts().get()) {
            artifactsManifest.setProperty(artifact.artifactId(), artifact.file().getAbsolutePath());
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(((RegularFile)this.getManifestFile().get()).getAsFile()));){
            artifactsManifest.store(out, "");
        }
    }
}

