/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.internal;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapOperation;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.InputArtifactDependencies;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.ExecOperations;

abstract class RemappingTransform
implements TransformAction<Parameters> {
    @InputArtifact
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract Provider<FileSystemLocation> getInputArtifact();

    @CompileClasspath
    @InputArtifactDependencies
    public abstract FileCollection getDependencies();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    public RemappingTransform() {
    }

    public void transform(TransformOutputs outputs) {
        File inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        if (!inputFile.exists()) {
            return;
        }
        File mappedFile = outputs.file((Object)inputFile.getName());
        try {
            ((Parameters)this.getParameters()).getRemapOperation().execute(this.getExecOperations(), inputFile, mappedFile, this.getDependencies().plus((FileCollection)((Parameters)this.getParameters()).getMinecraftDependencies()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Parameters
    extends TransformParameters {
        @Nested
        public RemapOperation getRemapOperation();

        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        public ConfigurableFileCollection getMinecraftDependencies();
    }
}

