/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.ModFolder;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.process.CommandLineArgumentProvider;

abstract class ModFoldersProvider
implements CommandLineArgumentProvider {
    @Inject
    public ModFoldersProvider() {
        Provider classesArgument = this.getModFolders().map(map -> map.entrySet().stream().mapMulti((entry, output) -> {
            for (File directory : ((ModFolder)entry.getValue()).getFolders()) {
                output.accept((String)entry.getKey() + "%%" + directory.getAbsolutePath());
            }
        }).collect(Collectors.joining(File.pathSeparator)));
        this.getClassesArgument().set(classesArgument);
    }

    @Nested
    abstract MapProperty<String, ModFolder> getModFolders();

    @Internal
    abstract Property<String> getClassesArgument();

    @Internal
    public String getArgument() {
        return "-Dfml.modFolders=%s".formatted(this.getClassesArgument().get());
    }

    public Iterable<String> asArguments() {
        return List.of(this.getArgument());
    }
}

