/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.neoforged.minecraftdependencies.MinecraftDistribution;
import net.neoforged.moddevgradle.dsl.ModDevExtension;
import net.neoforged.moddevgradle.dsl.Parchment;
import net.neoforged.moddevgradle.internal.ArtifactNamingStrategy;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.IdeIntegration;
import net.neoforged.moddevgradle.internal.ModdingDependencies;
import net.neoforged.moddevgradle.internal.WorkflowArtifact;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.VersionCapabilitiesInternal;
import net.neoforged.nfrtgradle.CreateMinecraftArtifacts;
import net.neoforged.nfrtgradle.DownloadAssets;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModDevArtifactsWorkflow(Project project, ModdingDependencies dependencies, VersionCapabilitiesInternal versionCapabilities, TaskProvider<CreateMinecraftArtifacts> createArtifacts, Provider<? extends Dependency> minecraftClassesDependency, TaskProvider<DownloadAssets> downloadAssets, Configuration runtimeDependencies, Configuration compileDependencies, Provider<Directory> modDevBuildDir, Provider<Directory> artifactsBuildDir) {
    private static final String EXTENSION_NAME = "__internal_modDevArtifactsWorkflow";

    public static ModDevArtifactsWorkflow get(Project project) {
        ModDevArtifactsWorkflow result = ExtensionUtils.findExtension((ExtensionAware)project, EXTENSION_NAME, ModDevArtifactsWorkflow.class);
        if (result == null) {
            throw new InvalidUserCodeException("Mod development has not been enabled yet for project " + String.valueOf(project));
        }
        return result;
    }

    public static ModDevArtifactsWorkflow create(Project project, Collection<SourceSet> enabledSourceSets, Branding branding, ModDevExtension extension, ModdingDependencies moddingDependencies, ArtifactNamingStrategy artifactNamingStrategy, Configuration accessTransformers, Configuration interfaceInjectionData, VersionCapabilitiesInternal versionCapabilities, boolean disableRecompilation) {
        if (project.getExtensions().findByName(EXTENSION_NAME) != null) {
            throw new InvalidUserCodeException("You cannot enable modding in the same project twice.");
        }
        if (disableRecompilation) {
            project.getLogger().lifecycle("Creating Minecraft artifacts without recompilation.");
        }
        IdeIntegration ideIntegration = IdeIntegration.of(project, branding);
        Provider modDevBuildDir = project.getLayout().getBuildDirectory().dir("moddev");
        Provider artifactsBuildDir = project.getLayout().getBuildDirectory().dir("moddev/artifacts");
        List<Configuration> createManifestConfigurations = ModDevArtifactsWorkflow.configureArtifactManifestConfigurations(project, moddingDependencies.neoForgeDependency(), moddingDependencies.neoFormDependency());
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainer tasks = project.getTasks();
        JavaPluginExtension javaExtension = ExtensionUtils.getExtension((ExtensionAware)project, "java", JavaPluginExtension.class);
        JavaToolchainService javaToolchainService = ExtensionUtils.getExtension((ExtensionAware)project, "javaToolchains", JavaToolchainService.class);
        JavaToolchainSpec toolchainSpec = javaExtension.getToolchain();
        try {
            toolchainSpec.getLanguageVersion().convention((Object)JavaLanguageVersion.of((int)versionCapabilities.javaVersion()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Parchment parchment = extension.getParchment();
        Configuration parchmentData = (Configuration)configurations.create("parchmentData", spec -> {
            spec.setDescription("Data used to add parameter names and javadoc to Minecraft sources");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.setTransitive(false);
            spec.getDependencies().addLater(parchment.getParchmentArtifact().map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
        });
        TaskProvider createArtifacts = tasks.register("createMinecraftArtifacts", CreateMinecraftArtifacts.class, task -> {
            task.setGroup(branding.internalTaskGroup());
            task.setDescription("Creates the NeoForge and Minecraft artifacts by invoking NFRT.");
            for (Configuration configuration : createManifestConfigurations) {
                task.addArtifactsToManifest(configuration);
            }
            task.getToolsJavaExecutable().set(javaToolchainService.launcherFor(spec -> spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)versionCapabilities.javaVersion()))).map(javaLauncher -> javaLauncher.getExecutablePath().getAsFile().getAbsolutePath()));
            if (versionCapabilities.javaVersion() > 21) {
                task.getJavaExecutable().set(javaToolchainService.launcherFor(spec -> spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)versionCapabilities.javaVersion()))).map(javaLauncher -> javaLauncher.getExecutablePath().getAsFile().getAbsolutePath()));
            }
            task.getAccessTransformers().from(new Object[]{accessTransformers});
            task.getValidatedAccessTransformers().from(new Object[]{extension.getValidateAccessTransformers().map(validate -> {
                if (validate.booleanValue()) {
                    return extension.getAccessTransformers().getFiles();
                }
                return project.files(new Object[0]);
            })});
            task.getInterfaceInjectionData().from(new Object[]{interfaceInjectionData});
            task.getParchmentData().from(new Object[]{parchmentData});
            task.getParchmentEnabled().set(parchment.getEnabled());
            task.getParchmentConflictResolutionPrefix().set(parchment.getConflictResolutionPrefix());
            Function<WorkflowArtifact, Provider> artifactPathStrategy = artifact -> artifactsBuildDir.map(dir -> dir.file(artifactNamingStrategy.getFilename((WorkflowArtifact)((Object)((Object)artifact)))));
            task.getIncludeNeoForgeInGameJar().set((Object)versionCapabilities.needsNeoForgeInMinecraftJar());
            task.getGameJarArtifact().set(artifactPathStrategy.apply(WorkflowArtifact.COMPILED));
            if (disableRecompilation) {
                task.getDisableRecompilation().set((Object)true);
            } else {
                task.getGameJarWithSourcesArtifact().set(artifactPathStrategy.apply(WorkflowArtifact.COMPILED_WITH_SOURCES));
                task.getGameSourcesArtifact().set(artifactPathStrategy.apply(WorkflowArtifact.SOURCES));
            }
            if (versionCapabilities.needsNeoForgeInMinecraftJar()) {
                task.getResourcesArtifact().set(artifactPathStrategy.apply(WorkflowArtifact.CLIENT_RESOURCES));
            }
            task.getNeoForgeArtifact().set((Object)moddingDependencies.neoForgeDependencyNotation());
            task.getNeoFormArtifact().set((Object)moddingDependencies.neoFormDependencyNotation());
            task.getAdditionalResults().putAll(extension.getAdditionalMinecraftArtifacts());
        });
        ideIntegration.runTaskOnProjectSync(createArtifacts);
        TaskProvider downloadAssets = tasks.register("downloadAssets", DownloadAssets.class, task -> {
            task.setGroup(branding.publicTaskGroup());
            task.setDescription("Downloads the Minecraft assets and asset index needed to run a Minecraft client or generate client-side resources.");
            for (Configuration configuration : createManifestConfigurations) {
                task.addArtifactsToManifest(configuration);
            }
            task.getAssetPropertiesFile().set(modDevBuildDir.map(dir -> dir.file("minecraft_assets.properties")));
            task.getNeoForgeArtifact().set((Object)moddingDependencies.neoForgeDependencyNotation());
            task.getNeoFormArtifact().set((Object)moddingDependencies.neoFormDependencyNotation());
        });
        Provider minecraftClassesDependency = !disableRecompilation && ideIntegration.shouldUseCombinedSourcesAndClassesArtifact() ? createArtifacts.map(task -> project.files(new Object[]{task.getGameJarWithSourcesArtifact()})).map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)) : createArtifacts.map(task -> project.files(new Object[]{task.getGameJarArtifact()})).map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0));
        Configuration runtimeDependencies = (Configuration)configurations.create("modDevRuntimeDependencies", config -> {
            config.setDescription("The runtime dependencies to develop a mod for, including Minecraft classes and modding platform classes.");
            config.setCanBeResolved(false);
            config.setCanBeConsumed(false);
            config.getDependencies().addLater(minecraftClassesDependency);
            if (versionCapabilities.needsNeoForgeInMinecraftJar()) {
                config.getDependencies().addLater(createArtifacts.map(task -> project.files(new Object[]{task.getResourcesArtifact()})).map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
            } else if (moddingDependencies.neoForgeDependency() != null) {
                config.getDependencies().add((Object)moddingDependencies.neoForgeDependency());
            }
            config.getDependencies().add((Object)moddingDependencies.gameLibrariesDependency());
        });
        Configuration compileDependencies = (Configuration)configurations.create("modDevCompileDependencies", config -> {
            config.setDescription("The compile-time dependencies to develop a mod, including Minecraft and modding platform classes.");
            config.setCanBeResolved(false);
            config.setCanBeConsumed(false);
            config.getDependencies().addLater(minecraftClassesDependency);
            config.getDependencies().add((Object)moddingDependencies.gameLibrariesDependency());
            if (!versionCapabilities.needsNeoForgeInMinecraftJar() && moddingDependencies.neoForgeDependency() != null) {
                config.getDependencies().add((Object)moddingDependencies.neoForgeDependency());
            }
        });
        if (!disableRecompilation && !ideIntegration.shouldUseCombinedSourcesAndClassesArtifact()) {
            ideIntegration.attachSources(Map.of(((CreateMinecraftArtifacts)((Object)createArtifacts.get())).getGameJarArtifact(), ((CreateMinecraftArtifacts)((Object)createArtifacts.get())).getGameSourcesArtifact()));
        }
        ModDevArtifactsWorkflow result = new ModDevArtifactsWorkflow(project, moddingDependencies, versionCapabilities, (TaskProvider<CreateMinecraftArtifacts>)createArtifacts, (Provider<? extends Dependency>)minecraftClassesDependency, (TaskProvider<DownloadAssets>)downloadAssets, runtimeDependencies, compileDependencies, (Provider<Directory>)modDevBuildDir, (Provider<Directory>)artifactsBuildDir);
        project.getExtensions().add(ModDevArtifactsWorkflow.class, EXTENSION_NAME, (Object)result);
        for (SourceSet sourceSets : enabledSourceSets) {
            result.addToSourceSet(sourceSets);
        }
        return result;
    }

    private static List<Configuration> configureArtifactManifestConfigurations(Project project, @Nullable ModuleDependency moddingPlatformDependency, @Nullable ModuleDependency recompilableMinecraftWorkflowDependency) {
        ConfigurationContainer configurations = project.getConfigurations();
        String configurationPrefix = "neoFormRuntimeDependencies";
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        Configuration neoForgeClassesAndData = (Configuration)configurations.create(configurationPrefix + "NeoForgeClasses", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (NeoForge classes)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            if (moddingPlatformDependency != null) {
                spec.getDependencies().add((Object)moddingPlatformDependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-bundle")));
            }
            if (recompilableMinecraftWorkflowDependency != null) {
                spec.getDependencies().add((Object)recompilableMinecraftWorkflowDependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform")));
            }
        });
        result.add(neoForgeClassesAndData);
        if (moddingPlatformDependency != null) {
            Configuration neoForgeSources = (Configuration)configurations.create(configurationPrefix + "NeoForgeSources", spec -> {
                spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (NeoForge sources)");
                spec.setCanBeConsumed(false);
                spec.setCanBeResolved(true);
                spec.getDependencies().add((Object)moddingPlatformDependency);
                spec.attributes(attributes -> {
                    ModDevArtifactsWorkflow.setNamedAttribute(project, attributes, Category.CATEGORY_ATTRIBUTE, "documentation");
                    ModDevArtifactsWorkflow.setNamedAttribute(project, attributes, DocsType.DOCS_TYPE_ATTRIBUTE, "sources");
                });
            });
            result.add(neoForgeSources);
        }
        Configuration compileClasspath = (Configuration)configurations.create(configurationPrefix + "CompileClasspath", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (Classpath)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            if (moddingPlatformDependency != null) {
                spec.getDependencies().add((Object)moddingPlatformDependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies")));
            }
            if (recompilableMinecraftWorkflowDependency != null) {
                spec.getDependencies().add((Object)recompilableMinecraftWorkflowDependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-dependencies")));
            }
            spec.attributes(attributes -> {
                ModDevArtifactsWorkflow.setNamedAttribute(project, attributes, Usage.USAGE_ATTRIBUTE, "java-api");
                ModDevArtifactsWorkflow.setNamedAttribute(project, attributes, MinecraftDistribution.ATTRIBUTE, "client");
            });
        });
        result.add(compileClasspath);
        Configuration runtimeClasspath = (Configuration)configurations.create(configurationPrefix + "RuntimeClasspath", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (Classpath)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            if (moddingPlatformDependency != null) {
                spec.getDependencies().add((Object)moddingPlatformDependency);
                spec.getDependencies().add((Object)moddingPlatformDependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies")));
            }
            if (recompilableMinecraftWorkflowDependency != null) {
                spec.getDependencies().add((Object)recompilableMinecraftWorkflowDependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-dependencies")));
            }
            spec.attributes(attributes -> {
                ModDevArtifactsWorkflow.setNamedAttribute(project, attributes, Usage.USAGE_ATTRIBUTE, "java-runtime");
                ModDevArtifactsWorkflow.setNamedAttribute(project, attributes, MinecraftDistribution.ATTRIBUTE, "client");
            });
        });
        result.add(runtimeClasspath);
        return result;
    }

    public void addToSourceSet(SourceSet sourceSet) {
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(this.project);
        if (!sourceSets.contains((Object)sourceSet)) {
            throw new GradleException("Cannot add to the source set in another project: " + String.valueOf(sourceSet));
        }
        configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{this.runtimeDependencies});
        configurations.getByName(sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{this.compileDependencies});
    }

    public Provider<RegularFile> requestAdditionalMinecraftArtifact(String id, String filename) {
        return this.requestAdditionalMinecraftArtifact(id, (Provider<RegularFile>)this.artifactsBuildDir.map(dir -> dir.file(filename)));
    }

    public Provider<RegularFile> requestAdditionalMinecraftArtifact(String id, Provider<RegularFile> path) {
        this.createArtifacts.configure(task -> task.getAdditionalResults().put((Object)id, path.map(RegularFile::getAsFile)));
        return this.project.getLayout().file(this.createArtifacts.flatMap(task -> task.getAdditionalResults().getting((Object)id)));
    }

    private static <T extends Named> void setNamedAttribute(Project project, AttributeContainer attributes, Attribute<T> attribute, String value) {
        attributes.attribute(attribute, (Object)project.getObjects().named(attribute.getType(), value));
    }
}

