/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import net.neoforged.moddevgradle.internal.WorkflowArtifact;
import net.neoforged.moddevgradle.internal.utils.VersionCapabilitiesInternal;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
@ApiStatus.Internal
public interface ArtifactNamingStrategy {
    public static ArtifactNamingStrategy createVanilla(String version) {
        return artifact -> "vanilla-%s%s.jar".formatted(version, artifact.defaultSuffix);
    }

    public static ArtifactNamingStrategy createVanillaPatched(String loaderVersion) {
        return artifact -> "minecraft-patched-%s%s.jar".formatted(loaderVersion, artifact.defaultSuffix);
    }

    public static ArtifactNamingStrategy createNeoForge(VersionCapabilitiesInternal versionCapabilities, String loader, String version) {
        return artifact -> {
            if (artifact != WorkflowArtifact.CLIENT_RESOURCES || versionCapabilities.modLocatorRework()) {
                return "%s-%s%s.jar".formatted(loader, version, artifact.defaultSuffix);
            }
            return "client-extra-" + version + ".jar";
        };
    }

    public String getFilename(WorkflowArtifact var1);
}

