/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.neoforged.moddevgradle.dsl.InternalModelHelper;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.Dependencies;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.event.Level;

public abstract class RunModel
implements Named,
Dependencies {
    private static final Pattern VALID_RUN_NAME = Pattern.compile("[a-zA-Z][\\w-]*");
    private final String name;
    private final Configuration configuration;
    private List<TaskProvider<?>> tasksBefore = new ArrayList();

    @Inject
    public RunModel(String name, Project project, Iterable<ModModel> defaultMods) {
        this.name = name;
        if (!VALID_RUN_NAME.matcher(name).matches()) {
            throw new GradleException("Run name '" + name + "' is invalid! It must match " + VALID_RUN_NAME.pattern());
        }
        this.getLoadedMods().convention(defaultMods);
        this.getGameDirectory().convention(project.getLayout().getProjectDirectory().dir("run"));
        this.configuration = (Configuration)project.getConfigurations().create(InternalModelHelper.nameOfRun(this, "", "additionalRuntimeClasspath"), configuration -> {
            configuration.setCanBeResolved(false);
            configuration.setCanBeConsumed(false);
        });
        this.getLogLevel().convention((Object)Level.INFO);
        this.getDevLogin().convention((Object)false);
        boolean isSubProject = project.getRootProject() != project;
        Object ideName = StringUtils.capitalize(name);
        if (isSubProject) {
            ideName = project.getName() + " - " + (String)ideName;
        }
        this.getIdeName().convention(ideName);
        this.getIdeFolderName().convention((Object)"");
        this.getSourceSet().convention((Object)((SourceSet)ExtensionUtils.getSourceSets(project).getByName("main")));
    }

    public String getName() {
        return this.name;
    }

    public abstract Property<String> getIdeName();

    public abstract Property<String> getIdeFolderName();

    public abstract DirectoryProperty getGameDirectory();

    public abstract MapProperty<String, String> getEnvironment();

    public void environment(String key, String value) {
        this.getEnvironment().put((Object)key, (Object)value);
    }

    public abstract MapProperty<String, String> getSystemProperties();

    public void systemProperty(String key, String value) {
        this.getSystemProperties().put((Object)key, (Object)value);
    }

    public abstract Property<String> getMainClass();

    public abstract ListProperty<String> getProgramArguments();

    public void programArgument(String arg) {
        this.getProgramArguments().add((Object)arg);
    }

    public abstract ListProperty<String> getJvmArguments();

    public void jvmArgument(String arg) {
        this.getJvmArguments().add((Object)arg);
    }

    public abstract SetProperty<ModModel> getLoadedMods();

    public abstract Property<String> getType();

    public void client() {
        this.getType().set((Object)"client");
    }

    public void clientData() {
        this.getType().set((Object)"clientData");
    }

    public void data() {
        this.getType().set((Object)"data");
    }

    public void server() {
        this.getType().set((Object)"server");
    }

    public void serverData() {
        this.getType().set((Object)"serverData");
    }

    public void disableIdeRun() {
        this.getIdeName().set((Object)"");
    }

    public List<TaskProvider<?>> getTasksBefore() {
        return this.tasksBefore;
    }

    public void setTasksBefore(List<TaskProvider<?>> taskNames) {
        this.tasksBefore = new ArrayList((Collection)Objects.requireNonNull(taskNames, "taskNames"));
    }

    public void taskBefore(TaskProvider<?> task) {
        this.tasksBefore.add(task);
    }

    public void taskBefore(Task task) {
        this.tasksBefore.add(task.getProject().getTasks().named(task.getName()));
    }

    public Configuration getAdditionalRuntimeClasspathConfiguration() {
        return this.configuration;
    }

    public abstract Property<Level> getLogLevel();

    public abstract RegularFileProperty getLoggingConfigFile();

    public abstract Property<SourceSet> getSourceSet();

    public abstract Property<Boolean> getDevLogin();

    public String toString() {
        return "Run[" + this.getName() + "]";
    }
}

