/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.json;

import java.lang.reflect.Type;
import java.util.Iterator;
import net.neoforged.moddev.shadow.com.google.gson.JsonDeserializationContext;
import net.neoforged.moddev.shadow.com.google.gson.JsonDeserializer;
import net.neoforged.moddev.shadow.com.google.gson.JsonElement;
import net.neoforged.moddev.shadow.com.google.gson.JsonParseException;
import net.neoforged.moddev.shadow.com.google.gson.JsonPrimitive;
import net.neoforged.moddev.shadow.com.google.gson.JsonSerializationContext;
import net.neoforged.moddev.shadow.com.google.gson.JsonSerializer;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.Restriction;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.VersionRange;

public class VersionRangeSerializer
implements JsonSerializer<VersionRange>,
JsonDeserializer<VersionRange> {
    @Override
    public VersionRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            try {
                return VersionRange.createFromVersionSpec(json.getAsString());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new JsonParseException("Failed to parse version spec from: " + json.getAsString(), e);
            }
        }
        throw new JsonParseException("Expected a string or primitive value");
    }

    @Override
    public JsonElement serialize(VersionRange src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.serializeRange(src));
    }

    private String serializeRange(VersionRange src) {
        if (src.getRecommendedVersion() != null) {
            return src.getRecommendedVersion().toString();
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Restriction> i = src.getRestrictions().iterator();
        while (i.hasNext()) {
            Restriction r = i.next();
            buf.append(this.serializeRestriction(r));
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private String serializeRestriction(Restriction src) {
        StringBuilder buf = new StringBuilder();
        buf.append(src.isLowerBoundInclusive() ? (char)'[' : '(');
        if (src.getLowerBound().equals(src.getUpperBound())) {
            buf.append(src.getLowerBound().toString());
        } else {
            if (src.getLowerBound() != null) {
                buf.append(src.getLowerBound().toString());
            }
            buf.append(',');
            if (src.getUpperBound() != null) {
                buf.append(src.getUpperBound().toString());
            }
        }
        buf.append(src.isUpperBoundInclusive() ? (char)']' : ')');
        return buf.toString();
    }
}

