/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.IdeIntegration;
import net.neoforged.moddevgradle.internal.IntelliJOutputDirectoryValueSource;
import net.neoforged.moddevgradle.internal.ModFolder;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.PrepareRun;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.FileUtils;
import net.neoforged.moddevgradle.internal.utils.IdeDetection;
import net.neoforged.moddevgradle.internal.utils.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.gradle.ext.Application;
import org.jetbrains.gradle.ext.BeforeRunTask;
import org.jetbrains.gradle.ext.IdeaExtPlugin;
import org.jetbrains.gradle.ext.JUnit;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jetbrains.gradle.ext.RunConfigurationContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IntelliJIntegration
extends IdeIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(IntelliJIntegration.class);
    private final IdeaModel rootIdeaModel;

    IntelliJIntegration(Project project, Branding branding) {
        super(project, branding);
        Project rootProject = project.getRootProject();
        rootProject.getPlugins().apply(IdeaPlugin.class);
        this.rootIdeaModel = ExtensionUtils.getExtension((ExtensionAware)rootProject, "idea", IdeaModel.class);
        if (!rootProject.getPlugins().hasPlugin(IdeaExtPlugin.class)) {
            rootProject.getPlugins().apply(IdeaExtPlugin.class);
        }
        if (IdeDetection.isIntelliJSync()) {
            project.afterEvaluate(ignored -> {
                StartParameter startParameter = project.getGradle().getStartParameter();
                ArrayList<DefaultTaskExecutionRequest> taskRequests = new ArrayList<DefaultTaskExecutionRequest>(startParameter.getTaskRequests());
                taskRequests.add(new DefaultTaskExecutionRequest(List.of(this.ideSyncTask.getName())));
                startParameter.setTaskRequests(taskRequests);
            });
        }
    }

    @Override
    public void attachSources(Map<Provider<RegularFile>, Provider<RegularFile>> jarToSourceJarMapping) {
    }

    @Override
    public void configureRuns(Map<RunModel, TaskProvider<PrepareRun>> prepareRunTasks, Iterable<RunModel> runs) {
        this.project.afterEvaluate(ignored -> {
            RunConfigurationContainer runConfigurations = this.getIntelliJRunConfigurations();
            if (runConfigurations == null) {
                LOG.debug("Failed to find IntelliJ run configuration container. Not adding run configurations.");
            } else {
                Function<Project, File> outputDirectory = IntelliJOutputDirectoryValueSource.getIntellijOutputDirectory(this.project);
                for (RunModel run : runs) {
                    PrepareRun prepareTask = (PrepareRun)((Object)((Object)((TaskProvider)prepareRunTasks.get(run)).get()));
                    if (!prepareTask.getEnabled()) {
                        LOG.info("Not creating IntelliJ run {} since its prepare task {} is disabled", (Object)run, (Object)prepareTask);
                        continue;
                    }
                    if (!this.shouldGenerateConfigFor(run)) {
                        LOG.info("Not creating IntelliJ run {} since it's explicitly disabled", (Object)run);
                        continue;
                    }
                    IntelliJIntegration.addIntelliJRunConfiguration(this.project, runConfigurations, outputDirectory, run, prepareTask);
                }
            }
        });
    }

    @Override
    public void configureTesting(Provider<Set<ModModel>> loadedMods, Provider<ModModel> testedMod, Provider<Directory> runArgsDir, File gameDirectory, Provider<RegularFile> programArgsFile, Provider<RegularFile> vmArgsFile) {
        this.project.afterEvaluate(ignored -> {
            Provider intellijVmArgsFile = runArgsDir.map(dir -> dir.file("intellijVmArgs.txt"));
            Function<Project, File> outputDirectory = IntelliJOutputDirectoryValueSource.getIntellijOutputDirectory(this.project);
            String ideSpecificVmArgs = RunUtils.escapeJvmArg(IntelliJIntegration.getModFoldersProvider(this.project, outputDirectory, loadedMods, testedMod).getArgument());
            try {
                Path vmArgsFilePath = ((RegularFile)intellijVmArgsFile.get()).getAsFile().toPath();
                Files.createDirectories(vmArgsFilePath.getParent(), new FileAttribute[0]);
                FileUtils.writeStringSafe(vmArgsFilePath, ideSpecificVmArgs, StringUtils.getNativeCharset());
            }
            catch (IOException e) {
                throw new GradleException("Failed to write VM args file for IntelliJ unit tests", (Throwable)e);
            }
            RunConfigurationContainer intelliJRunConfigurations = this.getIntelliJRunConfigurations();
            if (intelliJRunConfigurations != null) {
                intelliJRunConfigurations.defaults(JUnit.class, jUnitDefaults -> {
                    jUnitDefaults.setWorkingDirectory("$MODULE_WORKING_DIR$/build/minecraft-junit");
                    jUnitDefaults.setVmParameters(RunUtils.escapeJvmArg("-Dfml.junit.argsfile=" + IntelliJIntegration.buildRelativePath(programArgsFile, gameDirectory)) + " " + RunUtils.escapeJvmArg("@" + IntelliJIntegration.buildRelativePath(vmArgsFile, gameDirectory)) + " " + RunUtils.escapeJvmArg("@" + IntelliJIntegration.buildRelativePath((Provider<RegularFile>)intellijVmArgsFile, gameDirectory)));
                });
            }
        });
    }

    @Nullable
    private RunConfigurationContainer getIntelliJRunConfigurations() {
        if (this.rootIdeaModel == null) {
            return null;
        }
        if (this.rootIdeaModel.getProject() == null) {
            return null;
        }
        ProjectSettings projectSettings = (ProjectSettings)((ExtensionAware)this.rootIdeaModel.getProject()).getExtensions().getByType(ProjectSettings.class);
        return ExtensionUtils.findExtension((ExtensionAware)projectSettings, "runConfigurations", RunConfigurationContainer.class);
    }

    private static void addIntelliJRunConfiguration(final Project project, RunConfigurationContainer runConfigurations, @Nullable Function<Project, File> outputDirectory, final RunModel run, PrepareRun prepareTask) {
        SourceSet sourceSet;
        ExtendedApplication appRun = new ExtendedApplication((String)run.getIdeName().get(), project, IntelliJIntegration.getExtraIntelijRunProperties(run));
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        if (!sourceSets.contains((Object)(sourceSet = (SourceSet)run.getSourceSet().get()))) {
            throw new GradleException("Cannot use source set from another project for run " + run.getName());
        }
        appRun.setModuleName(IntelliJIntegration.getIntellijModuleName(project, sourceSet));
        appRun.setWorkingDirectory(((Directory)run.getGameDirectory().get()).getAsFile().getAbsolutePath());
        ModFoldersProvider modFoldersProvider = IntelliJIntegration.getModFoldersProvider(project, outputDirectory, run.getLoadedMods(), null);
        appRun.setEnvs(RunUtils.replaceModClassesEnv(run, modFoldersProvider));
        appRun.setJvmArgs(RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getVmArgsFile().get())) + " " + RunUtils.escapeJvmArg(modFoldersProvider.getArgument()));
        appRun.setMainClass("net.neoforged.devlaunch.Main");
        appRun.setProgramParameters(RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getProgramArgsFile().get())));
        if (!run.getTasksBefore().isEmpty()) {
            class GradleTasks
            extends BeforeRunTask {
                @Inject
                GradleTasks(String nameParam) {
                    this.type = "gradleTask";
                    this.name = nameParam;
                }

                public Map<String, ?> toMap() {
                    Map result = super.toMap();
                    result.put("projectPath", project.getProjectDir().getAbsolutePath().replaceAll("\\\\", "/"));
                    String tasks = run.getTasksBefore().stream().map(task -> ((Task)task.get()).getPath()).collect(Collectors.joining(" "));
                    result.put("taskName", tasks);
                    return result;
                }
            }
            appRun.getBeforeRun().add((Object)new GradleTasks("Prepare"));
        }
        runConfigurations.add((Object)appRun);
    }

    private static String buildRelativePath(Provider<RegularFile> file, File workingDirectory) {
        return workingDirectory.toPath().relativize(((RegularFile)file.get()).getAsFile().toPath()).toString().replace("\\", "/");
    }

    @Override
    public boolean shouldUseCombinedSourcesAndClassesArtifact() {
        return true;
    }

    private static ModFoldersProvider getModFoldersProvider(Project project, @Nullable Function<Project, File> outputDirectory, Provider<Set<ModModel>> modsProvider, @Nullable Provider<ModModel> testedMod) {
        Provider<Map<String, ModFolder>> folders = outputDirectory != null ? RunUtils.buildModFolders(project, modsProvider, testedMod, (sourceSet, output) -> {
            Path sourceSetDir = ((File)outputDirectory.apply(RunUtils.findSourceSetProject(project, sourceSet))).toPath().resolve(IntelliJIntegration.getIdeaOutName(sourceSet));
            output.from(new Object[]{sourceSetDir.resolve("classes"), sourceSetDir.resolve("resources")});
        }) : RunUtils.getModFoldersForGradle(project, modsProvider, testedMod);
        ModFoldersProvider modFoldersProvider = (ModFoldersProvider)project.getObjects().newInstance(ModFoldersProvider.class, new Object[0]);
        modFoldersProvider.getModFolders().set(folders);
        return modFoldersProvider;
    }

    private static String getIdeaOutName(SourceSet sourceSet) {
        return sourceSet.getName().equals("main") ? "production" : sourceSet.getName();
    }

    private static String getIntellijModuleName(Project project, SourceSet sourceSet) {
        StringBuilder moduleName = new StringBuilder();
        moduleName.append(project.getRootProject().getName().replace(" ", "_"));
        if (project != project.getRootProject()) {
            moduleName.append(project.getPath().replaceAll(":", "."));
        }
        moduleName.append(".");
        moduleName.append(sourceSet.getName());
        return moduleName.toString();
    }

    private static Map<String, Object> getExtraIntelijRunProperties(RunModel run) {
        HashMap<String, Object> extraProperties = new HashMap<String, Object>();
        if (!((String)run.getIdeFolderName().get()).isEmpty()) {
            extraProperties.put("folderName", run.getIdeFolderName().get());
        }
        return extraProperties;
    }

    private static class ExtendedApplication
    extends Application {
        private final Map<String, Object> extraProperties;

        public ExtendedApplication(String name, Project project, Map<String, Object> extraProperties) {
            super(name, project);
            this.extraProperties = extraProperties;
        }

        public Map<String, ?> toMap() {
            Map m = super.toMap();
            m.putAll(this.extraProperties);
            return m;
        }
    }
}

