/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.Nullable;

public abstract class ModdingVersionSettings {
    @Nullable
    private String version;
    @Nullable
    private String neoFormVersion;
    private Set<SourceSet> enabledSourceSets = new HashSet<SourceSet>();
    private boolean disableRecompilation = "true".equals(System.getenv("CI"));

    @Inject
    public ModdingVersionSettings(Project project) {
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        this.enabledSourceSets.add(mainSourceSet);
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getNeoFormVersion() {
        return this.neoFormVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setNeoFormVersion(String version) {
        this.neoFormVersion = version;
    }

    public Set<SourceSet> getEnabledSourceSets() {
        return this.enabledSourceSets;
    }

    public void setEnabledSourceSets(Set<SourceSet> enabledSourceSets) {
        this.enabledSourceSets = enabledSourceSets;
    }

    public boolean isDisableRecompilation() {
        return this.disableRecompilation;
    }

    public void setDisableRecompilation(boolean disableRecompilation) {
        this.disableRecompilation = disableRecompilation;
    }
}

