/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.nfrtgradle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.moddev.shadow.net.neoforged.problems.FileProblemReporter;
import net.neoforged.moddev.shadow.net.neoforged.problems.Problem;
import net.neoforged.moddevgradle.internal.utils.ProblemReportingUtil;
import net.neoforged.nfrtgradle.NeoFormRuntimeTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.problems.Problems;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.ApiStatus;

@DisableCachingByDefault(because="Implements its own caching")
@ApiStatus.NonExtendable
public abstract class CreateMinecraftArtifacts
extends NeoFormRuntimeTask {
    @Inject
    public CreateMinecraftArtifacts() {
        this.getOutputs().upToDateWhen(task -> (Boolean)((CreateMinecraftArtifacts)((Object)task)).getEnableCache().get());
        this.getEnableCache().convention((Object)true);
        this.getUseEclipseCompiler().convention((Object)false);
        this.getAnalyzeCacheMisses().convention((Object)false);
        this.getDisableRecompilation().convention((Object)false);
        this.getValidateAccessTransformers().convention((Object)false);
        this.getParchmentEnabled().convention((Object)false);
        this.getIncludeNeoForgeInGameJar().convention((Object)true);
        this.getIncludeResourcesInGameJar().convention((Object)false);
    }

    @Input
    @Optional
    public abstract Property<String> getToolsJavaExecutable();

    @InputFiles
    public abstract ConfigurableFileCollection getAccessTransformers();

    @InputFiles
    public abstract ConfigurableFileCollection getValidatedAccessTransformers();

    @InputFiles
    public abstract ConfigurableFileCollection getInterfaceInjectionData();

    @Input
    @Deprecated
    public abstract Property<Boolean> getValidateAccessTransformers();

    @Input
    public abstract Property<Boolean> getParchmentEnabled();

    @InputFiles
    public abstract ConfigurableFileCollection getParchmentData();

    @Input
    @Optional
    public abstract Property<String> getParchmentConflictResolutionPrefix();

    @OutputFiles
    public abstract MapProperty<String, File> getAdditionalResults();

    @Input
    @Optional
    public abstract Property<String> getNeoForgeArtifact();

    @Input
    @Optional
    public abstract Property<String> getNeoFormArtifact();

    @Internal
    public abstract Property<Boolean> getEnableCache();

    @Internal
    public abstract Property<Boolean> getAnalyzeCacheMisses();

    @Input
    public abstract Property<Boolean> getUseEclipseCompiler();

    @Input
    public abstract Property<Boolean> getDisableRecompilation();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getGameJarWithSourcesArtifact();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getGameJarArtifact();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getGameSourcesArtifact();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getResourcesArtifact();

    @Deprecated
    @OutputFile
    @Optional
    public RegularFileProperty getCompiledWithSourcesArtifact() {
        return this.getGameJarWithSourcesArtifact();
    }

    @Deprecated
    @OutputFile
    @Optional
    public RegularFileProperty getCompiledArtifact() {
        return this.getGameJarArtifact();
    }

    @Deprecated
    @OutputFile
    @Optional
    public RegularFileProperty getSourcesArtifact() {
        return this.getGameSourcesArtifact();
    }

    @Input
    @ApiStatus.Experimental
    public abstract Property<Boolean> getIncludeNeoForgeInGameJar();

    @Input
    @ApiStatus.Experimental
    public abstract Property<Boolean> getIncludeResourcesInGameJar();

    @Inject
    protected abstract Problems getProblems();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void createArtifacts() {
        if (((Boolean)this.getIncludeNeoForgeInGameJar().get()).booleanValue() && ((Boolean)this.getIncludeResourcesInGameJar().get()).booleanValue()) {
            throw new InvalidUserCodeException("Cannot enable both includeNeoForgeInGameJar and includeResourcesInGameJar, since Minecraft and NeoForge resources clash.");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("run");
        if (this.getToolsJavaExecutable().isPresent()) {
            args.add("--java-executable");
            args.add((String)this.getToolsJavaExecutable().get());
        }
        HashSet<File> accessTransformersAdded = new HashSet<File>();
        for (File accessTransformer : this.getValidatedAccessTransformers().getFiles()) {
            if (!accessTransformersAdded.add(accessTransformer)) continue;
            args.add("--validated-access-transformer");
            args.add(accessTransformer.getAbsolutePath());
        }
        for (File accessTransformer : this.getAccessTransformers().getFiles()) {
            if (!accessTransformersAdded.add(accessTransformer)) continue;
            if (((Boolean)this.getValidateAccessTransformers().get()).booleanValue()) {
                args.add("--validated-access-transformer");
            } else {
                args.add("--access-transformer");
            }
            args.add(accessTransformer.getAbsolutePath());
        }
        for (File interfaceInjectionFile : this.getInterfaceInjectionData().getFiles()) {
            args.add("--interface-injection-data");
            args.add(interfaceInjectionFile.getAbsolutePath());
        }
        if (((Boolean)this.getParchmentEnabled().get()).booleanValue()) {
            Set parchmentData = this.getParchmentData().getFiles();
            if (parchmentData.size() == 1) {
                args.add("--parchment-data");
                args.add(((File)parchmentData.iterator().next()).getAbsolutePath());
            } else if (parchmentData.size() > 1) {
                throw new GradleException("More than one parchment data file was specified: " + String.valueOf(parchmentData));
            }
            String conflictResolutionPrefix = (String)this.getParchmentConflictResolutionPrefix().getOrElse((Object)"");
            if (this.getParchmentConflictResolutionPrefix().isPresent() && !conflictResolutionPrefix.isBlank()) {
                args.add("--parchment-conflict-prefix");
                args.add(conflictResolutionPrefix);
            }
        }
        if (!((Boolean)this.getEnableCache().get()).booleanValue()) {
            args.add("--disable-cache");
        }
        if (((Boolean)this.getAnalyzeCacheMisses().get()).booleanValue()) {
            args.add("--analyze-cache-misses");
        }
        if (((Boolean)this.getUseEclipseCompiler().get()).booleanValue()) {
            args.add("--use-eclipse-compiler");
        }
        if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--neoforge", (String)this.getNeoForgeArtifact().get());
        }
        if (this.getNeoFormArtifact().isPresent()) {
            Collections.addAll(args, "--neoform", (String)this.getNeoFormArtifact().get());
        }
        if (!this.getNeoFormArtifact().isPresent() && !this.getNeoForgeArtifact().isPresent()) {
            throw new GradleException("You need to specify at least 'version' or 'neoFormVersion' in the 'neoForge' block of your build script.");
        }
        Collections.addAll(args, "--dist", "joined");
        ArrayList<RequestedResult> requestedResults = new ArrayList<RequestedResult>();
        ((Map)this.getAdditionalResults().get()).forEach((name, file) -> requestedResults.add(new RequestedResult((String)name, (File)file)));
        if (this.getResourcesArtifact().isPresent()) {
            requestedResults.add(new RequestedResult("clientResources", ((RegularFile)this.getResourcesArtifact().get()).getAsFile()));
        }
        boolean includeNeoForgeInGameJar = (Boolean)this.getIncludeNeoForgeInGameJar().get();
        if (((Boolean)this.getDisableRecompilation().get()).booleanValue()) {
            if (this.getGameJarArtifact().isPresent()) {
                if (this.getNeoForgeArtifact().isPresent() && includeNeoForgeInGameJar) {
                    requestedResults.add(new RequestedResult("gameJarNoRecompWithNeoForge", ((RegularFile)this.getGameJarArtifact().get()).getAsFile()));
                } else {
                    requestedResults.add(new RequestedResult("gameJarNoRecomp", ((RegularFile)this.getGameJarArtifact().get()).getAsFile()));
                }
            }
            if (this.getGameSourcesArtifact().isPresent()) {
                throw new IllegalArgumentException("Cannot request game sources if recompilation is disabled.");
            }
            if (this.getGameJarWithSourcesArtifact().isPresent()) {
                throw new IllegalArgumentException("Cannot request game jar with sources if recompilation is disabled.");
            }
        } else if (this.getNeoForgeArtifact().isPresent() && includeNeoForgeInGameJar) {
            if (this.getGameJarArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("gameJarWithNeoForge", ((RegularFile)this.getGameJarArtifact().get()).getAsFile()));
            }
            if (this.getGameSourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("gameSourcesWithNeoForge", ((RegularFile)this.getGameSourcesArtifact().get()).getAsFile()));
            }
            if (this.getGameJarWithSourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("gameJarWithSourcesAndNeoForge", ((RegularFile)this.getGameJarWithSourcesArtifact().get()).getAsFile()));
            }
        } else {
            if (this.getGameJarArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("gameJar", ((RegularFile)this.getGameJarArtifact().get()).getAsFile()));
            }
            if (this.getGameSourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("gameSources", ((RegularFile)this.getGameSourcesArtifact().get()).getAsFile()));
            }
            if (this.getGameJarWithSourcesArtifact().isPresent()) {
                requestedResults.add(new RequestedResult("gameJarWithSources", ((RegularFile)this.getGameJarWithSourcesArtifact().get()).getAsFile()));
            }
        }
        for (RequestedResult requestedResult : requestedResults) {
            args.add("--write-result");
            args.add(requestedResult.id() + ":" + requestedResult.destination().getAbsolutePath());
        }
        File problemsReport = new File(this.getTemporaryDir(), "nfrt-problem-report.json");
        args.add("--problems-report");
        args.add(problemsReport.getAbsolutePath());
        try {
            this.run(args);
        }
        finally {
            this.reportProblems(problemsReport);
        }
    }

    private void reportProblems(File problemsReport) {
        List<Problem> problems;
        if (!problemsReport.exists()) {
            return;
        }
        try {
            problems = FileProblemReporter.loadRecords(problemsReport.toPath());
        }
        catch (IOException e) {
            this.getLogger().warn("Failed to load NFRT problems report from {}", (Object)problemsReport, (Object)e);
            return;
        }
        for (Problem problem : problems) {
            ProblemReportingUtil.report(this.getProblems(), problem);
        }
    }

    record RequestedResult(String id, File destination) {
    }
}

