/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.tasks;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import net.neoforged.moddevgradle.legacyforge.tasks.RemapOperation;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.process.ExecOperations;

public abstract class RemapJar
extends Jar {
    @Nested
    public abstract RemapOperation getRemapOperation();

    @Optional
    @InputFiles
    public abstract ConfigurableFileCollection getLibraries();

    @InputFile
    public abstract RegularFileProperty getInput();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    public RemapJar() {
        this.getRemapOperation().getLogFile().set(new File(this.getTemporaryDir(), "console.log"));
    }

    @TaskAction
    public void copy() {
        try {
            this.getRemapOperation().execute(this.getExecOperations(), (File)this.getInput().getAsFile().get(), ((RegularFile)this.getArchiveFile().get()).getAsFile(), (FileCollection)this.getLibraries());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

