/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.dsl;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.Nullable;

public abstract class LegacyForgeModdingSettings {
    @Nullable
    private String neoForgeVersion;
    @Nullable
    private String forgeVersion;
    @Nullable
    private String mcpVersion;
    private Set<SourceSet> enabledSourceSets = new HashSet<SourceSet>();
    private boolean disableRecompilation = false;
    private boolean obfuscateJar = true;

    @Inject
    public LegacyForgeModdingSettings(Project project) {
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        this.enabledSourceSets.add(mainSourceSet);
    }

    @Nullable
    public String getNeoForgeVersion() {
        return this.neoForgeVersion;
    }

    @Nullable
    public String getForgeVersion() {
        return this.forgeVersion;
    }

    @Nullable
    public String getMcpVersion() {
        return this.mcpVersion;
    }

    public void setNeoForgeVersion(String version) {
        this.neoForgeVersion = version;
    }

    public void setForgeVersion(String version) {
        this.forgeVersion = version;
    }

    public void setMcpVersion(String version) {
        this.mcpVersion = version;
    }

    public Set<SourceSet> getEnabledSourceSets() {
        return this.enabledSourceSets;
    }

    public void setEnabledSourceSets(Set<SourceSet> enabledSourceSets) {
        this.enabledSourceSets = enabledSourceSets;
    }

    public boolean isDisableRecompilation() {
        return this.disableRecompilation;
    }

    public void setDisableRecompilation(boolean disableRecompilation) {
        this.disableRecompilation = disableRecompilation;
    }

    public boolean isObfuscateJar() {
        return this.obfuscateJar;
    }

    public void setObfuscateJar(boolean obfuscateJar) {
        this.obfuscateJar = obfuscateJar;
    }
}

