/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.elc.configs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.moddev.shadow.net.neoforged.elc.attributes.EAttribute;
import net.neoforged.moddev.shadow.net.neoforged.elc.attributes.EValue;
import net.neoforged.moddev.shadow.net.neoforged.elc.configs.LaunchConfig;
import net.neoforged.moddev.shadow.net.neoforged.elc.util.Util;
import org.jetbrains.annotations.Nullable;

public final class GradleLaunchConfig
implements LaunchConfig {
    private final List<String> tasks;
    private final String workingDirectory;
    private final String gradleDistribution;
    private final boolean offlineMode;
    private final boolean showConsoleView;
    private final boolean showExecutionView;
    @Nullable
    private final String gradleUserHome;
    @Nullable
    private final String javaHome;
    private final List<String> arguments;
    private final List<String> jvmArguments;
    private final boolean overrideWorkspace;

    public GradleLaunchConfig(List<String> tasks, String workingDirectory, String gradleDistribution, boolean offlineMode, boolean showConsoleView, boolean showExecutionView, @Nullable String gradleUserHome, @Nullable String javaHome, List<String> arguments, List<String> jvmArguments, boolean overrideWorkspace) {
        this.tasks = tasks;
        this.workingDirectory = workingDirectory;
        this.gradleDistribution = gradleDistribution;
        this.offlineMode = offlineMode;
        this.showConsoleView = showConsoleView;
        this.showExecutionView = showExecutionView;
        this.gradleUserHome = gradleUserHome;
        this.javaHome = javaHome;
        this.arguments = arguments;
        this.jvmArguments = jvmArguments;
        this.overrideWorkspace = overrideWorkspace;
    }

    @Override
    public String getType() {
        return "org.eclipse.buildship.core.launch.runconfiguration";
    }

    @Override
    public List<EAttribute> bakeAttributes() {
        ArrayList<EAttribute> attributes = new ArrayList<EAttribute>();
        attributes.add(EAttribute.of("tasks", this.tasks.stream().map(EValue::of).collect(Collectors.toList())));
        if (!this.workingDirectory.isEmpty()) {
            attributes.add(EAttribute.of("working_dir", this.workingDirectory));
        }
        attributes.add(EAttribute.of("gradle_distribution", this.gradleDistribution));
        attributes.add(EAttribute.of("offline_mode", this.offlineMode));
        attributes.add(EAttribute.of("show_console_view", this.showConsoleView));
        attributes.add(EAttribute.of("show_execution_view", this.showExecutionView));
        if (this.gradleUserHome != null) {
            attributes.add(EAttribute.of("gradle_user_home", this.gradleUserHome));
        }
        if (this.javaHome != null) {
            attributes.add(EAttribute.of("java_home", this.javaHome));
        }
        attributes.add(EAttribute.of("arguments", this.arguments.stream().map(EValue::of).collect(Collectors.toList())));
        attributes.add(EAttribute.of("jvm_arguments", this.jvmArguments.stream().map(EValue::of).collect(Collectors.toList())));
        attributes.add(EAttribute.of("override_workspace_settings", this.overrideWorkspace));
        return attributes;
    }

    public static Builder builder(String project) {
        return new Builder(project);
    }

    public String toString() {
        return "GradleLaunchConfig[" + "tasks=" + this.tasks + "," + "workingDirectory=" + this.workingDirectory + "," + "gradleDistribution=" + this.gradleDistribution + "," + "offlineMode=" + this.offlineMode + "," + "showConsoleView=" + this.showConsoleView + "," + "showExecutionView=" + this.showExecutionView + "," + "gradleUserHome=" + this.gradleUserHome + "," + "javaHome=" + this.javaHome + "," + "arguments=" + this.arguments + "," + "jvmArguments=" + this.jvmArguments + "," + "overrideWorkspace=" + this.overrideWorkspace + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.tasks != null ? this.tasks.hashCode() : 0);
        result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
        result = 31 * result + (this.gradleDistribution != null ? this.gradleDistribution.hashCode() : 0);
        result = 31 * result + (this.offlineMode ? 1 : 0);
        result = 31 * result + (this.showConsoleView ? 1 : 0);
        result = 31 * result + (this.showExecutionView ? 1 : 0);
        result = 31 * result + (this.gradleUserHome != null ? this.gradleUserHome.hashCode() : 0);
        result = 31 * result + (this.javaHome != null ? this.javaHome.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.jvmArguments != null ? this.jvmArguments.hashCode() : 0);
        result = 31 * result + (this.overrideWorkspace ? 1 : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((GradleLaunchConfig)arg0).tasks, this.tasks)) {
            return false;
        }
        if (!Objects.equals(((GradleLaunchConfig)arg0).workingDirectory, this.workingDirectory)) {
            return false;
        }
        if (!Objects.equals(((GradleLaunchConfig)arg0).gradleDistribution, this.gradleDistribution)) {
            return false;
        }
        if (((GradleLaunchConfig)arg0).offlineMode != this.offlineMode) {
            return false;
        }
        if (((GradleLaunchConfig)arg0).showConsoleView != this.showConsoleView) {
            return false;
        }
        if (((GradleLaunchConfig)arg0).showExecutionView != this.showExecutionView) {
            return false;
        }
        if (!Objects.equals(((GradleLaunchConfig)arg0).gradleUserHome, this.gradleUserHome)) {
            return false;
        }
        if (!Objects.equals(((GradleLaunchConfig)arg0).javaHome, this.javaHome)) {
            return false;
        }
        if (!Objects.equals(((GradleLaunchConfig)arg0).arguments, this.arguments)) {
            return false;
        }
        if (!Objects.equals(((GradleLaunchConfig)arg0).jvmArguments, this.jvmArguments)) {
            return false;
        }
        return ((GradleLaunchConfig)arg0).overrideWorkspace == this.overrideWorkspace;
        {
        }
    }

    public List<String> tasks() {
        return this.tasks;
    }

    public String workingDirectory() {
        return this.workingDirectory;
    }

    public String gradleDistribution() {
        return this.gradleDistribution;
    }

    public boolean offlineMode() {
        return this.offlineMode;
    }

    public boolean showConsoleView() {
        return this.showConsoleView;
    }

    public boolean showExecutionView() {
        return this.showExecutionView;
    }

    @Nullable
    public String gradleUserHome() {
        return this.gradleUserHome;
    }

    @Nullable
    public String javaHome() {
        return this.javaHome;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public List<String> jvmArguments() {
        return this.jvmArguments;
    }

    public boolean overrideWorkspace() {
        return this.overrideWorkspace;
    }

    public static class Keys {
        public static final String TASKS = "tasks";
        public static final String WORKING_DIR = "working_dir";
        public static final String GRADLE_DIST = "gradle_distribution";
        public static final String OFFLINE_MODE = "offline_mode";
        public static final String SHOW_CONSOLE = "show_console_view";
        public static final String SHOW_EXECUTIONS = "show_execution_view";
        public static final String GRADLE_USER_HOME = "gradle_user_home";
        public static final String JAVA_HOME = "java_home";
        public static final String ARGUMENTS = "arguments";
        public static final String JVM_ARGS = "jvm_arguments";
        public static final String OVERRIDE_WORKSPACE = "override_workspace_settings";
    }

    public static final class Builder {
        private String project;
        private final List<String> tasks = new ArrayList<String>();
        private String workingDirectory = "";
        private String gradleDistribution = "GRADLE_DISTRIBUTION(WRAPPER)";
        private boolean offlineMode = false;
        private boolean showConsoleView = true;
        private boolean showExecutionView = true;
        @Nullable
        private String gradleUserHome;
        @Nullable
        private String javaHome;
        private final List<String> arguments = new ArrayList<String>();
        private final List<String> jvmArguments = new ArrayList<String>();
        private boolean overrideWorkspace = false;

        public Builder(String project) {
            this.project = project;
        }

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder tasks(String ... tasks) {
            for (String task : tasks) {
                this.tasks.add(task);
            }
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder gradleDist(String gradleDist) {
            this.gradleDistribution = gradleDist;
            return this.overrideWorkspaceSettings(true);
        }

        public Builder offlineMode(boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this.overrideWorkspaceSettings(true);
        }

        public Builder showConsole(boolean showConsole) {
            this.showConsoleView = showConsole;
            return this.overrideWorkspaceSettings(true);
        }

        public Builder showExecutions(boolean showExecutions) {
            this.showExecutionView = showExecutions;
            return this.overrideWorkspaceSettings(true);
        }

        public Builder gradleUserHome(@Nullable String gradleUserHome) {
            this.gradleUserHome = gradleUserHome;
            return this.overrideWorkspaceSettings(true);
        }

        public Builder javaHome(@Nullable String javaHome) {
            this.javaHome = javaHome;
            return this.overrideWorkspaceSettings(true);
        }

        public Builder args(String ... args) {
            for (String arg : args) {
                this.arguments.add(arg);
            }
            return this.overrideWorkspaceSettings(true);
        }

        public Builder property(String key, Object value) {
            return this.args("-P" + key + "=" + value.toString());
        }

        public Builder jvmArgs(String ... args) {
            for (String arg : args) {
                this.jvmArguments.add(arg);
            }
            return this.overrideWorkspaceSettings(true);
        }

        public Builder overrideWorkspaceSettings(boolean override) {
            this.overrideWorkspace = override;
            return this;
        }

        public GradleLaunchConfig build() {
            String workingDir = this.workingDirectory;
            if (workingDir.isEmpty()) {
                workingDir = "${workspace_loc:" + this.project + "}";
            }
            return new GradleLaunchConfig(Util.copyOf(this.tasks), workingDir, this.gradleDistribution, this.offlineMode, this.showConsoleView, this.showExecutionView, this.gradleUserHome, this.javaHome, Util.copyOf(this.arguments), Util.copyOf(this.jvmArguments), this.overrideWorkspace);
        }
    }
}

