/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.neoforged.minecraftdependencies.MinecraftDistribution;
import net.neoforged.moddevgradle.dsl.InternalModelHelper;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.CreateLaunchScriptTask;
import net.neoforged.moddevgradle.internal.IdeIntegration;
import net.neoforged.moddevgradle.internal.ModDevArtifactsWorkflow;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.ModdingDependencies;
import net.neoforged.moddevgradle.internal.PrepareRun;
import net.neoforged.moddevgradle.internal.PrepareTest;
import net.neoforged.moddevgradle.internal.RunGameTask;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.moddevgradle.internal.WriteLegacyClasspath;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.VersionCapabilitiesInternal;
import net.neoforged.nfrtgradle.CreateMinecraftArtifacts;
import net.neoforged.nfrtgradle.DownloadAssets;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.JvmTestSuiteTarget;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.testing.base.TestingExtension;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;

public class ModDevRunWorkflow {
    private static final String EXTENSION_NAME = "__internal_modDevRunWorkflow";
    static final String JUNIT_GAME_DIR = "build/minecraft-junit";
    private final Project project;
    private final Branding branding;
    @Nullable
    private final ModuleDependency modulePathDependency;
    @Nullable
    private final ModuleDependency testFixturesDependency;
    private final ModuleDependency gameLibrariesDependency;
    private final Configuration userDevConfigOnly;

    private ModDevRunWorkflow(Project project, Branding branding, ModDevArtifactsWorkflow artifactsWorkflow, @Nullable ModuleDependency modulePathDependency, @Nullable ModuleDependency runTypesConfigDependency, @Nullable ModuleDependency testFixturesDependency, ModuleDependency gameLibrariesDependency, DomainObjectCollection<RunModel> runs, VersionCapabilitiesInternal versionCapabilities) {
        Consumer<Configuration> configureLegacyClasspath;
        this.project = project;
        this.branding = branding;
        this.modulePathDependency = modulePathDependency;
        this.testFixturesDependency = testFixturesDependency;
        this.gameLibrariesDependency = gameLibrariesDependency;
        ConfigurationContainer configurations = project.getConfigurations();
        this.userDevConfigOnly = (Configuration)configurations.create("neoForgeConfigOnly", spec -> {
            spec.setDescription("Resolves exclusively the NeoForge userdev JSON for configuring runs");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.setTransitive(false);
            if (runTypesConfigDependency != null) {
                spec.getDependencies().add((Object)runTypesConfigDependency);
            }
        });
        if (versionCapabilities.legacyClasspath()) {
            Configuration additionalClasspath = (Configuration)configurations.create("additionalRuntimeClasspath", spec -> {
                spec.setDescription("Contains dependencies of every run, that should not be considered boot classpath modules.");
                spec.setCanBeResolved(true);
                spec.setCanBeConsumed(false);
                spec.getDependencies().add((Object)gameLibrariesDependency);
                if (artifactsWorkflow.versionCapabilities().needsNeoForgeInMinecraftJar()) {
                    ModDevRunWorkflow.addClientResources(project, spec, artifactsWorkflow.createArtifacts());
                }
                if (!versionCapabilities.modLocatorRework()) {
                    spec.getDependencies().addLater(artifactsWorkflow.minecraftClassesDependency());
                }
            });
            configureLegacyClasspath = legacyClassPath -> legacyClassPath.extendsFrom(new Configuration[]{additionalClasspath});
        } else {
            Configuration additionalClasspath = (Configuration)configurations.create("additionalRuntimeClasspath");
            ModDevRunWorkflow.forbidAdditionalRuntimeDependencies(additionalClasspath, versionCapabilities);
            configureLegacyClasspath = legacyClassPath -> {
                throw new IllegalStateException("There is no legacy classpath for Minecraft " + versionCapabilities.minecraftVersion());
            };
        }
        ModDevRunWorkflow.setupRuns(project, branding, artifactsWorkflow.modDevBuildDir(), runs, this.userDevConfigOnly, modulePath -> {
            if (modulePathDependency != null) {
                modulePath.getDependencies().add((Object)modulePathDependency);
            }
        }, configureLegacyClasspath, (Provider<RegularFile>)artifactsWorkflow.downloadAssets().flatMap(DownloadAssets::getAssetPropertiesFile), versionCapabilities);
    }

    private static void forbidAdditionalRuntimeDependencies(Configuration configuration, VersionCapabilitiesInternal versionCapabilities) {
        configuration.getDependencies().all(dependency -> {
            throw new IllegalStateException(String.format("Tried to add a dependency to configuration %s, but there is no additional classpath anymore for Minecraft %s. Add the dependency to a standard configuration such as implementation or runtimeOnly. Dependency: %s", configuration, versionCapabilities.minecraftVersion(), dependency));
        });
    }

    public static ModDevRunWorkflow get(Project project) {
        ModDevRunWorkflow workflow = ExtensionUtils.findExtension((ExtensionAware)project, EXTENSION_NAME, ModDevRunWorkflow.class);
        if (workflow == null) {
            throw new InvalidUserCodeException("Please enable the modding plugin first by setting a version");
        }
        return workflow;
    }

    public static ModDevRunWorkflow create(Project project, Branding branding, ModDevArtifactsWorkflow artifactsWorkflow, DomainObjectCollection<RunModel> runs) {
        ModdingDependencies dependencies = artifactsWorkflow.dependencies();
        VersionCapabilitiesInternal versionCapabilites = artifactsWorkflow.versionCapabilities();
        ModDevRunWorkflow workflow = new ModDevRunWorkflow(project, branding, artifactsWorkflow, dependencies.modulePathDependency(), dependencies.runTypesConfigDependency(), dependencies.testFixturesDependency(), dependencies.gameLibrariesDependency(), runs, versionCapabilites);
        project.getExtensions().add(EXTENSION_NAME, (Object)workflow);
        return workflow;
    }

    public void configureTesting(Provider<ModModel> testedMod, Provider<Set<ModModel>> loadedMods) {
        TestingExtension testing = (TestingExtension)this.project.getExtensions().getByType(TestingExtension.class);
        JvmTestSuite testSuite = (JvmTestSuite)testing.getSuites().getByName("test");
        SourceSet testSourceSet = testSuite.getSources();
        ModDevArtifactsWorkflow artifactsWorkflow = ModDevArtifactsWorkflow.get(this.project);
        artifactsWorkflow.addToSourceSet(testSourceSet);
        ConfigurationContainer configurations = this.project.getConfigurations();
        if (this.testFixturesDependency != null) {
            configurations.getByName(testSourceSet.getRuntimeOnlyConfigurationName(), configuration -> configuration.getDependencies().add((Object)this.testFixturesDependency));
        }
        if (testSuite.getTargets().size() > 1) {
            throw new InvalidUserCodeException("MDG currently only supports test suites with a single test task.");
        }
        for (JvmTestSuiteTarget target : testSuite.getTargets()) {
            ModDevRunWorkflow.setupTestTask(this.project, this.branding, this.userDevConfigOnly, (TaskProvider<Test>)target.getTestTask(), loadedMods, testedMod, artifactsWorkflow.modDevBuildDir(), modulePath -> {
                if (this.modulePathDependency != null) {
                    modulePath.getDependencies().add((Object)this.modulePathDependency);
                }
            }, legacyClassPath -> {
                legacyClassPath.getDependencies().add((Object)this.gameLibrariesDependency);
                if (artifactsWorkflow.versionCapabilities().needsNeoForgeInMinecraftJar()) {
                    ModDevRunWorkflow.addClientResources(this.project, legacyClassPath, artifactsWorkflow.createArtifacts());
                }
            }, (Provider<RegularFile>)artifactsWorkflow.downloadAssets().flatMap(DownloadAssets::getAssetPropertiesFile), artifactsWorkflow.versionCapabilities());
        }
    }

    private static void addClientResources(Project project, Configuration spec, TaskProvider<CreateMinecraftArtifacts> createArtifacts) {
        spec.getDependencies().add((Object)project.getDependencyFactory().create((FileCollection)project.files(new Object[]{createArtifacts.flatMap(CreateMinecraftArtifacts::getResourcesArtifact)})));
    }

    public static void setupRuns(Project project, Branding branding, Provider<Directory> argFileDir, DomainObjectCollection<RunModel> runs, Object runTemplatesSourceFile, Consumer<Configuration> configureModulePath, Consumer<Configuration> configureLegacyClasspath, Provider<RegularFile> assetPropertiesFile, VersionCapabilitiesInternal versionCapabilities) {
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        IdeIntegration ideIntegration = IdeIntegration.of(project, branding);
        Provider supplyDevLogin = project.provider(() -> runs.stream().anyMatch(model -> (Boolean)model.getDevLogin().get()));
        Configuration devLaunchConfig = (Configuration)project.getConfigurations().create("devLaunchConfig", spec -> {
            spec.setDescription("This configuration is used to inject DevLaunch and optionally DevLogin into the runtime classpaths of runs.");
            spec.getDependencies().add((Object)dependencyFactory.create((CharSequence)"net.neoforged:DevLaunch:1.0.2"));
            spec.getDependencies().addAllLater(supplyDevLogin.map(supply -> supply != false ? List.of(dependencyFactory.create((CharSequence)"net.covers1624:DevLogin:0.1.0.5")) : List.of()));
        });
        TaskProvider createLaunchScriptsTask = project.getTasks().register("createLaunchScripts", Task.class, task -> {
            task.setGroup(branding.publicTaskGroup());
            task.setDescription("Creates batch files/shell scripts to launch the game from outside of Gradle (i.e. Renderdoc, NVidia Nsight, etc.)");
        });
        IdentityHashMap<RunModel, TaskProvider<PrepareRun>> prepareRunTasks = new IdentityHashMap<RunModel, TaskProvider<PrepareRun>>();
        runs.all(run -> {
            if (!versionCapabilities.modLocatorRework()) {
                run.getEnvironment().put((Object)"MOD_CLASSES", RunUtils.getGradleModFoldersProvider(project, run.getLoadedMods(), null).getClassesArgument());
            }
            TaskProvider<PrepareRun> prepareRunTask = ModDevRunWorkflow.setupRunInGradle(project, branding, argFileDir, run, runTemplatesSourceFile, configureModulePath, configureLegacyClasspath, assetPropertiesFile, devLaunchConfig, versionCapabilities, (TaskProvider<Task>)createLaunchScriptsTask);
            prepareRunTasks.put((RunModel)run, prepareRunTask);
        });
        ideIntegration.configureRuns((Map<RunModel, TaskProvider<PrepareRun>>)prepareRunTasks, (Iterable<RunModel>)runs);
    }

    private static TaskProvider<PrepareRun> setupRunInGradle(Project project, Branding branding, Provider<Directory> argFileDir, RunModel run, Object runTemplatesFile, Consumer<Configuration> configureModulePath, Consumer<Configuration> configureLegacyClasspath, Provider<RegularFile> assetPropertiesFile, Configuration devLaunchConfig, VersionCapabilitiesInternal versionCapabilities, TaskProvider<Task> createLaunchScriptsTask) {
        RegularFileProperty legacyClasspathFile;
        IdeIntegration ideIntegration = IdeIntegration.of(project, branding);
        ConfigurationContainer configurations = project.getConfigurations();
        JavaPluginExtension javaExtension = ExtensionUtils.getExtension((ExtensionAware)project, "java", JavaPluginExtension.class);
        TaskContainer tasks = project.getTasks();
        Provider runtimeClasspathConfig = run.getSourceSet().map(SourceSet::getRuntimeClasspathConfigurationName).map(arg_0 -> ((ConfigurationContainer)configurations).getByName(arg_0));
        project.afterEvaluate(ignored -> ((Configuration)runtimeClasspathConfig.get()).extendsFrom(new Configuration[]{devLaunchConfig}));
        Provider<String> type = RunUtils.getRequiredType(project, run);
        Configuration modulePathConfiguration = (Configuration)project.getConfigurations().create(InternalModelHelper.nameOfRun(run, "", "modulesOnly"), spec -> {
            spec.setDescription("Libraries that should be placed on the JVMs boot module path for run " + run.getName() + ".");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith((Configuration)runtimeClasspathConfig.get());
            configureModulePath.accept((Configuration)spec);
        });
        if (versionCapabilities.legacyClasspath()) {
            Configuration legacyClasspathConfiguration = (Configuration)configurations.create(InternalModelHelper.nameOfRun(run, "", "legacyClasspath"), spec -> {
                spec.setDescription("Contains all dependencies of the " + run.getName() + " run that should not be considered boot classpath modules.");
                spec.setCanBeResolved(true);
                spec.setCanBeConsumed(false);
                spec.shouldResolveConsistentlyWith((Configuration)runtimeClasspathConfig.get());
                spec.attributes(attributes -> {
                    attributes.attributeProvider(MinecraftDistribution.ATTRIBUTE, type.map(t -> {
                        String name = t.equals("client") || t.equals("data") || t.equals("clientData") ? "client" : "server";
                        return (MinecraftDistribution)project.getObjects().named(MinecraftDistribution.class, name);
                    }));
                    ModDevRunWorkflow.setNamedAttribute(project, attributes, Usage.USAGE_ATTRIBUTE, "java-runtime");
                });
                configureLegacyClasspath.accept((Configuration)spec);
                spec.extendsFrom(new Configuration[]{run.getAdditionalRuntimeClasspathConfiguration()});
            });
            TaskProvider writeLcpTask = tasks.register(InternalModelHelper.nameOfRun(run, "write", "legacyClasspath"), WriteLegacyClasspath.class, writeLcp -> {
                writeLcp.setGroup(branding.internalTaskGroup());
                writeLcp.setDescription("Writes the legacyClasspath file for the " + run.getName() + " Minecraft run, containing all dependencies that shouldn't be considered boot modules.");
                writeLcp.getLegacyClasspathFile().set(argFileDir.map(dir -> dir.file(InternalModelHelper.nameOfRun(run, "", "legacyClasspath") + ".txt")));
                writeLcp.addEntries(legacyClasspathConfiguration);
            });
            legacyClasspathFile = ((WriteLegacyClasspath)((Object)writeLcpTask.get())).getLegacyClasspathFile();
        } else {
            ModDevRunWorkflow.forbidAdditionalRuntimeDependencies(run.getAdditionalRuntimeClasspathConfiguration(), versionCapabilities);
            legacyClasspathFile = null;
        }
        TaskProvider prepareRunTask = tasks.register(InternalModelHelper.nameOfRun(run, "prepare", "run"), PrepareRun.class, task -> {
            task.setGroup(branding.internalTaskGroup());
            task.setDescription("Prepares all files needed to launch the " + run.getName() + " Minecraft run.");
            task.getGameDirectory().set((Provider)run.getGameDirectory());
            task.getVmArgsFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.VMARGS));
            task.getProgramArgsFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.PROGRAMARGS));
            task.getLog4jConfigFileOverride().set((Provider)run.getLoggingConfigFile());
            task.getLog4jConfigFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.LOG4J_CONFIG));
            task.getRunType().set(run.getType());
            task.getRunTypeTemplatesSource().from(new Object[]{runTemplatesFile});
            task.getModules().from(new Object[]{modulePathConfiguration});
            if (legacyClasspathFile != null) {
                task.getLegacyClasspathFile().set(legacyClasspathFile);
            }
            task.getAssetProperties().set(assetPropertiesFile);
            task.getSystemProperties().set(run.getSystemProperties().map(props -> {
                props = new HashMap(props);
                return props;
            }));
            task.getMainClass().set(run.getMainClass());
            task.getProgramArguments().set(run.getProgramArguments());
            task.getJvmArguments().set(run.getJvmArguments());
            task.getGameLogLevel().set(run.getLogLevel());
            task.getDevLogin().set(run.getDevLogin());
            task.getVersionCapabilities().set((Object)versionCapabilities);
        });
        ideIntegration.runTaskOnProjectSync(prepareRunTask);
        TaskProvider launchScriptTask = tasks.register(InternalModelHelper.nameOfRun(run, "create", "launchScript"), CreateLaunchScriptTask.class, task -> {
            task.setGroup(branding.internalTaskGroup());
            task.setDescription("Creates a bash/shell-script to launch the " + run.getName() + " Minecraft run from outside Gradle or your IDE.");
            task.getWorkingDirectory().set(run.getGameDirectory().map(d -> d.getAsFile().getAbsolutePath()));
            task.getRuntimeClasspath().from(new Object[]{run.getSourceSet().map(SourceSet::getRuntimeClasspath)});
            task.getLaunchScript().set(RunUtils.getLaunchScript(argFileDir, run));
            task.getClasspathArgsFile().set(RunUtils.getArgFile(argFileDir, run, RunUtils.RunArgFile.CLASSPATH));
            task.getVmArgsFile().set(((PrepareRun)((Object)((Object)prepareRunTask.get()))).getVmArgsFile().map(d -> d.getAsFile().getAbsolutePath()));
            task.getProgramArgsFile().set(((PrepareRun)((Object)((Object)prepareRunTask.get()))).getProgramArgsFile().map(d -> d.getAsFile().getAbsolutePath()));
            task.getEnvironment().set(run.getEnvironment());
            task.getModFolders().set((Object)RunUtils.getGradleModFoldersProvider(project, run.getLoadedMods(), null));
        });
        createLaunchScriptsTask.configure(task -> task.dependsOn(new Object[]{launchScriptTask}));
        tasks.register(InternalModelHelper.nameOfRun(run, "run", ""), RunGameTask.class, task -> {
            task.setGroup(branding.publicTaskGroup());
            task.setDescription("Runs the " + run.getName() + " Minecraft run configuration.");
            JavaToolchainService toolchainService = ExtensionUtils.findExtension((ExtensionAware)project, "javaToolchains", JavaToolchainService.class);
            task.getJavaLauncher().set(toolchainService.launcherFor(spec -> spec.getLanguageVersion().set((Provider)javaExtension.getToolchain().getLanguageVersion())));
            task.getClasspathProvider().from(new Object[]{run.getSourceSet().map(SourceSet::getRuntimeClasspath)});
            task.getGameDirectory().set((Provider)run.getGameDirectory());
            task.getEnvironmentProperty().set(run.getEnvironment());
            task.jvmArgs(new Object[]{RunUtils.getArgFileParameter((RegularFile)((PrepareRun)((Object)((Object)prepareRunTask.get()))).getVmArgsFile().get()).replace("\\", "\\\\")});
            task.getMainClass().set((Object)"net.neoforged.devlaunch.Main");
            task.args(new Object[]{RunUtils.getArgFileParameter((RegularFile)((PrepareRun)((Object)((Object)prepareRunTask.get()))).getProgramArgsFile().get()).replace("\\", "\\\\")});
            task.dependsOn(new Object[]{prepareRunTask});
            task.dependsOn(new Object[]{run.getTasksBefore()});
            task.getJvmArgumentProviders().add(RunUtils.getGradleModFoldersProvider(project, run.getLoadedMods(), null));
        });
        return prepareRunTask;
    }

    static void setupTestTask(Project project, Branding branding, Object runTemplatesSourceFile, TaskProvider<Test> testTask, Provider<Set<ModModel>> loadedMods, Provider<ModModel> testedMod, Provider<Directory> argFileDir, Consumer<Configuration> configureModulePath, Consumer<Configuration> configureLegacyClasspath, Provider<RegularFile> assetPropertiesFile, VersionCapabilitiesInternal versionCapabilities) {
        RegularFileProperty legacyClasspathFile;
        File gameDirectory = new File(project.getProjectDir(), JUNIT_GAME_DIR);
        IdeIntegration ideIntegration = IdeIntegration.of(project, branding);
        TaskContainer tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration testRuntimeClasspath = configurations.getByName("testRuntimeClasspath");
        Configuration neoForgeModDevModules = (Configuration)project.getConfigurations().create("neoForgeTestModules", spec -> {
            spec.setDescription("Libraries that should be placed on the JVMs boot module path for unit tests.");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith(testRuntimeClasspath);
            configureModulePath.accept((Configuration)spec);
        });
        Provider runArgsDir = argFileDir.map(dir -> dir.dir("junit"));
        if (versionCapabilities.legacyClasspath()) {
            Configuration legacyClasspathConfiguration = (Configuration)configurations.create("neoForgeTestLibraries", spec -> {
                spec.setDescription("Contains the legacy classpath of unit tests.");
                spec.setCanBeResolved(true);
                spec.setCanBeConsumed(false);
                spec.shouldResolveConsistentlyWith(testRuntimeClasspath);
                spec.attributes(attributes -> {
                    ModDevRunWorkflow.setNamedAttribute(project, attributes, MinecraftDistribution.ATTRIBUTE, "client");
                    ModDevRunWorkflow.setNamedAttribute(project, attributes, Usage.USAGE_ATTRIBUTE, "java-runtime");
                });
                configureLegacyClasspath.accept((Configuration)spec);
            });
            TaskProvider writeLcpTask = tasks.register("writeNeoForgeTestClasspath", WriteLegacyClasspath.class, writeLcp -> {
                writeLcp.setGroup(branding.internalTaskGroup());
                writeLcp.setDescription("Writes the legacyClasspath file for the test run, containing all dependencies that shouldn't be considered boot modules.");
                writeLcp.getLegacyClasspathFile().convention(runArgsDir.map(dir -> dir.file("legacyClasspath.txt")));
                writeLcp.addEntries(legacyClasspathConfiguration);
            });
            legacyClasspathFile = ((WriteLegacyClasspath)((Object)writeLcpTask.get())).getLegacyClasspathFile();
        } else {
            legacyClasspathFile = null;
        }
        Provider vmArgsFile = runArgsDir.map(dir -> dir.file("vmArgs.txt"));
        Provider programArgsFile = runArgsDir.map(dir -> dir.file("programArgs.txt"));
        Provider log4j2ConfigFile = runArgsDir.map(dir -> dir.file("log4j2.xml"));
        TaskProvider prepareTask = tasks.register("prepareNeoForgeTestFiles", PrepareTest.class, arg_0 -> ModDevRunWorkflow.lambda$setupTestTask$40(branding, gameDirectory, vmArgsFile, programArgsFile, log4j2ConfigFile, runTemplatesSourceFile, neoForgeModDevModules, (Provider)legacyClasspathFile, assetPropertiesFile, arg_0));
        ideIntegration.runTaskOnProjectSync(prepareTask);
        testTask.configure(task -> {
            task.dependsOn(new Object[]{prepareTask});
            task.systemProperty("fml.junit.argsfile", (Object)((RegularFile)programArgsFile.get()).getAsFile().getAbsolutePath());
            task.jvmArgs(new Object[]{RunUtils.getArgFileParameter((RegularFile)vmArgsFile.get())});
            ModFoldersProvider modFoldersProvider = RunUtils.getGradleModFoldersProvider(project, loadedMods, testedMod);
            task.getJvmArgumentProviders().add(modFoldersProvider);
        });
        project.afterEvaluate(p -> testTask.configure(task -> task.setWorkingDir(gameDirectory)));
        ideIntegration.configureTesting(loadedMods, testedMod, (Provider<Directory>)runArgsDir, gameDirectory, (Provider<RegularFile>)programArgsFile, (Provider<RegularFile>)vmArgsFile);
    }

    private static <T extends Named> void setNamedAttribute(Project project, AttributeContainer attributes, Attribute<T> attribute, String value) {
        attributes.attribute(attribute, (Object)project.getObjects().named(attribute.getType(), value));
    }

    private static /* synthetic */ void lambda$setupTestTask$40(Branding branding, File gameDirectory, Provider vmArgsFile, Provider programArgsFile, Provider log4j2ConfigFile, Object runTemplatesSourceFile, Configuration neoForgeModDevModules, Provider legacyClasspathFile, Provider assetPropertiesFile, PrepareTest task) {
        task.setGroup(branding.internalTaskGroup());
        task.setDescription("Prepares all files needed to run the JUnit test task.");
        task.getGameDirectory().set(gameDirectory);
        task.getVmArgsFile().set(vmArgsFile);
        task.getProgramArgsFile().set(programArgsFile);
        task.getLog4jConfigFile().set(log4j2ConfigFile);
        task.getRunTypeTemplatesSource().from(new Object[]{runTemplatesSourceFile});
        task.getModules().from(new Object[]{neoForgeModDevModules});
        if (legacyClasspathFile != null) {
            task.getLegacyClasspathFile().set(legacyClasspathFile);
        }
        task.getAssetProperties().set(assetPropertiesFile);
        task.getGameLogLevel().set((Object)Level.INFO);
    }
}

