/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import net.neoforged.minecraftdependencies.MinecraftDependenciesPlugin;
import net.neoforged.moddevgradle.dsl.ModDevExtension;
import net.neoforged.moddevgradle.dsl.ModdingVersionSettings;
import net.neoforged.moddevgradle.dsl.NeoForgeExtension;
import net.neoforged.moddevgradle.internal.ArtifactNamingStrategy;
import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.DataFileCollections;
import net.neoforged.moddevgradle.internal.ModDevArtifactsWorkflow;
import net.neoforged.moddevgradle.internal.ModDevRunWorkflow;
import net.neoforged.moddevgradle.internal.ModdingDependencies;
import net.neoforged.moddevgradle.internal.RepositoriesPlugin;
import net.neoforged.moddevgradle.internal.jarjar.JarJarPlugin;
import net.neoforged.moddevgradle.internal.utils.VersionCapabilitiesInternal;
import net.neoforged.nfrtgradle.NeoFormRuntimePlugin;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModDevPlugin
implements Plugin<Project> {
    private static final Logger LOG = LoggerFactory.getLogger(ModDevPlugin.class);

    public void apply(Project project) {
        project.getPlugins().apply(JavaLibraryPlugin.class);
        project.getPlugins().apply(NeoFormRuntimePlugin.class);
        project.getPlugins().apply(MinecraftDependenciesPlugin.class);
        project.getPlugins().apply(JarJarPlugin.class);
        if (!project.getGradle().getPlugins().hasPlugin(RepositoriesPlugin.class)) {
            project.getPlugins().apply(RepositoriesPlugin.class);
        } else {
            LOG.info("Not enabling NeoForged repositories since they were applied at the settings level");
        }
        DataFileCollections dataFileCollections = DataFileCollections.create(project);
        project.getExtensions().create("neoForge", NeoForgeExtension.class, new Object[]{dataFileCollections.accessTransformers().extension(), dataFileCollections.interfaceInjectionData().extension()});
    }

    public void enable(Project project, ModdingVersionSettings settings, ModDevExtension extension) {
        ModdingDependencies dependencies;
        String neoForgeVersion = settings.getVersion();
        String neoFormVersion = settings.getNeoFormVersion();
        if (neoForgeVersion == null && neoFormVersion == null) {
            throw new InvalidUserCodeException("You must specify at least a NeoForge or a NeoForm version for vanilla-only mode");
        }
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        ExternalModuleDependency neoForge = null;
        String neoForgeNotation = null;
        if (neoForgeVersion != null) {
            neoForge = dependencyFactory.create((CharSequence)("net.neoforged:neoforge:" + neoForgeVersion));
            neoForgeNotation = "net.neoforged:neoforge:" + neoForgeVersion + ":userdev";
        }
        ExternalModuleDependency neoForm = null;
        String neoFormNotation = null;
        if (neoFormVersion != null) {
            neoForm = dependencyFactory.create((CharSequence)("net.neoforged:neoform:" + neoFormVersion));
            neoFormNotation = "net.neoforged:neoform:" + neoFormVersion + "@zip";
        }
        VersionCapabilitiesInternal versionCapabilities = neoForgeVersion != null ? VersionCapabilitiesInternal.ofNeoForgeVersion(neoForgeVersion) : VersionCapabilitiesInternal.ofNeoFormVersion(neoFormVersion);
        ConfigurationContainer configurations = project.getConfigurations();
        ModdingDependencies moddingDependencies = dependencies = neoForge != null ? ModdingDependencies.create((ModuleDependency)neoForge, neoForgeNotation, (ModuleDependency)neoForm, neoFormNotation, versionCapabilities) : ModdingDependencies.createVanillaOnly((ModuleDependency)neoForm, neoFormNotation);
        ArtifactNamingStrategy artifactNamingStrategy = neoForge == null ? ArtifactNamingStrategy.createVanilla(neoFormVersion) : (versionCapabilities.needsNeoForgeInMinecraftJar() ? ArtifactNamingStrategy.createNeoForge(versionCapabilities, "neoforge", neoForgeVersion) : ArtifactNamingStrategy.createVanillaPatched(neoForgeVersion));
        ModDevArtifactsWorkflow artifacts = ModDevArtifactsWorkflow.create(project, settings.getEnabledSourceSets(), Branding.MDG, extension, dependencies, artifactNamingStrategy, configurations.getByName("accessTransformers"), configurations.getByName("interfaceInjectionData"), versionCapabilities, settings.isDisableRecompilation());
        ModDevRunWorkflow.create(project, Branding.MDG, artifacts, extension.getRuns());
    }
}

