/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.elc.attributes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.neoforged.moddev.shadow.net.neoforged.elc.attributes.EAttribute;
import net.neoforged.moddev.shadow.net.neoforged.elc.attributes.EValue;

public final class SetAttribute
implements EAttribute,
Set<EValue<?>> {
    private final String key;
    private final Set<EValue<?>> values;

    public SetAttribute(String key) {
        this(key, new HashSet());
    }

    public SetAttribute(String key, Set<EValue<?>> values) {
        this.key = key;
        this.values = values;
    }

    @Override
    public void write(XMLStreamWriter writer, XMLOutputFactory outputFactory) throws XMLStreamException {
        writer.writeStartElement("setAttribute");
        writer.writeAttribute("key", this.key);
        writer.writeCharacters("\n");
        for (EValue<?> entry : this.values) {
            writer.writeCharacters("    ");
            writer.writeStartElement("setEntry");
            writer.writeAttribute("value", entry.serialize());
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeEndElement();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public Iterator<EValue<?>> iterator() {
        return this.values.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.values.toArray(a);
    }

    @Override
    public boolean add(EValue<?> e) {
        return this.values.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.values.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends EValue<?>> c) {
        return this.values.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.values.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.values.removeAll(c);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public String toString() {
        return "SetAttribute[" + "key=" + this.key + "," + "values=" + this.values + "]";
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }

    @Override
    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((SetAttribute)arg0).key, this.key)) {
            return false;
        }
        return Objects.equals(((SetAttribute)arg0).values, this.values);
        {
        }
    }

    @Override
    public String key() {
        return this.key;
    }

    public Set<EValue<?>> values() {
        return this.values;
    }
}

