/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.vsclc;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.ConfigurationGroup;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.JavaConfiguration;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.ConsoleType;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.LocatorPathLike;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.PathLike;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.RequestType;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.ShortCmdBehaviour;

public class LaunchConfiguration
extends JavaConfiguration<LaunchConfiguration> {
    private String mainClass;
    private List<String> arguments;
    private List<String> additionalJvmArgs;
    private List<LocatorPathLike> modulePathsOverride;
    private List<LocatorPathLike> classPathsOverride;
    private Charset fileEncoding;
    private PathLike currentWorkingDirectory;
    private Map<String, String> environmentVariables;
    private PathLike environmentVariablesFile;
    private Boolean shouldStopAppEntry;
    private ConsoleType consoleType;
    private ShortCmdBehaviour shortenCommandLine;

    protected LaunchConfiguration(ConfigurationGroup parentGroup, int defaultInGroupIndex) {
        super(parentGroup, defaultInGroupIndex);
    }

    protected LaunchConfiguration() {
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.LAUNCH;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public LaunchConfiguration withMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public LaunchConfiguration withArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public List<String> getAdditionalJvmArgs() {
        return this.additionalJvmArgs;
    }

    public LaunchConfiguration withAdditionalJvmArgs(List<String> additionalJvmArgs) {
        this.additionalJvmArgs = additionalJvmArgs;
        return this;
    }

    public List<LocatorPathLike> getModulePathsOverride() {
        return this.modulePathsOverride;
    }

    public LaunchConfiguration withModulePathsOverride(List<LocatorPathLike> modulePathsOverride) {
        this.modulePathsOverride = modulePathsOverride;
        return this;
    }

    public List<LocatorPathLike> getClassPathsOverride() {
        return this.classPathsOverride;
    }

    public LaunchConfiguration withClassPathsOverride(List<LocatorPathLike> classPathsOverride) {
        this.classPathsOverride = classPathsOverride;
        return this;
    }

    public Charset getFileEncoding() {
        return this.fileEncoding;
    }

    public LaunchConfiguration withFileEncoding(Charset fileEncoding) {
        this.fileEncoding = fileEncoding;
        return this;
    }

    public PathLike getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    public LaunchConfiguration withCurrentWorkingDirectory(PathLike currentWorkingDirectory) {
        this.currentWorkingDirectory = currentWorkingDirectory;
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public LaunchConfiguration withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public PathLike getEnvironmentVariablesFile() {
        return this.environmentVariablesFile;
    }

    public LaunchConfiguration withEnvironmentVariablesFile(PathLike environmentVariablesFile) {
        this.environmentVariablesFile = environmentVariablesFile;
        return this;
    }

    public Boolean shouldStopAppEntry() {
        return this.shouldStopAppEntry;
    }

    public LaunchConfiguration withShouldStopAppEntry(Boolean shouldStopAppEntry) {
        this.shouldStopAppEntry = shouldStopAppEntry;
        return this;
    }

    public ConsoleType getConsoleType() {
        return this.consoleType;
    }

    public LaunchConfiguration withConsoleType(ConsoleType consoleType) {
        this.consoleType = consoleType;
        return this;
    }

    public ShortCmdBehaviour getShortenCommandLine() {
        return this.shortenCommandLine;
    }

    public LaunchConfiguration withShortenCommandLine(ShortCmdBehaviour shortenCommandLine) {
        this.shortenCommandLine = shortenCommandLine;
        return this;
    }

    @Override
    protected String validate() {
        if (this.mainClass == null) {
            return "Missing mainClass";
        }
        return super.validate();
    }
}

