/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.elc.attributes;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.neoforged.moddev.shadow.net.neoforged.elc.attributes.EAttribute;
import net.neoforged.moddev.shadow.net.neoforged.elc.attributes.EValue;

public final class MapAttribute
implements EAttribute,
Map<String, EValue<?>> {
    private final String key;
    private final Map<String, EValue<?>> data;

    public MapAttribute(String key) {
        this(key, new HashMap());
    }

    public MapAttribute(String key, Map<String, EValue<?>> data) {
        this.key = key;
        this.data = data;
    }

    @Override
    public void write(XMLStreamWriter writer, XMLOutputFactory outputFactory) throws XMLStreamException {
        writer.writeStartElement("mapAttribute");
        writer.writeAttribute("key", this.key);
        writer.writeCharacters("\n");
        for (Map.Entry<String, EValue<?>> entry : this.data.entrySet()) {
            writer.writeCharacters("        ");
            writer.writeStartElement("mapEntry");
            writer.writeAttribute("key", entry.getKey());
            writer.writeAttribute("value", entry.getValue().serialize());
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("    ");
        writer.writeEndElement();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public EValue<?> get(Object key) {
        return this.data.get(key);
    }

    @Override
    public EValue<?> put(String key, EValue<?> value) {
        return this.data.put(key, value);
    }

    @Override
    public EValue<?> remove(Object key) {
        return this.data.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends EValue<?>> m) {
        this.data.putAll(m);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.data.keySet();
    }

    @Override
    public Collection<EValue<?>> values() {
        return this.data.values();
    }

    @Override
    public Set<Map.Entry<String, EValue<?>>> entrySet() {
        return this.data.entrySet();
    }

    public String toString() {
        return "MapAttribute[" + "key=" + this.key + "," + "data=" + this.data + "]";
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    @Override
    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((MapAttribute)arg0).key, this.key)) {
            return false;
        }
        return Objects.equals(((MapAttribute)arg0).data, this.data);
        {
        }
    }

    @Override
    public String key() {
        return this.key;
    }

    public Map<String, EValue<?>> data() {
        return this.data;
    }
}

