/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.jarjar;

import net.neoforged.moddevgradle.internal.Branding;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.tasks.JarJar;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class JarJarPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        sourceSets.all(sourceSet -> {
            TaskProvider<JarJar> jarJarTask = JarJar.registerWithConfiguration(project, sourceSet.getTaskName(null, "jarJar"));
            jarJarTask.configure(task -> task.setGroup(Branding.MDG.internalTaskGroup()));
            String jarTaskName = sourceSet.getJarTaskName();
            project.getTasks().withType(AbstractArchiveTask.class).named(name -> name.equals(jarTaskName)).configureEach(task -> task.from(new Object[]{jarJarTask}));
        });
    }
}

